
type error =
  | FBIG
  | INVAL
  | IO
  | ISDIR
  | NOSPC
  | NXIO
  | OVERFLOW
  | PIPE
  | FAILED
exception Error of error * string
external _init : unit -> unit = "ml_g_io_channel_init_exn"
let init =
  Callback.register_exception "g_io_channel_error" (Error (FAILED, "")) ;
  _init ()

type t

external unix_new : int -> t = "_ml_g_io_channel_unix_new"
external unix_get_fd : t -> int = "ml_g_io_channel_unix_get_fd"
external new_fd : int -> t = "ml_g_io_channel_new_fd"
external new_file : string -> string -> t = "ml_g_io_channel_new_file"

external read_chars : t -> ?off:int -> ?len:int -> string -> 
  [ `NORMAL of int | `AGAIN | `EOF]
  = "ml_g_io_channel_read_chars"
external write_chars : t -> ?bytes_written:int ref -> ?off:int -> ?len:int -> string -> 
  [ `NORMAL of int | `AGAIN]
  = "ml_g_io_channel_write_chars"

external flush : t -> [ `NORMAL | `AGAIN] = "ml_g_io_channel_flush"
external seek_position : t -> int64 -> [ `CUR | `END | `SET ] -> 
  [ `NORMAL of int | `AGAIN | `EOF]
  = "ml_g_io_channel_seek_position"
external shutdown : t -> bool -> unit = "ml_g_io_channel_shutdown"

type condition = [ `ERR | `HUP | `IN | `NVAL | `OUT | `PRI ]
type source_id
external add_watch :
  ?prio:int -> t -> condition list -> (condition list -> bool) -> source_id
  = "_ml_g_io_add_watch"
external remove_watch : source_id -> unit = "_ml_g_source_remove"

external get_buffer_size : t -> int = "ml_g_io_channel_get_buffer_size"
external set_buffer_size : t -> int -> unit = "ml_g_io_channel_set_buffer_size"
external get_buffer_condition : t -> [ `IN | `OUT ] list = "ml_g_io_channel_get_buffer_condition"

type rw_flags = [ `APPEND | `NONBLOCK ]
type ro_flags = [ `IS_READABLE | `IS_SEEKABLE | `IS_WRITEABLE ]
external get_flags : t -> [ro_flags | rw_flags] list = "ml_g_io_channel_get_flags"
external set_flags : t -> rw_flags list -> unit = "ml_g_io_channel_set_flags"
let set_flags_noerr c fl =
  try set_flags c fl
  with Error _ -> ()

external get_line_term : t -> string option = "ml_g_io_channel_get_line_term"
external set_line_term : t -> string option -> unit = "ml_g_io_channel_set_line_term"
external get_buffered : t -> bool = "ml_g_io_channel_get_buffered"
external set_buffered : t -> bool -> unit = "ml_g_io_channel_set_buffered"
external get_encoding : t -> string option = "ml_g_io_channel_get_encoding"
external set_encoding : t -> string option -> unit = "ml_g_io_channel_set_encoding"
external get_close_on_unref : t -> bool = "ml_g_io_channel_get_close_on_unref"
external set_close_on_unref : t -> bool -> unit = "ml_g_io_channel_set_close_on_unref"
