// Copyright (C) 2005 Kaushik Veeraraghavan <kaushikv@gmail.com>
//
// This program is made available under the GNU GPL version 2.0 or
// greater. See the accompanying file COPYING for details.
//
// This program is distributed WITHOUT ANY WARRANTY; without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE.

#ifdef BUILD_UNIT_TESTS
#include "unit_tests.hh"

#include <string>

#include "transforms.hh"
#include "sanity.hh"

using std::string;

static string expected_SHA_MCT[] = {
  "e216836819477c7f78e0d843fe4ff1b6d6c14cd4",
  "a2dbc7a5b1c6c0a8bcb7aaa41252a6a7d0690dbc",
  "db1f9050bb863dfef4ce37186044e2eeb17ee013",
  "127fdedf43d372a51d5747c48fbffe38ef6cdf7b",
  "6e2305c2cea7e5cb55f50853bc37180340de184d",
  "2e0990a8fb803daf297d0ff03b5e9769d7555a8d",
  "f5745222c0e79b0c6912fcdccd640c233ed6592c",
  "91e80f8aa7f9d3ac94822b830325701838932e4b",
  "aacbcdd8fb7570dc79e8fecc10bacfb4857ecd96",
  "add8184aeb58f8a888fd8d9600b91937063c3ec6",
  "1040183e7a2d606dad3440f65be0f0f9b4ea9e31",
  "fb448500d74897eab49fd277f30707543e613103",
  "56fec63f4554d99ba21e1f7886c3a6454f78764d",
  "50886fe0b7c9609bbf841e9575b6d9ed7c9a6614",
  "0a74a0fd30c16f56fbd292075983c4880846fc83",
  "0427a24dd65cc8394f64deadd246f6aaa7a70d5b",
  "5ec44de2b4a3e557582bc6d910f2c24b677aa76b",
  "139533b2944f80eb3084c5beaf31665fe66e103c",
  "537009c6dbe21786b23be681d826f6a1adf70219",
  "60d437d1ed9183a3dc0995f80cd7a7fbc9cdb8a8",
  "eee88c2fa7578e3018987a352aa5399c7f362c9c",
  "878348b1e9382004a5efb58e74724fbbd135627d",
  "dbfa4af3fa2150198fe40dc3ec8e29e218d6a039",
  "d5260149d4d2ec47b51091effd8ef5ab756c45cc",
  "2fb5af636eb4729419846c598b97cb8884ff7068",
  "acece4047fef21c42b10f06ce0029ac094532b1a",
  "5d1557271394386e2424188ad5312eb4bed748e7",
  "831f08c666dc76c62e0856c9c83a89eaab8833b2",
  "55e29163105a29a8e18bf23a48d67344d07f64ba",
  "45544ca05145a1512c10600d7913b935a7ab0cca",
  "f2043dff288a09565ebab4be8353511f0e8e5fc6",
  "ca6c1f3dc6bcc4435eca5cd85ab86af9e278c509",
  "2e3457dbaf8da7f49be74aafdfe1924feb873b3a",
  "0dacb3b824236e4a08ff3a0a58a686452d6370f7",
  "cc85c476713384f1fdc3db598fb5be491e801370",
  "b20bfba2b7b3a60b90cef6c6042e45dfee532964",
  "588c9708cc452741a0de635e80fe6ce32de952d3",
  "4fe72a0f9c3a197e0d997992382e5250bfc1e4fb",
  "df4621909200093afdbae1153880ec8423837871",
  "9010252a6189a269b1ffc952a60c057b0a9787b1",
  "bb86eaef71e26bab1d0b30273053c761e4cb1c04",
  "90f3778bc7f4676101a4cac390e84b7fc6d0fc10",
  "f8d2141788753db5e06b8e758f4a50e580ff0c75",
  "def9acfee9da0f76360e7f43fc6136b8511a2dd8",
  "c35bcb013daf88ff6de59ec3b277ba3a348065c5",
  "e8c6da4b74d7ec277752d8215a6323efae178a7f",
  "3e0000e05f77ab1d8877d3d73b8645d1479941f5",
  "be5f7b46edd8fe7be2a4d4727697285fb7b57bf4",
  "7af0142d21edb705b897ab75a5ecf99ffa18e355",
  "05a5859c85acdde81e153247a4864b5b137177d1",
  "b94d3b9ca91441a49e8aa5828c56c42d231a7728",
  "6a3821763e3f3e52250deeb2f0433cd5b78f5c86",
  "75c91a2454b116da316c2a21d9280a21a1cfbc29",
  "6913fc87217d9ca924c286206ad9fae1af3e8100",
  "45d776b8ba9a5a13d6d8b98c1e933cadb7304951",
  "395ef67f30a6fdb7b36a4237e845c580b1496bc7",
  "41d7f4156d9cbf4531036dd1d5d1d5989185ea28",
  "a9ae8216a91b20dbc8b31de090d342ab9043ac1c",
  "6085892f7d3b9bba47d261c47ac8b622810f2b8a",
  "c0f80e866b5b4272021b326d482006b89fcd2ed3",
  "6ad8d1cf93454adafe298b2d3ae0fb7f6041f9c2",
  "c7a1563108726d1441781f51fbd9ff92fe6823b3",
  "e272fc4ebdb4e3247fa42e48fe0e2a6832bdf938",
  "05f8ab3c6e7feb2443deee946dd03a6bb5d910e0",
  "7c85a92f0179aebf125f0a7b8ce10c025c62c054",
  "409703730afc39344b3189624cd00681af16c780",
  "1d8bb4dd89b4816223e22a8bc84e74b9768b073d",
  "accff2fdaafc80b0e2b8aeb0ba3fc46f6d57bd63",
  "ae6765a81130b6e4d5adf06a3f35371f21c19a51",
  "e86685db6c3fd8368cf8c26fb2d231f0f3396fff",
  "66dee9ccaa222335168de98c639132ee52173f46",
  "d3f0bc0079ffa6026569246f2d243ef93153f334",
  "527baf7a7b054376d6979fa52ade64399f49708f",
  "b033c7f66f6adf70851e2ba34d5b17928a0196ef",
  "79355eb6eb2284d55052ddbc2b8824cb9eeb6cbf",
  "0d676d3257ba4d62ce6df1d1c4c8bc908dc3dbf3",
  "0ee3fecc671093310c4486edfcf12d851d355e3f",
  "572c869b7de2221a946d59e7878c739e34943fc0",
  "70f5c281b084c599513a5af0cfac6ceec360bf7f",
  "9d6ef5da1a1927049eaee8aac9b4ddb17f43513a",
  "f15aba72c11934c1b64a7e5f4b300690ffce5516",
  "e4d84207353a140be7cc7c3c8af7fc0a2f0a9003",
  "0a7ec5b2c797190e5b1f10db87ad27043398d9fd",
  "6841cb5abc27b2cde1a879b054637d7d453270a8",
  "5e336b16ab7b8637cf353aad8d70c517cc2f3277",
  "faf9c21b0eba4f02f956132a3accd7b745d2861c",
  "4297e1c33d65a7453c36f5d3f26c61cfe2328051",
  "ecb251006620e2528f022976d067ec358e1ee2f8",
  "4a445c30ecc3af4ee1084fea2d48c031c923ff78",
  "87e7594d2058c3865659f419fdeb7e691384f29d",
  "181d8cf13688d00793727cc985f65f92b044ed07",
  "7a9dcb3670f2607a4efe4515a848ff90a59fcddb",
  "e2eaef09445de65ba531d2ed30c39eff97fb1fd3",
  "bf95c41d2e922f6f1c2b8469f6897c2e3cde1aea",
  "f1f55d33aaae070bcdddcbb6750e2d116dd94653",
  "81363fea1ac6ccba0eee585d315dc1e9a9713fe7",
  "5a13d9a4edb9b1b8b88e4ffda95bfad83526a262",
  "8033092caef0b12554a5777190e499ef4c047231",
  "1fa936c81d44366c9592a618d140097d4d0555e4",
  "29fc313684e1735f15dc0bc984064fb081dab588",
  "b73b32da6608e71827431c49a19a7fc14c6a3843",
  "827a7b06c145530b13ce56fab00dd572bb4fb0cd",
  "c2c7c142c27fc5726634a61fdec0d39400c3cf57",
  "a16b02c52b7201b831334324f83a7c6115e8600c",
  "63616ba223518fbf84d3ae2bea0b81984f36e5be",
  "eee723c3f10c1a4839d82acb2bcb7ccc7756207e",
  "89844d80b03b8fefe0cc2de4d54a259d03d10312",
  "5dfb3a125a246bd94ad88caf58688ef49844c15f",
  "7b4bc50b895c6f090a39a7f853631791d8c649ab",
  "5070d7fbace38ed58668a2211160422c1b271c14",
  "0f719ba4967fe430a042a429569277d699c43de3",
  "074e5896d2592998d134075a5c6acb833b395b89",
  "58f8e39790245e33a3922ad1fbf68a43016fc1a0",
  "a3704a02476b9d1c326c118419b4440efe5a1c21",
  "c55bc52a82e82170c22d248c321c53564bb00d59",
  "58e82d981e8c17c5dea9c99a44c2e2f5e6908ef2",
  "98b5ea3342b954eab823c1f09c90c61f0fe35cc8",
  "0ac58c741af23b947620677446f1a13f2d1775bc",
  "8164daa044a0b8c6186ed7e82f03abb124c94a4c",
  "687b0cfad10ee270863116cd460207c8c5b4d76a",
  "6faf414ff73b36456d39f74436d595faeeeb4f40",
  "0504720733bb24c40fff86e7dbbe15e4f409cd46",
  "2b7637cfe7f8dd4bea721f49c3e95b279da19e41",
  "5c8b7856da5a0c0979b8a5d88ceaa1157f8e2cd1",
  "c988cf73e795ed777bb0a274e13b915775fa5864",
  "ed7e2dce4638e2cfb3b0317eafdfcbc049a4ca92",
  "70a61b0636d5731b422559035890010efc692ce2",
  "f8cdba1ab35943be9fd0fae36e93c38a1c081622",
  "ba9b0eb60e3a8fa44b8fc19e0c4cb0858d281414",
  "b09a20905b399fd0d589186e60ec0a91373839ba",
  "2c9625809d052bf8abc9c7184e40550bdd78d419",
  "bea4e4d71d065c5743cfb909d7ae0f006ed8c405",
  "a20c7b187952c7b4c1651c4f19c10ed98bf0518d",
  "f58c16f3e1dfd3ad3a7ec027b7b9a6a23033cb1f",
  "a932e05946c9cf2267e5244aa2402a47e9dabbc1",
  "e01a9d6f7548700feb3fa5ad80abef727ff90f1e",
  "de0ce17cc7b0e4f89c3543ffaa194fa116f7ef9a",
  "efa266b326b79d7f448ee13109d534d2f0c941c3",
  "8a056338c4ccb6c6ad48e79ffe757d01f19d86f9",
  "dc2ac880b595cccafe185f27f6593e3b09a869d6",
  "0c9b8f2f18896a1d965614ed949a237e2bdba359",
  "33d4fc72430797f44efac56fa786d365fc60e69d",
  "ae8f735c64fb571da100025cc4c7004e54e817a9",
  "041059bfaca4548988e8e2e272ced886b2a97aeb",
  "f43c5da869d53fafa0bbaca14041804b7e054e2a",
  "be00b40818e5f4f91dad42ed451afa33a2d02947",
  "047f36eef34050ce932a6770f70ae4a312d86b3c",
  "3c9822b9e392df816e043c19745a3b23ea8a8708",
  "3f4415209024598481f1833ce7fa7ec84aeab6bd",
  "5523bfa87948c8e99b72cfcf9eace8804c78e5ff",
  "7098927be5e2ff2211388766061000c9559bf1cb",
  "bad18e1a997642b5efc485c43137a2595c4083de",
  "f3fbf4caec3974cf3d18017a6c253d8f46d7136c",
  "c6b8bc9e91eb3ecf1d565dfcf12b4c0b77a9277e",
  "f855d4302b65fb39f6a281da8a5c4c7db539933a",
  "74cd687811f9b60cad1899090773ac117740897d",
  "607599868961e46a5eefcfe150fe894c39c8587e",
  "c7be3dede90f0369a6a72e018b947be5c9da8f02",
  "8873b3ffcf41c928a92f52ecbacb032b304f9bec",
  "567af554225d0c169095ad042768e94d85d54d6d",
  "63ff175a05e4cf00b3f5364ba4abfe0797595c83",
  "73f2184d6e63d0026ecb94a65a166f8e046c894a",
  "d247afc2c714a2369d0ab8337a71798b5a320209",
  "df0b584097e11703a7c7342f2d8e65dea94f649d",
  "7bc303c550670450afd5dd0ef335a42736045f07",
  "f73ef9e99c9a0cb861793b64183386670d785a47",
  "274cad7f28ac60b5ef40f2162073159b5d674c4b",
  "79d8f624651c048e5dbabd6f5111220dc1640135",
  "1973a8897243d38228cacc8a566fea33c8c34407",
  "830d667d918beb2881653795cc82f60f5f7a2786",
  "576966a7e1607c48b6fd5e338bb21d5ba217eb3f",
  "06e23e498d400d61416416b70372deaf2dc9bfda",
  "1ed49adca486bb3aea68aae33be45506a56c3afa",
  "00c64637d5912f48fa3cd58f94ad9dd391c076b4",
  "14d211620c512e56a26e8e28833d83773f8d9265",
  "17dd756d5128966c2e3515d1d36869a6fbda217a",
  "dcf116d51c2633bf9bafc980405fe49b0b3be5b6",
  "8fa3f6c6ad5f029f0702a01ef4c03409ed12d193",
  "0ce2b2bef29a448ba30cc7290f222c1eb35a5996",
  "2f2c44052aa92cf4f03b3e6c379c4d8c5c74fc29",
  "60bcb4e9f7725c2da6c63c2bf00f59535393e0b6",
  "9cba07295bbdf69279b1cbdb32f9db87f1d47701",
  "736c75c6eb98ac9a5dbf71dfdc70a9df3ab97d09",
  "64ee81ce5e5f72a3abd0dec410fa97584621c6ce",
  "6869017097054b7097acb8b87be7fb1154bb1f76",
  "8a41704f62aab49200b57a0582632323f5ecc3a5",
  "323c54b7603dc2dade4d426ad98b77b0d215bb00",
  "000ae4493712795522edf3a5da984dd3040b1dba",
  "23cb5ba2ab3b7f7095c1b4d5a94291015497c077",
  "f2f7147172d54bafa63334435b3e333e0e24899d",
  "a5b39d3967c34cd7ea7f91c0ee2fd958df8ab45c",
  "67f04b2623d872a6c8bba0416a8ed7643561ef90",
  "44fdc1018cf07a4062d9dfe5e58b789a76847937",
  "2f0aba95e1cbe1295ffd5209549b17698a285337",
  "daab44754c91882907f6ce2b6b07e2ffb7def11e",
  "9d287515383cad9ffb895a8ee8790f34c9c0d365",
  "676b4330925b79a609a0a6096c1ba737f84d5c47",
  "7f6a97d34daeaed7c8384d7578c1ccc5a0306049",
  "f49ce1552910ceb30ad5a5b08202baf71e31f2ce",
  "c5d536048992f3e1c94baf1f50d6ed6dff8cb947",
  "48f57c9e3ded5619fc6a75dc9ad3b6199e925e5d",
  "057777e6137e804f209588642b19f0c9c0fb1658",
  "668da1a168417a0377b8f3b7be9b15215ef37fe7",
  "3d33560d7ab944538b804846b5bb7967be2167cb",
  "e5d3e1ea3aa334a4431ea1647904495216d351a2",
  "695abfe34897a2d3d5539bc44a6326bd7def3ac4",
  "6098baef0d7b1b194666cd95d030d40b60321046",
  "a18d190ef3fd774d06d715e861718999feb45164",
  "9bee8b7f9324d0c7e79b7ac403d0d2d9dad06b45",
  "be02a26a5105c556029dbd0d980c82714f4c676e",
  "6a1b9745ee6d7bed02dbd361456865a0e697bbd2",
  "0e1e0674753115f75fc7e57cfa2802f99847d435",
  "53ebf05e549aae84ef69366ea9bd2413cec3ebaa",
  "2816e3139d54df69abeb2f2aff97f5caf31e802d",
  "5753b1f6214cac270c317a0c2c8bea313d6e40a4",
  "e1a422da686b07f27873b3df1df67926cc3e43f8",
  "1f5f23582ce9269c5eeb81069c25b5405515764c",
  "ce3259b408a5b566392fcb543cd121a83dbf478e",
  "cbb21b6cc45c79aa59a41af2d4a96f6bd4e00d22",
  "ed7f31f46cd4b5f5346bd37f68fd827fe69b6b6d",
  "867d129a77cb8d160a6e4d549f48c8a32e5710db",
  "80b2e52acb464d9f6e7fcfb7bcfa298a7bfd94fd",
  "d37084654754c30ea98af6a4716b75bb648f05ec",
  "67dcb6126bfc4c59b96692e5f5d3e62bc1eb74c7",
  "2f199f5fe8737d084b641b8c8a2295357b363406",
  "1a05cc34039a00933ea0f1cb80c31affa8d41377",
  "14a7e2191a9ad6fbc963a448ca88dabeb2eb9dff",
  "9cd09c217d042e59347955a737df955bd8693cbb",
  "ee10eb419c96c33168119a379b059b67a81fd9e4",
  "95ed3770d481f99f33ab67b9eabf86d93f6396e6",
  "c993b59350706a54a06b6d5eb1a27b8a5b32039b",
  "d01fc797c80fd38e40e648954c7104af317dcf10",
  "47953fee1907c91245ffdc2e8a4c261e461474f6",
  "39fc14b36c5c7fe4ac9fb81002aa0fa2e8c23446",
  "dd91787c799e089f49af8043c6b262fd3e6246c6",
  "393cbe397130c51090c9dafd36e75dcf17e03cbc",
  "e0a22da191fae3e346141c2e6adc152dddd1e179",
  "ac0c20309180f9c7938ba7e921af3ba66ff770a8",
  "96aedbfe9c77f8659f4ade64c0e024239882b4b0",
  "102c8b327ac63f91e4a666d0f536753b114c6720",
  "ffa5fcefa41a6cf9cc8552af3c4fa0b1e23157b3",
  "a99bc3e31e395b2b228ccac7ab9bd1e7a5652a0d",
  "dfcaf62ddd9bad1aac4fedc553163baa35b4b458",
  "7fd01b5419f697dc4ca7bfa4d9a33e2d76756b05",
  "677f277348d0eb884dbf7dd6c40201417d12fa66",
  "0dfcb27a1e835b26983c3feec6bb66f7d1d83b64",
  "67fb6fb2d8ea1d308bde4294cfe9a16c9c291ee1",
  "f60806a1bf94f99dd81a262123a56b5770dbe182",
  "fc880c03023e66ca486b2f5b0c8dbbb213d0fbf3",
  "842bdcd6e6c18db040973f07ec3d384f2414cb10",
  "32eeec7156aae77ae96bdaca5dfb5b2459adfed3",
  "8f9edfb6bfc4dd42c1e9f9caa58af36d22989ac2",
  "060b0892c7b15fe9d1596add281f42785e480d22",
  "b482df3d2b25785a20e0a7652d933b087d4836ea",
  "116ed818f649036146fe8886964f00132884f6a4",
  "31bc84398ca75b81f1d22dc70bb297c672922f2a",
  "1155554038d14f7ed3e365536806091249ce22ae",
  "9c2ae868e3ee6d6bd812bb1dd3510aaba5be6403",
  "f0b8d12831589d63ccf0357ab9ecef754e7090d1",
  "9c38800c039db7b21dffe28913c366b45d66d72d",
  "9b1292f653df4292dd46d632bc603eb9728ead8d",
  "35244871dbb01b5e81f7128972c93ad86c88c07e",
  "9b45c596639e52a2d7549c8353e95d9e682b0546",
  "b7d5dc644b5e058d12b2ac4548531a087c26df54",
  "5259f2372436835b7ec49f823db0909829f2dc8e",
  "72c24d8723fe793d2d96d328fb95ff3906685c51",
  "6a1eb8d481dff81bef478817cffa722a95393d1c",
  "4fde0c5a32a59bafeba0ddd267b20799271bbeee",
  "c843b64a09069219257c4fe09883378dc2fba224",
  "d074b6216ff158e35d9f427b116e37093d2288f1",
  "00b04e8d5da6dd69bde843dfafcc4fbb1b25a3a8",
  "6d654e275c86e96b5afaff4d5245cbeba359ccd3",
  "97eb8d68d591e38030e7311d261922d96c102f5c",
  "13c68ffb3ad2adaba3a573d16edbab4caf247829",
  "386b0a7130b5dc39491d8ee28412360176fa2172",
  "971882e18dc58fcd6c8051d6938c66c756043618",
  "f2c70f09827db6a9054250a26628afce4af6e99b",
  "6310d950b8e3cd04397a67d012ed924004119c5f",
  "6d05aa7f29253aea4e1714fb1f1261d1494e88b0",
  "af7694fec54b6328ab19b962ed366df7fc48f2bd",
  "51e853b0e161003dc9005eb92b418e8e7b554cfa",
  "aeebfaf03e77608aa7cf90b353564d76403d0628",
  "e85427b93a6495eb36835db3ba49e3ed0d40551c",
  "13a037205f92ad0c5a6d06ed52a387500eb11572",
  "c68077c55e152728c095ba629d7bad3fc7633c3e",
  "897c553d1f8222913f4e3a334aee89d026d3d7af",
  "4528bba1dafb71069206a8cc31eec03ecc1b605c",
  "9a58d5e6c040c424d74c330d542626963efd6ff0",
  "596a9924959ba3950142e0c48cf7a7b96d8e5e5a",
  "52faff97537cc9bec44c8e83614f6fb0e0d90b08",
  "a81ecba9932fe11bd608c3c6a9950c5cecfca219",
  "315ed2b202c4c4e5b1a9c423257ea960173ba9b9",
  "c756e85199c758655a4d7d5f13d4d8bcd9dcc635",
  "c62df53b243f49c993589963168833c7c87aca05",
  "fa821629c98761325255977c293b28982a132c1e",
  "1bd51b24da7cdcaa79a5f52097ae0047975aab1d",
  "1770213469c03a36e964ba0c5c4a8fad73befe43",
  "46c9157b1c41ee430e9221d5bbaa96ef794456fb",
  "64d08325e26a1b428d8662516f3fb80cf64e2fdc",
  "fd27eda105ef64b96def5806d1e242359859a94e",
  "42075512b9514dd30101b214398bb338e3457d53",
  "0c0363e7c8c98b19e56059b3bfeb5ca174a47a00",
  "cb5f1a4ae6a6ca8f4470728723698f38b6429f01",
  "4eb36adf0c8ace7cd608128cdf17f45188694d49",
  "93cbf17b4123b5fc5c9e64c100aead80a68ecbae",
  "c0e0297beb14bc6cbe2c4d2df8738c0cbcab6acc",
  "2e2136fe9fcef05bd6e6da910b75fbc93aa307ba",
  "c71d926d9977541195916e630817581039590f79",
  "3594687713f9532880f4de55d6bb1c6be2812685",
  "4ed9ed10b2a0c53c354cff6d0f4f451c903787d9",
  "259a891940cda96f5372e5c4fc594e633c3ce3d8",
  "8876289a9ce84c96197180986dede14345fb1d86",
  "77a5d0e642eb3d8a652e4b89c65f09e4f8cde658",
  "74fb0a3f6034398c4274e0fab4f734dd79c706b6",
  "7bb912cdb0afd26e3918dcf45d96867e1f4368fd",
  "194a25693aad8cb7b6ca0dc6a7dfe49ab6a62c0e",
  "1abef1eab364cade22bcd2883099322412569abe",
  "ea873e378654e4573523191c3ed51c3224444e3c",
  "163e6bae3bd3626afc757af98450fa00deed8231",
  "80d62dace7a3ad140c48c735d34c77a1e13ca680",
  "41ffc3f35745fe9aaefe3bcb81c864aaf2508024",
  "e46d9deb086157e64694f9c39be239d91c225854",
  "5b9b5d762a8a987022d15304caaf893a3bc844ba",
  "1acd2894226b249a002ca18ddfecb8908eb48205",
  "e7be13cf9f2b7ef8405196b15a1e82ac6167f91f",
  "c6ba10ef8b7eaed4eef40c139a487e8d688fbd9c",
  "018a3347c83b65d6bf627863b73aab12ae318a0b",
  "b9e85b571e4dfe901f1b1123499e8a68da791130",
  "90d89fcaa03d7ba26af8b652c9e5f62d1b683734",
  "1572aa4a27b4b5808a95dda7110ffd74e9c5dc9b",
  "4c94113807ded0ebd8f2d92758a4ad2794a86e9a",
  "4ad940e14a2c776bd68cf9fa68a935f781faa477",
  "9d83e7fb6d709441d48151990f3cac905a8489f9",
  "b1cffffada4850a97ab44e2138bc7b0c69554e6e",
  "32f0ba6d93fde7db8bb27639ddc6fbd4e917d8c3",
  "097319c3f2df40e1ae9e61a5482c62c0a91e4fdf",
  "8c17b79954afe56539d5c69dc9c25276a511a0f9",
  "32af4411943c524fdc5426e1e6d5fe14030be1c2",
  "7937e7ae7187b8ee3c6ee64a842624f41a82c27c",
  "e68b0e23b9ddb68b5988d01c4e86b27e9ee0e808",
  "85b998da146268e7c7c0fb5e2e2af99daba095aa",
  "c91a1557915f0c0a177019381a7dfc5a0b1acbe7",
  "e23b40a916bfad0ffb5f0bdfa6162957d1cea8dc",
  "2ca7368c247879200dafe1f73e2d211c7316d7f4",
  "1e3ac45b9c0ff149762db3059c05585fa8aa1d9d",
  "3025e814c1b6d03852f0c342485190a3518466d2",
  "3bedd2d9d4d9141a7b16ac022a7eed5257fd27c0",
  "6497d3981eed8dd08192cf37107e6cc3618b9126",
  "ab745a078bdd396fcc52200497a1a818cf874c84",
  "0cf83a8a34629419c3c91c3706241cdff89a56ff",
  "ed98829db0b63f1e012ed209eb09d17e6337f51b",
  "b74bda3752b5026009537889c1b45119f3e520ae",
  "df651053875d4a922b112694328b320679b262d6",
  "a78401ad3274b60e5753ff5684570add76d2546c",
  "c206c59a583d7c8fcbbd5da8a748d633c825d3f1",
  "5fee68927bc1d03d975157a4f0b5d812997b3538",
  "bc320b240f25e224ba3a9f2ac0b1c7cc9cfb3819",
  "4fd9d24f056c1e4533862ee574d7b431d8d66a56",
  "b3b157a4c5d334bed8755d03fa2dbe100f5f26e6",
  "d0770733619df24225bfe5de161c036fb8b50953",
  "9d3792e0a2ba58d480be6cdad487c8e99cc4f233",
  "1c5480472579c7fe7899d86aa0495f3fb892a88c",
  "7905d12682f8afed33a7eb93815cdcab9af3be44",
  "02a466d7114e6532a251b017569368960c5e271f",
  "cf3b4d5cfddbf7c9f6405c8b00794c5af99e0c36",
  "a76df66760f7b3595e7e17fbd6de47c04a5b6d88",
  "3a46b361c3e735c1568a0195537bd4efc9511c50",
  "7ccbeda7935caa2a796d82500e15c75b9ddcb19e",
  "2c560ab101b7b1834eda3208601783ad36fc6f0b",
  "9ef68608ac974b841e73639e5c26a6cc4471fb71",
  "63f1f52c77000df6864db3d05a8934a6ae7aa8d8",
  "045c73545798ff102635e06737e7b456f4453997",
  "b40921b6a6c3abd25b2adb6d57d1a33533fa30cf",
  "55e08ba4f2c8f8f84e64eaad4f70c1be9a608fbc",
  "0da2125643e475603b2ec8e4d07a5f8e61239002",
  "2231522c8615b6f05ee830c40a5de82429652533",
  "0fc67dee324db04480563927d8d2d6fd455ac0a4",
  "db25bf4e57755226cfed027eb224b7821dd74990",
  "b7655791627f2d043c00c8cac0bea9508d996bd3",
  "f0243a3f27aa94922347edff8bb8d076f738d388",
  "78e261de28ca20f8d720919f55f34aa92ab80889",
  "d395eaecbaca358588122dec6eb8786b20f8463e",
  "13549febfa3914a521b15fa9808d8b85a64b31be",
  "4666ddf5ada054539410e4fd590115da4bb141e5",
  "e77e29b1707197f656bf23ffa45a5eecd75b6e35",
  "808ebe52bd4f94e2e7ba512981c6859e7605b014",
  "fe6724ce0654926b28d2d2319f85092f494f9598",
  "3b2e4d8d26e01e7e421acb1baf63b5a3c22db450",
  "e09297a05069c0295a2dbc9480716cc1819e1c77",
  "b459071c6e7b93febdd4d9cd53514ccf4f89f734",
  "44fcc1a64c33e2b42a4bd6e25b0aae52f26a98fb",
  "ff85c1a4bb5b84d492ff572d22591c37ece4722a",
  "54ee0ee42d03a59ecb2aa8117a5182fdaa07aeff",
  "a17fbc07ad5f3b3c88528b8cc69af9f2b2d5feb9",
  "371483bda15a25daca7fb8795f9afa1fab3e121e",
  "eff83377b1ce57313be594669a489cf325c573aa",
  "e449842dfc2441e167749e3f0b9fdfce2fe368e6",
  "6e422a37d137e9800767ceee9f33484544423d2e",
  "2012000b201a8bde20cd87be400fe54b600f7fee",
  "02dea198b398c46aa1f9196d1d577c05c2422f61",
  "ece83d4bc4b939c75ce107be1c16052d85cbf146",
  "27edb143face8324c032a6ee182fd649e8aae76d",
  "7e79b69aae906ad5be7bee88c6ef6f3b38305eb7",
  "4c4fdd4b55b61904621b7eac534738b95b5681f9",
  "65aa121c6e760eb225d655cbc50ca67c41d0ff8e",
  "a195ebbd05a530a7adba94451aa74a4e7c8b7d29",
  "08e3f69d59099a0e54c254339a927186f4afc831",
  "2d9afa9620bd2b9a46c2ef1d497eec5b09cef0d2",
  "5a6a22da9981053d1c01e8560a42b10e1ec03a41",
  "f96039165057f46baffffca11b6c3e0f67a4ed07",
  "76f581a64077074fda5e379ba858212392bec223",
  "80a050428ff94c05bbb44e48910a1f4dc8c6f618",
  "24093e35332673a7686e2db94f9d2696e4971fd5",
  "9ab8a86ccd8ccbe979da3f62c7db36fb546ba688",
  "f3e3a96c063fb29bf9f3906f48cbf29c75b26164",
  "26ea631869e190188a9effd9170a242cd8a71697",
  "481a53bb6b46bdb3f7d430866ad3b4039a674728",
  "8e29084391b5c4326c0d02c4157d90a82d01d1d5",
  "034661cb19e9db199dede630d354b59121a3e82d",
  "2b3e1d1c75031ad59ec816eb01258eaf5c96ebc7",
  "5b73e672d0b4cdb186c4dc145eacf31ab2cef762",
  "25fb8b855a2143ac284806c2dd2b35cac6a45a33",
  "665c7890194e145573ab5cdc4e913d19ae63cdb0",
  "610e22148a342bea31e59e9fbc26d6e0201323fd",
  "9a6e8421fa4003899391f70136b578258ce485dd",
  "995213cf35a98b4c616999fa69d10dc0e7e5ab10",
  "f561a9df9a0df30a23eb1b5f7c92822e1893b6b4",
  "8b3adb9d512c5b9cf8e529ed9b703752a65e2c53",
  "1d4922cb6b2b4576c7e65c3015585dafcf78a20a",
  "0459ca5a2c12cb6d45621dc99db36138a76fbad9",
  "c68dc785896fc3740c76e29adfdcdab9881e0ced",
  "0a015c9c4bc532fa68ca72f6ff8b38a1dc751919",
  "4fe9c9cda7a72a786b5afbf587eb512126b83f4d",
  "b2606bae3024ab88b577182278b3a05c1c9daaa6",
  "3037209442d7232776d6af4cd748ab54595ea1e9",
  "9b7e67398388cf96c1155ef218def1b6763bd750",
  "ae735d451f942a2e175aa9ea8d58f07508adf3f1",
  "c267b106b4b85dbe1751e4a9b95d6e9bcb6e0b37",
  "2fd721e79cff90dcb7bcbcf093d9208e4e460d08",
  "45f9e36208fda556a88690a4224bc456e9f7a1ea",
  "af7d52d1989c9d2a2b627ec92d1ad4d85f5eb5d0",
  "c62d0d148e187c9b8a55545dfa3e9bac6feb50bf",
  "f66be4bf07ebff4f12fd5e8db958074440c2e7c8",
  "14c4289aab1c48d956445eb190f88f9a07b5355c",
  "37fff2ffbbbaa5d08d91c8068276440ec7340815",
  "556bd1184617e956a5e3f5eb766d54dbd1beb115",
  "3ff262059ebc76da34d4c9d49f621b5edbbdb0ee",
  "13a97a0661b56f25107c1d986a600ecd5d04e16a",
  "b52d1309b4893f26e9e4bad13e4b625f4bf727b1",
  "22848d91e236e94df8330b1e1dc541973dbdd4d5",
  "84805986a013a4f3f2cd0ff3d724439da4e9d659",
  "a6304b3d1e920e9da3ba53d9c0c1562fd9f24116",
  "ea9fe8eb0488cf985898bc31f24863f81cd4c2d7",
  "a60d52709d201c60dbab2c0ff342d35db0313b86",
  "f275fa9b376bf3502ecdb90de033da42d40f7953",
  "61599c98af9758b70e06fb17c6f98a1762d67ef8",
  "3c78f6901f1ef01fc5c9da9a4739abab8dbda585",
  "dcf0dbfba0a150547b746e88b97f31b5031f298f",
  "eeb463de5966a3acc39c962ddeef424f3c014d31",
  "b0bbc13c197c7690ba7e3f6261bb346b6f9f789f",
  "0214c464a096254ca35054cec1cf85270df7970d",
  "c0cb2b7bfb91d46644f7b865dfdbdc6a73c7b067",
  "684fc96be718336188b4c8d53942784f53ca7cc6",
  "d423dc47e745fc0eb5922d42be2d4a2dc20c55c7",
  "afcdd9dbcd03f66a7d817f0520760cb1cc77f377",
  "b9fa3e6658bacfe66c2de11009b96bab3e69f6d1",
  "7b53bc3ca22fae7d496bf77e66792c518a87186d",
  "6bd9c40091defc4932e81458cdff57277a738afe",
  "20836533bcd7042a08c8c49ae6bef89c3f36430a",
  "4f10e7ec2d4eee86327bdb2c71f3d178e5011b11",
  "4051028ae194d596a974d44d0b48f98ccb76f2e7",
  "8be89263efb59f73f4bffd496ce1e79047708681",
  "c3190d974f042e8d54d83ce5987287307b0446ee",
  "5358f0c270ccbfe909cc16528e3cbc1b5a08978a",
  "0d44058958832463212488503011180acee09390",
  "b177a476b9e24d78bf5c0e5d2566c9e6414af1ff",
  "53fd08396c0011ebad039135e30b3882f258d328",
  "992eb68eb72b45e147628360a0d3f0bd78deaf08",
  "4151d27082d7a4448b3343dce05802a37b3d6669",
  "0e94e793beac7accb6e92711a591289b69afe735",
  "f153fdd9b2cb17fbbb890b0507b19c02eb0c00d8",
  "75dbe8c0dc6f6ca429fc726879987e6c4483bf57",
  "4ef9b3a81913b1f71a45dfceb907561c1c93142b",
  "584e3dd1b5bda8ab9aca699ec18e499539b44857",
  "faa2bf5dddd407a69c7a440cd4c5e425761e02f2",
  "dfb51d67926936b80a3e8207b522bc0e45873d2d",
  "3cbfe36695f2ec11dc3c8670b6186645c945053f",
  "be8bebf83464ac5918202c45849de451be637560",
  "09a59991bd4e764464ca310d3a063d5f323aa5c8",
  "d8904721c728e8dcf0e6a5328938d992614da90a",
  "5b482a57e9f65f02a6f0f963e28257cc3856b3ac",
  "fcbcdad2eeeba1ee5968eae624f1f3d1388d5c45",
  "d86b31e943cbbedce862ff89b05177ee497912c7",
  "617dc8c7777f1d92cda5fd672040d27ba97650a0",
  "453b72a9e6b1d93031388da4a4487e42564554b1",
  "bf7d6e958ea5777932731b159f0e434250d9d7bb",
  "95b8914084af24fa170ae7e69b1071845a9a6681",
  "be637f46b06555f62fbf3aae4ce242d21d8b724e",
  "d99b2c290acaa73b0bc29da62e1881cf26772f4e",
  "d5f8d499ce2996fc85bd101c5e2b3a905c361167",
  "370ef8e0b1215ac7f0dbc1f4dcaeb5065af2c3db",
  "d329ddc4d89b6d2dadb36575e56ddd1abb3d6f57",
  "e0d7903ccd12685e3c7b8f113a5a2d72397e84b9",
  "6371347251ab57c6e671ef0a4bead3f53bc48cc7",
  "f067eb51baae9e3c5860b8268584248edccce611",
  "95de29beb6e429d27ce5ab66e2f2aa5095100307",
  "156f4bbfdc50b63a3a0e74954359998d4cc5cf52",
  "63e64675fb0d7986cc3b2b9cc6968c005da78701",
  "ad01607929d3e497f649b03d71c494fa0afba9c6",
  "2a34c195001e2f1668dcfac738c0cf41f5032509",
  "0b13b628ce28f11328f8341a23f6704f501f8268",
  "4f0aa07dc8541a31f77f9ff7f4b12833ba9cbe96",
  "fd9206ca42d4f928d269053c94416b73f807bf00",
  "bb5908442b3c03d60851373dd9be754a6fb8ab34",
  "e6188aa59382eaf4b136d04f0738ee285cd010d7",
  "2a16c97a0a371018f871d28ea6dc1e36331b9295",
  "7e1d9b97294e93353829eab77251c9c308ab514e",
  "826ca35af2655be68493f4f30183ec4abb217ab3",
  "3d949d776c2bb8d37eec81d5b75ef42bb752d262",
  "c6762ef5f329e0dfaefe4e3d9a7e01788704db9e",
  "8adc7cb6bf727554d5993abd6b849bbc3dfb09af",
  "b139e46c0c87bb2eb2f4da0f5777aecf5cc40cf6",
  "3e139400f8fc1f9ff593609019649619167e261b",
  "ffce1ab8935b47bcc5d70a20d34fccdd06529e7e",
  "aa57328dcd587db38d7db7fc486ec2913f9b5bac",
  "97a59429bc653b1ee33eb6af6d0270cfdf1f1ba6",
  "d3d6db685726c138373e33113be83b143a4b0006",
  "3773c87e6af4572ba8d041d6de46049d0daab481",
  "f7332555070d5975c32f9d9810a6d2090db756d3",
  "f557526e1c17c38095c8668ed1fadac8f76db9e2",
  "9f714e226a4608263b44672de1f7c9818019e78a",
  "5852bad1644e04febadf6ba22baaee7dfebd0e93",
  "6305a476be51fa0e860c4a5ff6c7775489c0a23e",
  "a1d809fa8e49ad65b1af2218b62a1d8a93197e96",
  "3f0f879dc878a9cee379decd4e4a3951b757a3e1",
  "600457a9cb56b046998355f3aff5b6f0fda61927",
  "569c30690b9c2961878b59fcd000c1b48d0774ac",
  "4d32bc5707854884df7a8ef8823f191832ca5ebf",
  "042304cce2d0ad88f41d7ffc35aad03ed8827545",
  "d7bdb51085b7e59d0898a90e2af34b68a66f8815",
  "f51951806dad173606d6cae1fa0dbf813c46f83e",
  "40b92cbd797cfe3bb6d4806089880b01b8170285",
  "9cbe17cc1f15f66a4a7718f38c199559f81a2a2d",
  "4e57facd225d8a4dbb036493e3d1ce3a2aade496",
  "768098f9d63bdacd4a288646ce168b0f1f22c497",
  "0e9acec66a2e2a6ab98765d2f0af3a67d039c161",
  "ae635f96e2cb4675cb414c751c0dce59e1270b57",
  "cf15a21f336c44cde6f41820a82d2b4958f1a359",
  "cf63119276d87e9d6b57550c30fa657b6b7a394a",
  "0f2f6739e4dbc8051d8137fe37244e9eecd8000c",
  "43aa35ea6ca719478f3be1056a388a3fefd22e6f",
  "49710e52f5f51b2734fa87a68b935e1cdd30e448",
  "ca1f3a226e9d0d43288804ec35e921da47a40366",
  "0e29fff560fc9a1a4b3cf35e691d135a05c7184b",
  "c2d3556f9951a674d8be0be55dc0c89ddd8a6159",
  "bfb7308c666f43df653689450b1acd2968577cc2",
  "d3c5da244cfe086c1ab8c4a110537d6c29cc7889",
  "ea5039240d1473425f069ca3c4c0b9037c176144",
  "649a800b52d966083192e3f45ff6998b45cd34af",
  "ba846d18082c4c9a3a477b1ba4435e665cff3b4e",
  "098796b818f6eb5e0f3c8b3afaf86734cd9d7b1b",
  "1921c67963b3023bf72dd7c352f6761737c620f0",
  "cdd4c4fc2ae9d193fcd6d22769e19d9989805a71",
  "15c42744b7306664f92504a2378dfbb3811bf78f",
  "281a9110120c44bdb96680777922b9cfd8acad08",
  "efdd8bed808fdf28d925a0407a174bfc5be815fd",
  "d17d76faf9f2caad59011592910b89ddaaa10436",
  "d1151cf1f34bc096deb9782bcfaf350ac0744d83",
  "25bf19bc3eead53a32f8459f24ae199ba8e0ef90",
  "88beff5727b5b20d3119ec494f9046a34e894cf1",
  "11e1f58742f392fc63f7f51638e307ea41c5fcde",
  "b21b0e189c730e4b8cecb945adff402550846871",
  "75afc60321ff0629944a7677d953ef6bea44e509",
  "ec986c036befb7b510a73a8118dadddec4e3f630",
  "2af6c3d6a5b00765d698bffdfc4fedb30de0c8ad",
  "b756fe5e9996596f629659e69d35941e14cbf848",
  "9ddeabd37ade0ec7d0b19dfbda2d639c8b9a8fe1",
  "b3d468ca10bca7422db5282f391bceeba6582b90",
  "c5918321415b3164b3d6f0e191eb273d7431f67e",
  "ff75d91e60303dceba1e905caa3fa851db6da088",
  "703eeb8f85f88218af8e2a6b1272bf9caf346dcd",
  "05b08456b9ad9de6bb952cd411b61da9c6134c86",
  "c8caec43bb6decb36e4b5fca280f99304c4b1441",
  "a884857be51a160604040fc456d13d2bb9e40afe",
  "6b1978fa3c79b235b06a06fec29ece44be336d63",
  "63cd82ad69a1c13c23ce1a4d6c55bba086568216",
  "e8ce36a8a73982464539eea64e55e345fef866dc",
  "1cd5fa3921843f08fdcf80476ab686f15f74c7f3",
  "d76cea11695acce88ea8db019ba85e08201d182f",
  "866b98585cfbedc2e7e261f76e5fc5f12e0a9639",
  "0cae4d2b008662449ae46d81731a73e3c28dfcb5",
  "9e141d696d95dcaa7e74d4c1f82596a554bb59d3",
  "3c59b30bf40bb4e88d1e095ce289fa08115b10f2",
  "e16d1408962f980818e50e30449d49b22d17354a",
  "781e2179d28645cb4894f1ed7cc83d9e9f5efb27",
  "e95dc8b12844c493eb7b3447bf6fc3b6e07fcb42",
  "8b0b183a7c5bac5bb297882283d8ece4d37034f2",
  "6e40f9649372e00eed003412519ba38f50cb84bc",
  "612e417de9b2db9b90f9f481983e8d1cd60d3619",
  "d895cf7c7cc799c613a407867fe67bd5fc4c5221",
  "4ef2b2d8d65fb1d74065408b56cbe4a6fef99875",
  "f242e90e4fa1123339d1c5ddb1c4dc7ff20268e7",
  "f08f11dcd05673df7e320fd205a649c4b3bf8cf0",
  "39a1633b080a93eaea097eb173f8b1a8704c6795",
  "27d13621d5d92dd08f3429be47412e07102a926b",
  "b2e4bb2fc6b30c27ac1905edaf1788d7f3e2b360",
  "e6f72621da010f18a101d3753c3b34e0b74b7032",
  "b3e772454fca05ec4601b7f920835ff490a6e3fa",
  "b75c4dcd2e294281403ffbb30e2c4c0cfa845d31",
  "15727709e073257b9dde1ddbdb2b86041e229d2b",
  "007c95411c673216fd069038cf6326b73e71b2ba",
  "541ad81cf8c92a4a6c8f0bcf8887155e32e8b897",
  "57bc1df3d150daae55cb119d97591deddaf83b80",
  "d95507388f90c3de42364e8a1dd90ce26ec96d50",
  "bba961ce1668d84a40dce121a56d874f7f729410",
  "b0a6b3e980a456dd7abc4d961f5b4485c8b844ef",
  "78ddd53e717c802a39a609c87d08c7c326bc4b85",
  "001387eccb56938b37238c616a637f48e74a12f3",
  "4fc40539da37b2e6dbfb573640b4d647c3fbf935",
  "78f99c2a039d7bd11f39baf9ad2eff7a8f8a6e1a",
  "917f2108733da3cd33568c79c18b27715088108c",
  "1ed34498db7e3eed7b306cf40a6d5af62c0090bb",
  "f54139229d868a1501d9a20bd0643dce6fe000f1",
  "dea5238da07d49a839be7b7d44245330705759f6",
  "2ff52e738554368942e34b437732c7f0d428e55a",
  "6c2d9dd79baf4d3420b605fa31466f3bc3530877",
  "b26026c98749419e25b631e2dd5ea178a3c34e6c",
  "787f06d69e152636c6200730b22aef68d300db3a",
  "daddf354a4e92d35545e48d65ddc2f5c19d04a5d",
  "d9cb0654da33e692c409a4003015270b26ae2508",
  "0c69cc900d2d1733a4a496e461e6900665b3324c",
  "026dcb9d18369d52f8808aebe7a22831da4005fc",
  "dc9128f9e1fc9350ff93d4bfa7d6156f593dded5",
  "39c912a222724c99feb5a411dd486704a7bd063d",
  "c945ec7d2c4d863b98475e4655cc8cd08a80e847",
  "dcb3572e5d2da163d54b5e71928a155901c382c9",
  "66861e19f9fcbcffb2144a45adef79e59348f46e",
  "e0609a1182ae0cbc70a9c96a656116f2b928ed67",
  "dd0af0c73dd5166b85ca4a7a448e77a091bf0407",
  "a7d27caa90b15c90cd0f8b6cb03e56de0809db08",
  "991882080d7c652ae9c62f6d4df42491439855cb",
  "09134a9413c81b68b91cd32ad55e29cc3950551c",
  "9e8229e62f6dfafb738ea517687c621ccda3e298",
  "319a3db1e51b7f1a5f2604e02ccfd282be8a6fce",
  "223828f48f7cc4b76c844e518f31eb2235fd702a",
  "989be4f40b5cbead55819cbffff74aa27a5eeaf6",
  "c0cefac011d57e94ab71f96f3551cf9425ddd552",
  "7ee76ccc15b9289dfaa27ac1cfe4887311ad2523",
  "4acaa043679e2d16855bf2796522d9589291291e",
  "234ce54c8253d90cc436a517e0b0bedff97dfd28",
  "64b160eb9c2c96b5e760a6f1bd3ee155b4b80230",
  "cc72706da3df44404c64f88c7a56614ab1898925",
  "67898e33fb8784ee017d75744f806cf64a2b1712",
  "c6562923bbbf12b8f0b9772d5aca97844aa75e50",
  "073dc232205bfc98e6c5cf9112844cf253816310",
  "5228fcd45294b3d4ae7471302fb2aa638d7ebe94",
  "7e6f97c35e3e30ac2c41f602d96bfdc68ceca242",
  "4f20885dd4e3be3aecddfc00bd39618f939f4f76",
  "ea5d213d50df36ca920264915e906ffea3148a1d",
  "573d247f055048dad6f5436150d4ef24615b5cfe",
  "2599698c4ae05b20a71ef2b9e4f64d71f7072a87",
  "5fcae871cdce785cddc0ffd762e3c48c374e6ea8",
  "c92c0e76b9b21ee479116e02764cb578297af7ce",
  "9fa5ff035f222ec88ce294ebfad2450f3678d0b6",
  "4c7a1ee8415a8daf6b739830925bebb549448afa",
  "81df57a59214616caee81123e98dbde86c23d0f3",
  "4b0cd092442e30f71c327d1ef9efb68e6c6bdfbf",
  "f6fccab906a502c18cce061427486ee465a64fa8",
  "c37a4c57cf261f937b5d7d39ab9c2109289896f2",
  "8ce9873958c693b2d35258fe7d7fec76e6fb6dbf",
  "ae388a1c52b2e0c66549f0b271a72e01ca5b1ed0",
  "774b3f91188eed48b70383a9809e9900ee4a9fa5",
  "33f727f302726a7942d86a12d2789145421833d7",
  "d731031c51b0c8b05f17544ab36d3aa5bec808ea",
  "8b6f8be5feef9d6fada26dc5e84bed9e2372289f",
  "e337a60b13100ce43147f5f11ea6f38aa991f24e",
  "33fae8fda4425fb2d21a9d6505efb7b5183482d5",
  "a8bb12723c8fa967ec4a91c38479f509ac95b65e",
  "77ca37e9b42de38770a6aa7092a747044c0a9f9b",
  "2904bd218e0a4d8f9edca1b06c387a255e3956ed",
  "62450a86dd15cda15611e186cac1221970bb0c18",
  "743bd1fe491ec1d9f92fd76d9772ee1c990116f3",
  "4b6ddb5ac8a6ec51ba43a9ee4a5c4999a7a4184b",
  "204e0f34422d4217d029d8633cd430bc264aa516",
  "c93c0c3ed9aec0b6eab426766adade19cc6a6792",
  "bb2ad90bab4790b50cb36d0ad9b43e3e0cc8e4e0",
  "1d8111c7b60f8a7b106eda94b0a24063e0a03cb5",
  "cd9c530fa1b32f7f9264deab14837680133589ef",
  "844639ba344c462a56029319509a9884e5b613de",
  "4e65e7158f977552f2c406cdb5e7e803c6b2570c",
  "236689af2826d10c3b50da9f8470bdbc64762803",
  "d98692f677815ad6c247e3dc366279cc888095b0",
  "7e252173e078b540d636949f0eba95e9ec05f206",
  "6887ea4e01ea660a3dea4437bc748922910fd388",
  "f445e326b4cf8ecc2f24d640d9009af1ed88f338",
  "f46aade0f34384a9a608d2e5a164b97ab7b46f21",
  "3a700ca6cba7fb9b6de787d00547b4bf101e3160",
  "1700ea4465c8ca399add604458dee3037e668229",
  "84343ed5ad132b9d30bd527d0772a349aae52f11",
  "448521e75b638ca598f7757bbea8982abd2310fb",
  "7e118ec74b932c736725347834690e4275ac3666",
  "95deeb57dccae40d4e65801db3e071dbc11402d2",
  "d0e76f3ec3cc72c1f25d6ac8bdde5b9d11249ecf",
  "a4a18293e6b00a651b84b4492c31a574476b2392",
  "95fd299e89158abf9757f7d61f19d4209318ccc8",
  "24fc3437a600147bf4dbd77fd39c85c66e9e4dda",
  "7a91579b46709770cf88dca87e476208e36c0316",
  "1de8d07ad52a6bb72cb1739e5c3d261e58612280",
  "5b688c9b3b723d8abc1ac197d75b0abd98eebd71",
  "69f0caeecf50555bb737fe9dc017e6f46a9425c4",
  "7d4d03dbe1e6af8fc867c1f4870cd46b142c854e",
  "d31ef3d07df7f47ccd84482664b22084f73d6fbd",
  "557e7b673f714a4c507d029e7075d1165a952e28",
  "e4bfdceeb505fde01afa0b5087c08538dfd25719",
  "84d55462c7beb7124fb16096f516feba1349b762",
  "174d2a2945a5fdd809366f328a2a38d77938648d",
  "ca51109a9b8962ef8ef93d78c277c14c272e264e",
  "f3714614b79e4da499701811fc3137c0ce6c889c",
  "797506036a041d1be2cbcfc8ea4ad7bf7a2f4d5d",
  "1a205a250e95791385541c7677ff14e79eb9aa09",
  "09baec6663d699fab39fd4d90028c45273e4fed8",
  "9456da3c116bd3b919b9fa709bd1857ed44fcfa3",
  "fed9a6df747ff01cfd88fb48dc5a01edaa88bf97",
  "27035f6cce07938303fcbef0e5a52469af66fb2f",
  "97a30635353b257836b88b8eccb1dcca2bbf1178",
  "70125416f61582c0ad7db578285d09a80022cb12",
  "e688150f40d62759d455561015fbdb3a8438bb9c",
  "1725307af424d7bbc2f787593bc329235f0eb1b7",
  "c914efc317252273933c8250ba1db57880ff6504",
  "f8ac040253de0964816b26086891770459c9a9bc",
  "3f3ff4fe02e160ab639d0cc6393c044baf77964f",
  "ce59941ec590925af6139dc6d22ccfdbc3e1ae8d",
  "f26736c78b5d23761c0aaaca9c21da9b09afbcd3",
  "8ded2b8ff90918821bd1c1cd62bf6e9434e63ba8",
  "5d5ed050ed4cfe6b457fba470aa6f0caf989e001",
  "a9ba5ddcb97c171c22269f9aaff55a93e4bd4140",
  "67b826c3c2ba310fc372894fd89d4ca9bc2550d5",
  "8bbc664b17852a207707b82b60aa9a63d4558fa0",
  "26b909b3b89f95f7215c2b8742329ca4cd7445b8",
  "795f170c7f186e59b45cee8ee405f29a0f1dbe4d",
  "05ff8d7942458de260f883576b9a77f3282776fb",
  "3891fe6c68056f839e1e5a7c7b4648241d909094",
  "66c0be3f3166c45a90e9b8697794a312a9b252e4",
  "ce811bd811bfe0ff6706ebfb3addc108531c6a45",
  "e5877057f350f37226da616d15b2059ee06e89e3",
  "365df29fde43344133f501f7174e3b511b4c2657",
  "d38fe999686501e282d9739e6d3370d8f782326e",
  "68b8bfb699d00bb74fc7a210090ce8499b332b26",
  "5728cd60c085a6983a1521bb45c339ec03ee9b75",
  "aeaa401d91bc5249d5dab53a475ebdd3d9544fc7",
  "46dcd3ac0c312ad6108a5bc0eafedb6eb6140e26",
  "33528bf75d00729a81caecc8b84d65ab4ed02be1",
  "b02d8f17bbaaeef18a78dbcbfbb00047a8e98069",
  "8f7beac6669d25ca4f6ae5b138af96a6eb5f5d3e",
  "4054de882e32536a020fe36c1fc9b6e12026b837",
  "a84fb9b0e76a14a42df7b3f29a7fdca6f858cb56",
  "90fe3e554275ace94d0aa90f5837ab2ac870fd8b",
  "7a07b49712233df8da1323ce99adc02f7145eb49",
  "8b99b1b6cfa6f5d72265051a914f5289eb7d9d83",
  "64b4a0330f722df99569f1f9e68d76747c690a71",
  "62704d689e6955acc26ede7b567cfe1328f55fd6",
  "0495bb9e65419872eb3fa366cac28a3ee745ffc4",
  "c14691ff529eb6c002e43df4ea8d5027fa785a3a",
  "eff694f8ac9f4f47576e94bb575ef7cb4d55993d",
  "2ad1f557d794b275ea79e123e0032e1af85762a7",
  "14065bb620419d4096cd25b48ce9f84930f540de",
  "890624f8b510a3a8cb7ed96b932b21fe3e6f7181",
  "d9973f670979848ac239f2985155667484af3bca",
  "0fd4582b606478c2d00e13824ff084a0da121549",
  "0e1202e169b73d4a390a5bb4aaabe5464fa60979",
  "50486f179bacb39b52de18a7062210e845b1b00d",
  "86c7028c4c81e46743014f1d7b532287733c0645",
  "fc24bb9cf0445d4714caa1412a4ca91a14eee2b2",
  "02ea6f2369098d124b236b6a18966e1dbecf9565",
  "33ab64cc2d04208abb6540879cb94d6da352e23e",
  "3c251622dd791ea3071be899ce3c2a43394f3b5e",
  "97ad0b160aefb9f60ef168d3d138791663e91f61",
  "9211ed5ca4d08da5f84d61ec061669cb592abcbc",
  "85e09853180f24afbeb30e1434606ce0bfd0a5f4",
  "1f5604b4da49908b1bc7fbe2c348d7ba2b1e5805",
  "484703b71ffb2cb0e1670b20621cb60f0e6c3d04",
  "1665aa8d39c6a5acce508fd0fd39638a8e6d0a7a",
  "06d8534fa35174ed7b2332a7eebbf14409ca04b4",
  "2fb0a5f0096dbbb657ac5e52620042e328e5b6d5",
  "14fa95d4fb963f600c8a289a5a3e66081a677437",
  "f78bf2a7937f6702bd55bd2257eaed4ee00bb1ac",
  "3b6d50da202cbd89449976a555f26d7f9dc19014",
  "f1274fbd5fca397884809e13c342f3ec8734e1ee",
  "e471d476595eb00477ad431f1aa9578a05dec4c7",
  "3996b948ac9593d98596c4addcbdef0b9cadfc54",
  "f0ff8fc46d1cce7dc7a9fb971cba55ef8a4fd070",
  "da93b5002c2cc87682266f285eeddd1a50a27b5e",
  "9950e9d36997f7074f32c53f487a13de461b30a4",
  "e09457e5a987391ac5fde5ff32299affc27b89e0",
  "f6003ec7e79dd08d1dea26fd484e484d0d7cee7e",
  "e587a8e7aa70955f23b5566f47555608fca864d9",
  "3b555404a95c70533bb2ab013b61be31e12699c9",
  "3f8cfc2373f5f908c20b901a8ba863487d4c599e",
  "9baa42b8635925a7a37d2a86e33ef1e285bdff44",
  "e673d64439b70d97484d69855c7ff22d2ff35d9d",
  "6fb3dc8265f877496cab2eb3ad20e430d4ff722f",
  "1a1082f01fda8245159674018126d62e257691ee",
  "027791b139e6295c9438cb054b0e3330bca26bf9",
  "3cf8e1338427d96c5ede1ee0b03ba60b8f546734",
  "bfff7d7cae21f7da2134c24f768fef25565da5e6",
  "7b24ebfc7370e636f932e17e24b19ef0fc32fddf",
  "c25d93440686a2822e2d3f4672a84a67afc643b8",
  "55f57881efd21158e53dcc8461aa543293f0cbba",
  "72268e6ed5ec0922669344db7eb3c11ab6bf1aec",
  "05fe7d7811230e6884b9ffa67df1b54e6d5c354e",
  "3f0870b3cb0bffc9ad6b20bbc5c1dc35337651d0",
  "71d9d983f7ed746bc1afbca48d7da2001fdce431",
  "a60f8f809caa9081b63c70897c1ad74754c0b079",
  "1ff9b448be0828b60255d30886edbc692b69acd4",
  "3c65337225665fdeac762ff61cf324aa656b11c2",
  "169ea5a92870f10880429bb7cbe02eff80152e47",
  "54223f9232d3d714858108eb57a91aecabbd33bf",
  "6ee8175cefe40fa46f2e98eeafe425e7892007da",
  "04c75d981e4accaf0b67a48a260c39b2c9e47377",
  "95a2622b0b44b70c22224bdddf595fcacd1fcc06",
  "721cecf6ef23ecd6bd1d3fe4fd39780a5d43196f",
  "909eda89551578fa0ee445d08609a0506643234b",
  "98bc5d271f1d80516d5200f6b9b70bb2dcfd7233",
  "3bfb7be5f281a5293fe26700caf451a2be2d45e1",
  "c09d5258089b173615a89e943f92f82710ffc5ae",
  "bb56ae2fc65d8e86664c7361a994e277fee88157",
  "998294912459384f344fa2d086b9cb5fdc1cacf7",
  "9ef99d5665824cc462c49e94b807531487827131",
  "c1f1aef721d014a7b1dcc4f1772ccd32c937b4ba",
  "692f9b9b68bb183c6757aa1c1726693922915444",
  "cfbfff0bd70ab2df7b3ec0a34f0dce6237a74fea",
  "950e5a5919bfcf7f2adf74159256f18be8f2fabe",
  "4dc5d180dba74ca50980322b33ccc5052ea8a1d6",
  "008107c0937b268b543793ca5a325951ab87370f",
  "2d9d5f720dda492b2be7f80c2fc56b5be72b79d3",
  "94b418cf7505868f98f96a66ccbc7b2d4bb77c93",
  "6128df933ba6fd397b3da8c73275fc1caaa7619e",
  "690ea621d9c55eb5bac584f04f3907ee7fa06e87",
  "a13f31818a1219c5ba6627f789c7b070713c7421",
  "4b215da4de7f6c36e9870c306df390ffa45a1d07",
  "2e9b598c5fcee6ead88d6672bf4a897e32bf8dec",
  "4342118b126406d3e5fb8a2ae5c86e3311ac94ae",
  "fe80f76d24d614e10655d645f027a62ed27bced7",
  "f72f9b9ba033176fe3bb0bc8193460ef16415fef",
  "0cdd0a00d2c718ae130a194f0713c51d68286741",
  "e954faab8ae1daa70eb4d42eeaa101cb7e1d7409",
  "4771d9d366767a1cddc0161e63dba2911806fd67",
  "93f6ceda7c10602925f812ed51528e5f4013e60a",
  "37bfc8ac7728307981ce18bd603ef88c4a80584e",
  "41563d6a9b894284180e481a6ea0d5ecb4a49c11",
  "17384e483ddee41cc427f758408b3a14362b86ec",
  "fb20fc65d86aa1b4cfd7939160eda8c729daf9b3",
  "2c86692f5c87f3a6c77c909662cbcbe11f89a45c",
  "ede368c8c3480192341ce357d814eb354cd4d514",
  "09fa16f478be5d3722258cd37ac1f4027b79c174",
  "197a3b8975a6455b0146c23efa62fe82e4cc4bf2",
  "b6a2c544d10829d009cecd60a678f29fb3f4f920",
  "55ad308e90325838ca95c1568b720df861458ed3",
  "41f4833b2aad4064dd09eacdbfc940c923d7e109",
  "62ddcb4df36126b3a8e7ab4675db33ddc2548663",
  "e092737943ad8430d4de220f3788a58110d197ac",
  "69ce011b4b84fc2ea697c399a7a163c362bcf167",
  "53e1e757a713a5d3176a9f381e2fb3cca0d45719",
  "7ee6af3f62bdbcca0842db3b54de03329f6b82ee",
  "556ed8f46262521444c72b1ce9f03efdd657921d",
  "6281720174c274fc7454009bbaafd4b3209db49b",
  "ff8b2d64215e49d375a7ffc3acadc160931c74b7",
  "9a709761d2fabb89191b8a6ec474e9340535d736",
  "d560d26115677c4f48b09dbee8395868106d66cb",
  "73ec0598929e0c96ab3cc68ff551548e32d6f938",
  "5f5ffee799d2971d8c53754671e952723546a15f",
  "96f847dcb0f481905120965a5d6911404220c027",
  "484d288699ee79d22b9b20c21388458d76d2e626",
  "084c43b67b378979c0e659be4746b255806b7690",
  "db4700b4af19de5b9400ee5e7e7754913df25c4d",
  "c0d3a661fd62f136565f6d71139f800a9aad91c4",
  "5353a368cfeca71b776d62fc0f57b4b26cd80a69",
  "67c3f62a35854f1894e1b6f66326db8235c502dd",
  "14b0b147ccdfffc89d6f15fe67c246f46f79aad0",
  "8fedbdc53c3b8c3b214d947a1d1e324a13c42de1",
  "c54e9b71b60e00b2001106e629ab7529abdb0c2f",
  "d53b878593258945c20cf86a9d627ba732b6795b",
  "eb9e8396dfbf4796de4d7b6552dc714a03a43ce0",
  "6aba5a018c9977f127072205bca3b2ee6705b429",
  "f8ac3f569eca85f6556d7c89fef2d707af9796bf",
  "7b575c11fc1c4dbe8b816f211296ed857cf01b56",
  "a74a4e1969b69ba9f28e23d60f67a5895e7ccd8f",
  "58c44015f6d2ec13f902ad21ae96149642f23ebb",
  "8801525882b1579a1ead05d0d8b1dbd9cc09be41",
  "1e2212ea1746d9469c02a6a81511fd9f80916a05",
  "7a264cf55f010e6ce343e296cd8c79c168d1989c",
  "c0c8732a227cc23afd00209256f30b252ff3289e",
  "1b5a6b80395e659d51d00e5ea12eb91bc132e76b",
  "2b8057426effa70978c6fb6188fa7289e93baee4",
  "f4d21a26d263c69916a4bc7bb5da97c1bb2a78b8",
  "9c61c90e6efb8d87e5027af5a3db62e27aee87a3",
  "37db1577c395891f53e080f4a09c89a59c575a91",
  "55b19295d0d6ce4684685196e069199004e4ef38",
  "9f15cda7c03f814cd23104906c6826d3bbbe7c44",
  "c1f9ffdd357cdb69842b36705a9656c413b562a9",
  "68473753efa167a61861280ca526e85d139846df",
  "ff7eaf7fcd06f33293df72da96fdade659216412",
  "233d476f6f7716b8b897427764c6ff2480732141",
  "921df6d60517843d31e8d318a1671715eb7b9227",
  "c9334d4865cf671e97c0e6f18668697903f5819a",
  "8ef4063884d969d5595db5696e90e5f0834fdf3f",
  "104e5d7504bc8525bf2bc3e687ec937a8e850b13",
  "b48a9eac078d72b7f191c7fd769b7e2ca7aff639",
  "4a324c029080d5b989475ffa860ef45e8181e493",
  "640f4c867be2e7ed8117456332b27559eefbaea1",
  "d3df9ea65e14eff7895c728ba7449d6512c64447",
  "e72200364e165a3cee049ee53e61bd34a11823cf",
  "30ffe7605b65f06602bf9bf19b9008669c939980",
  "90c3badaec2bad638a4bc23ecc61b88261505e57",
  "612d724a2576483ace0bbfd3f5a708e62e3dd603",
  "4281a0ac88f08df605a9768f5bee7d694dd739fd",
  "56676139cffa6a2791677a87bf8ba967585070df",
  "752cd0c8a9852c415ae8e8e8e379cab8203c85e6",
  "ebfd630ef966769eae5a07e2c54fa5d78b316824",
  "8fdfc89470edcfa1e40c80cc38ad105bed57e159",
  "144ef7665a44161f59445ac7c50521c287b959ef",
  "95b6258ceb4d964da24432d1b24ba5d2eb38db0a",
  "903aadc0137bc6d1bd5d5f22f13408cca0504cb0",
  "aa3a1e867d1e7f4f1125b221fa528937c38725e8",
  "5ba550a940679ba05435c57980e6331c4f1297e9",
  "56231498e91ba41ddabba516469e09954169045e",
  "959594b99146c5850b892b9d03d9b48ffd3fd953",
  "ed697cd94a85586d4ebfc44c82b36e622ae9d70c",
  "b120e25d6add936155c76a55f9eb8eee419ce020",
  "c45a9ca4f909fe7676a293b3a345fbb314390e32",
  "c709bedb065bc54f1dfbbcfdcf5de19feb54bfaa",
  "a5fdb0d38bacbf57331c91773dcbd893ffcfcabb",
  "8d88fc45bc9136ed0dfdeed2614449bdb96d0dce",
  "dfd76ca84f846d3c53fc86646fae8cd5ce1a3232",
  "785755dd24178714a8b359e98a9e82ea49878747",
  "8c7747095f51b4c357f5f9d1eb88f2ad803f4d2a",
  "ddfe4e5f3c1b430740ddb3b31ccd64f8b517e212",
  "9a732709ad6eba6f2a054e70ce137a94c163dd45",
  "18f2d21465f1f5c641e7a1c5102902ee15222218",
  "7610b52db9e657b2ad7fd0ba170cd4d8980f8831",
  "162a6fc77d7be69f79d20d464762f605bd04f0ea",
  "a000888f2fc07779c9112d32b0e83acae5bd1b7b",
  "cba3ee378c163f4fb9b9faf53d7a32e5cabfe37b",
  "d721c61892d7daa696a4e2bf7faa0481f5bb32ff",
  "46cf4b560a967ff11a458e13aa8e1e5352a81de1",
  "c63b417b8ef0a33026ae7f683bb81cb8bd24fb35",
  "44b213f7284eab74f4203e885ac643d39a3d76ef",
  "9e08e63786a82746349787413b6016b1f6dc3c17",
  "cc1cca5055141ff3109d00d3e48a5475c2bd48dc",
  "b037cc7122d8410d02116c883a61df3ca18b9c50",
  "6cbff797209ae1eb82e34c82d66fbf60d14ca344",
  "507d567e856c5fa508aa657d92c3dee7348b540e",
  "120075a74b3b6ca6b45d8be9bb05497c13d73265",
  "40b0dae73d4d6e275c861dea60e9e0f20536efcf",
  "a17731f4c3edf460e4d42b4d60b6a13870fafd2d",
  "3e07201e8155f40f1bd429cbc1618e5a64dba8b2",
  "7bbe0d303e87036469219353520cd06be9ee4a09",
  "25d67de2e41de809576b26557b23c023f383bff8",
  "eba1579383ef0f9b6164f62b3112654a53cc5f60",
  "7f1a63c154a7b5d00bb22e09455b9d5afd7608d5",
  "9d0c3cbd720b64b0ffd604cb62c51bf079be1065",
  "54d5e2d2ff4451fbc9bb9d7333b5682480d8d934",
  "c94f2dbabac334f55e530f14dd538a8215948bc8",
  "7e6ddf85455e88606034ca57eb8ad86093a1daa1",
  "2b87962d7da166ab705dd5637477e8f927fbfd44",
  "334d927f09793082a9dd300da92c6294fa578fa5",
  "1b6a7b2a2194a360187832859128f1d6734b3296",
  "38299fe1f5c726fe8e2c553741c6d6d44ac443ab",
  "05c46a72d276e48da07bf3d043aa23353b78609c",
  "fc45d76092147dacecffd562cc30bc593c066794",
  "0b4c73341db8ce8e6a7e1505bb94003b8a008edd",
  "72f4adc0a37749f8a97d0fd8bf0451da5307ff1b",
  "d25e183d00750b011fa2b37b6da8c5f1140607db",
  "63c5b8ed60dee7f225ba71887cf6e953a1faa3e8",
  "9aa572bda8839c34afc6ab9f8ecd08d301d713fa",
  "5bbbee167feb2c7a26fef765eb1eedcccabbad1a",
  "3f30c144e7509f9b467b52fa8894755438606eb5",
  "82691d2f51c1840e621d09d6b58239e18cda2d78",
  "1739c4bbd4f07d133fb585200703d03699d1aac9",
  "d89bb14da00dfc68b28342ef8626295f635727f4",
  "bcb4c76871eab64ba3883a6801d38994185fc806",
  "173cf9a329cf1ba69cf4aa85484f9748e1b64906",
  "1f7f287cd7c166ef23cd6e9e624d0dd44f07fbae",
  "9b9c64def7b6a0b90f32d8a5ab02c8b55e2d7efa",
  "5e0655d2f167bfc48605774f195e99025486834f",
  "2548407359dadfedeacaefedb6fdc43dda50be8b",
  "e9e68dc9c393d72a1a2c7bb6238041228c489438",
  "c74c7309a4437b4e35f287186b44caa748fc9816",
  "7b4fd2afc42a076938526505806bee89119ebe2b",
  "36e13c0d499d0cbc6d7d2e356d0b1394f0e3dbfb",
  "5b0efeef0e13f2d0534477d1f7d9f0a73189a281",
  "2b59594aa35c50d61214b29d531ae046d5a3e2c7",
  "cc34c2540d47642f38ed5e980bc6e2e843c0b02c",
  "cdad2ba7ab895c26d0de06176102c705ba2c880f",
  "8d909a037922a4baab1ea2afb48f1b875e1e04bb",
  "6c72602f0e1ce9c191d3e0fae12cdee719d2f501",
  "379d20025e83120352c046af8e0807ed783ae780",
  "046b588c0a1045524af834166e5c8e89bf3be304",
  "25f67e9875a90aee60bf1dc1b26c2750294aa7b7",
  "8fa552efdcb67d98b5e0189144e99607f5a807fe" };

UNIT_TEST(crypto, calculate_ident)
{
  // NIST checks all SHA implementations using a test system
  // outlined in the SHA Verification System PDF obtained at
  // http://csrc.nist.gov/cryptval/shs/SHAVS.pdf

  // There are three tests outlined:
  //   - Short Message Test:  A small message is provided as
  //     an input with a pre-computed digest.  If the crypto
  //     module under test produces a HASH that matches the
  //     known digest, the test passes
  //
  //   - Long Message Test:  A larger message is provided.
  //     As before, if the computed HASH matches the expected
  //     one, the test passes.  Note:  These messages often run
  //     into KBs/MBs.  The goal is to confirm that crypto
  //     libraries do not have an artifical ceiling set on the
  //     size of a message.
  //
  //   - Monte Carlo Test:  This tests the usage of SHA in
  //     PRNGs.  A known 'seed' is provided.  This 'seed' is
  //     hashed and used as input into the next iteration.
  //     This continues for 100,000 iterations.  After every
  //     1000 hashes, the computed hash is compared to a known
  //     one.  If they match, the test succeeds.


  // This test has been updated to include a defined Short
  // Message test, and the Monte Carlo Test.  The Long Message
  // test has been dropped as suitable, pre-computed values, are
  // not available.  Also, instead of the expected 100,000
  // iterations, the MCTs are run for 1,000,0000 so that they can
  // double up as a benchmark for SHA.

  hexenc<id> output, output2;

  //SHA Short Message Test
  data input(decode_hexenc("5e"));
  string ident("5e6f80a34a9798cafc6a5db96cc57ba4c4db59c2");

  calculate_ident(input, output);

  //L(FL(" Input: %s") % input);
  //L(FL("Output: %s") % output);

  BOOST_CHECK(output() == ident);
  L(FL("SHA Short Message Test:  Passed\n\n"));


  //SHA Monte Carlo Test
  //
  //INPUT: Seed - A random seed n bits long
  //
  //   for (j=0; j<100; j++) {
  //
  //      MD0 = MD1 = MD2 = Seed;
  //
  //      for (i=3; i<1003; i++) {
  //         Mi = MDi-3 || MDi-2 || MDi-1;
  //        MDi = SHA(Mi);
  //      }
  //
  //      MDj = Seed = MDi;
  //      OUTPUT: MDj
  //   }
  //

  //Seed = d0569cb3665a8a43eb6ea23d75a3c4d2054a0d7d
  string Seed = ("d0569cb3665a8a43eb6ea23d75a3c4d2054a0d7d");

  string MD[1003];

  for (int j = 0; j < 1000; j++)
    {

      MD[0] = Seed;
      MD[1] = Seed;
      MD[2] = Seed;

      for (int i = 3; i < 1003; i++)
        {
          string messageString = MD[i - 3] + MD[i - 2] + MD[i - 1];
          // L(FL("messageString: %s") % messageString );

          data messageData(decode_hexenc(messageString));
          // L(FL("message: %s") % messageString );

          calculate_ident(messageData, output2);
          // L(FL("output: %s") % output2 );

          MD[i] = output2();
        }

      L(FL("  %03d:  %s") % j % output2 );

      BOOST_CHECK(output2() == expected_SHA_MCT[j]);

      MD[j] = output2();
      Seed  = MD[j];
    }

  L(FL("SHA Monte Carlo Test:  Passed\n\n"));
}

#endif // BUILD_UNIT_TESTS

// Local Variables:
// mode: C++
// fill-column: 76
// c-file-style: "gnu"
// indent-tabs-mode: nil
// End:
// vim: et:sw=2:sts=2:ts=2:cino=>2s,{s,\:s,+s,t0,g0,^-2,e-2,n-2,p2s,(0,=s:
