/***********************************************************
 * 
 * Copyright 2011 Adobe Systems Incorporated. All Rights Reserved.
 *
 * *********************************************************
 * The contents of this file are subject to the Berkeley Software Distribution (BSD) Licence
 * (the "License"); you may not use this file except in
 * compliance with the License. 
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 *
 * The Initial Developer of the Original Code is Adobe Systems Incorporated.
 * Portions created by Adobe Systems Incorporated are Copyright (C) 2011 Adobe Systems
 * Incorporated. All Rights Reserved.
 **********************************************************/
package org.osmf.smpte.tt.styling
{
	public class Colors
	{
		/**
		 *     Gets the system-defined color that has the ARGB value of #FF000000.
		 *
		 * @returns
		 *     A ColorExpression that has an ARGB value of #FF000000.
		 */
		public static const Black:ColorExpression = new ColorExpression(0x000000,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FF0000FF.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FF0000FF.
		 */
		public static const Blue:ColorExpression = new ColorExpression(0x0000FF,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FFA52A2A.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FFA52A2A.
		 */
		public static const Brown:ColorExpression = new ColorExpression(0xA52A2A,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FF00FFFF.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FF00FFFF.
		 */
		public static const Cyan:ColorExpression = new ColorExpression(0x00FFFF,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FFA9A9A9.
		 *
		 *     A ColorExpression that has the ARGB value of #FFA9A9A9.
		 */
		public static const DarkGray:ColorExpression = new ColorExpression(0xA9A9A9,1);

		/**
		 *     Gets the system-defined color that has the ARGB value of #FF808080.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FF808080.
		 */
		public static const Gray:ColorExpression = new ColorExpression(0x808080,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FF008000.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FF008000.
		 */
		public static const Green:ColorExpression = new ColorExpression(0x008000,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FFD3D3D3.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FFD3D3D3.
		 */
		public static const LightGray:ColorExpression = new ColorExpression(0xD3D3D3,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FFFF00FF.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FFFF00FF.
		 */
		public static const Magenta:ColorExpression = new ColorExpression(0xFF00FF,1);

		/**
		 *     Gets the system-defined color that has the ARGB value of #FFFFA500.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FFFFA500.
		 */
		public static const Orange:ColorExpression = new ColorExpression(0xFFA500,1);

		/**
		 *     Gets the system-defined color that has the ARGB value of #FF800080.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FF800080.
		 */
		public static const Purple:ColorExpression = new ColorExpression(0x800080,1);

		/**
		 *     Gets the system-defined color that has the ARGB value of #FFFF0000.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FFFF0000.
		 */
		public static const Red:ColorExpression = new ColorExpression(0xFF0000,1);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #00FFFFFF.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #00FFFFFF.
		 */
		public static const Transparent:ColorExpression = new ColorExpression(0xFFFFFF,0);
		
		/**
		 *     Gets the system-defined color that has the ARGB value of #FFFFFFFF.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FFFFFFFF.
		 */
		public static const White:ColorExpression = new ColorExpression(0xFFFFFF,1);

		/**
		 *     Gets the system-defined color that has the ARGB value of #FFFFFF00.
		 *
		 * @returns
		 *     A ColorExpression that has the ARGB value of #FFFFFF00.
		 */
		public static const Yellow:ColorExpression = new ColorExpression(0xFFFF00,0);
	}
}