/*
 * This is a C library that makes it easier to write moo methods in C.
 * It's very incomplete so far. It doesn't try to be pseudo-OO (yet).
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

/* This structure represents a mooix object. */
typedef struct object_t {
	char *dir;
	dev_t dev;
	ino_t ino;
} object;

/* This structure is used to return name + value pairs */
typedef struct param_t {
	char *name;
	char *value;
} param;

/* "Magic" initialization; tells libmooproxy to put the method into its
 * object's directory. */
int methinit (void);
 
/* Parse method input (from stdin). This is used a bit like getopt;
 * call it in a loop and examine its return value. It will return
 * param structs until it runs out of input, and then will return
 * NULL. */
param *getparam (void);

/* Read next parameter as a key. */
char *getkey (void);
/* Get a value from stdin. */
char *getvalue (void);
/* Read next parameter as a value, from a specific FILE. */
char *fgetvalue (FILE *f);
/* Read remainder of parameters as values, and return a string array of
 * them, NULL terminated. */
char **getallvals (void);
/* Read remainder as values, from a FILE. */
char **fgetallvals (FILE *f);
/* Frees a param structure. */
void freeparam (param *param);

/* Escape a string for passing to method. Returns a freshly malloced string. */
char *escape (const char *s);
/* Unescape a strng passed to method. */
char *unescape (char *s);
	
/* Takes a string (handles NULL as well) that is a mooix object reference,
 * in the form passed between methods ("mooix:dir"), and returns a malloced
 * object structure, or NULL if it's not a valid object reference. */
object *derefobj (const char *s);

/* Takes a string (may be static) that tells the directory of an oject,
 * and returns an object structure. */
object *getobj (char *s);

void freeobj (object *obj);

/* Returns true if the object has or inherits the field, and the field has
 * a true value (1) */
int truefield (object *obj, const char *field);
/* Gets and returns a field of the current object. Does not do inheritence,
 * and only returns the first line of the field. */
char *getfield (const char *field);
/* Sets a field of the current object to a value. Returns true if the set
 * succeeds. */
int setfield (const char *field, const char *value);
/* Find the filename of the field starting in the given object's directory,
 * and doing a parent traversal if needed. */
char *fieldfile (object *obj, const char *field);
/* Runs the method, passing into it the list of parameters given (NULL
 * terminated, or may be NULL for no params). Then returns a FILE open to the
 * result channel of the method. Use fgetvalue to read the method's return
 * values. Note that the method will be searched for, you don't need to,
 * and should not, call fieldfile manually here. Returns NULL on error. */
FILE *runmethod (object *obj, const char *method, char **params);
/* This is a version of runmethod that does not pass parameters to the
 * child. The pair of returned file pointers are connected to the child's
 * stdin and stdout respectively, and you can talk to it on your own later. */
FILE **runmethod_raw (object *obj, const char *method);


/* Compares two objects (looking at their inodes); returns like strcmp. */
int objcmp (object *a, object *b);

/* Stats an object, records its dev and inode numbers in the struct.
 * Returns true if the stat succeeded. */
int statobj (object *obj);

/* Read a line of any size and return a malloced string, or NULL on eof. */
char *mooix_getline (FILE *f, int killquotes);
