=begin

= Name
conf.rb - Read-only interface to Mooix's configuration file

= Synopsis

  require "mooix/conf"

= Description

This module provides a quick, read-only interface to Mooix's
configuration file. It stores these values in a Hash,
((|Mooix::Conf::FIELDS|)), in which the keys are the various named
configuration parameters.

=end

module Mooix
  module Conf

    FIELDS = Hash.new

    File.open("$(sysconfdir)/mooix.conf") do |f|
      f.each do |line|
	line.strip!
	next if line =~ /^\s*$/ or line =~ /\s*#/
	if line =~ /^([_a-zA-Z]+)="?(.*?)"?\s*$/
	  parts = /^([_a-zA-Z]+)="?(.*?)"?\s*$/.match(line)
	  eval "FIELDS['#{parts[1]}'] = '#{parts[2]}'"
	end
      end
    end

end
end
