/*
 * Stackinfo structures hold an object stack and some additional data about
 * it.
 *
 * Copyright 2001-2003 by Joey Hess <joey@mooix.net>
 * under the terms of the GNU GPL.
 */

#include "mood.h"
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <syslog.h>

/* Create an empty stackinfo structure and return it. */
stackinfo *stackinfo_create (void) {
	stackinfo *ret = malloc(sizeof(stackinfo));
	assert(ret != NULL);
	bzero(ret, sizeof(stackinfo)); /* zero stack and all flags */
	return ret;
}

/* Check to see if the info indicates the important_ok flag is set. 
 * If it is not yet calculated, calculate it (rather expensive to do). */
enum tristate important_ok (stackinfo *info) {
	if (info->important_ok != unknown) {
		return info->important_ok == true ? 1 : 0;
	}
	else {
		if (info->callerstack == NULL ||
		    callstack_is_subset(info->callerstack, callstack_extend(callstack_extend(object_owner_stack(THISFD), info->stack), mooadminstack))) {
			return info->important_ok = true;
		}
		else {
			return info->important_ok = false;
		}
	}
}
