#include <string.h>
#include <sys/file.h>
#include <stdio.h>
#include <stdlib.h>
#include <moomethod.h>

int main (int argc, char **argv) {
	param *p;
	object *obj = NULL;
	FILE *f;
	char *line;
	int ret = 0;
	int size = 16;
	int itemcount = 0;
	object **items = malloc(size * sizeof(object *));
	object *item;
	signed int ignoreitem = -1;

	methinit();
	while ((p = getparam())) {
		if (strcmp(p->name, "object") == 0) {
			obj = derefobj(p->value);
		}
	}
	
	if (! obj) {
		fprintf(stderr, "object field required\n");
		exit(1);
	}

	f = fopen("list", "r");
	if (! f) {
		perror("open list");
		exit(1);
	}
	if (flock(fileno(f), LOCK_EX) != 0) {
		perror("flock");
		exit(1);
	}
	

	/* Go through the list, and see if an object can be found with the
	 * same name as the parameter object. This is done first because it
	 * is relatively inexpensive. If the names match do a true
	 * (expensive) compare. */
	while ((line = mooix_getline(f, 0))) {
		item = derefobj(line);
		if (item) {
			/* Only skip over the first match. */
			if (! ret &&
			    strcmp(item->dir, obj->dir) == 0 && 
			    objcmp(item, obj) == 0) {
				ret = 1;
			}
			else {
				/* Not skipped, so add to list of items. */
				if (itemcount > size) {
					size *= 2;
					items = realloc(items, size * sizeof(char *));
				}
				items[itemcount] = item;
				itemcount++;
			}
		}
	}
	fclose(f);

	/* If looking up by name failed, fall back to testing each item
	 * with objcmp. This is a lot slower though. */
	if (! ret) {
		int i;
		for (i = 0; i < itemcount; i++) {
			if (! ret && objcmp(obj, items[i]) == 0) {
				ret = 1;
				/* ignore this one when writing out file */
				ignoreitem = i;
			}
		}
	}
	
	if (ret) {
		/* Write file back out. */
		int i;

		f = fopen("list", "w");
		
		for (i = 0; i < itemcount; i++) {
			if (ignoreitem != i)
				fprintf(f, "mooix:%s\n", items[i]->dir);
		}
		fclose(f);
	}

	printf("%i\n", ret);
	exit(0);
}
