/* This method implements both write and page.
 * Store the message in the log file.
 */

#include <stdlib.h>
#include <stdio.h>
#include <moomethod.h>
#include <sys/time.h>
#include <time.h>
#include <sys/file.h>
#include <string.h>

/* Remove xml tags from the text. Also handle entities. */
char *dexml (char *text) {
	char *ret, *s, *e, *a = NULL;
	int len = strlen(text);

	if (len == 0)
		return text;
	else
		ret = malloc(len + 1);
	ret[0] = '\0';
	
	while ((s = strchr(text, '<')) || (a = strchr(text, '&'))) {
		if (a) {
			a[0] = '\0';
			a++;
			strcat(ret, text);
			
			e = strchr(a, ';');
			if (! e) {
				strcat(ret, "&");
				text=a;
			}
			else {
				e[0] = '\0';
				if (strcmp(a, "lt") == 0)
					strcat(ret, "<");
				else if (strcmp(a, "gt") == 0)
					strcat(ret, ">");
				else if (strcmp(a, "amp") == 0)
					strcat(ret, "&");
				text=e+1;
			}

			a=NULL;
		}
		else {
			s[0] = '\0';
			s++;
			/* XXX should really escape entities in
			 * here.. */
			strcat(ret, text);
		
			e = strchr(s, '>');
			if (! e) { /* unterminated */
				strcat(ret, text);
				return ret;
			}

			e[0]='\0';
			text=e+1;
		}
	}

	strcat(ret, text);
	return ret;
}

int main (int argc, char **argv) {
	struct timeval t;
	FILE *log;
	char **lines;
	int c;
	
	methinit();
	lines=getallvals();
	
	log = fopen("log", "a");
	if (log == NULL) {
		perror("fopen log file");
		exit(1);
	}

	if (flock(fileno(log), LOCK_EX) == -1) {
		perror("lock log");
		exit(1);
	}

	gettimeofday(&t, NULL);
	
	for (c = 0; lines[c] != NULL; c++) {
		char * line = lines[c];
		do {
			char *newline = strchr(line, '\n');
			if (newline) {
				newline[0] = '\0';
				newline++;
			}
			fprintf(log, "%li.%06li %s\n",
				t.tv_sec, (long int) t.tv_usec, dexml(line));
			line = newline;
		} while (line);
	}
	return(0);
}
