"""Python 2.2.1+ binding for mooix
Copyright (c)2002,2003 Nicholas D. Borko.  All Rights Reserved.
The author can be reached at nick@dd.revealed.net

The Python binding for mooix is free software; you can redistribute
it and/or modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

The Python binding for mooix is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with mooix; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA."""

import os, os.path, sys, warnings
from Thing import *
from Result import *
from debug import debug
from functions import *
from util import *
import variables

this = None
initialized = False
args = None
MOOROOT = variables.MOOROOT

def initialize():
    """Initialize the module."""
    global initialized, this, args
    if not initialized:
        # warn about bad install here, so only methods see this if embedded
        if MOOROOT is None:
            warnings.warn('Incorrect install of mooix module: MOOROOT not set',
                          RuntimeWarning, stacklevel = 3)

        # the THIS environment variable should be the path
        if os.environ.has_key('THIS'):
            this_path = os.environ['THIS']
        else:
            warnings.warn("os.environ['THIS'] not set -- not running under mooix?",
                          RuntimeWarning, stacklevel = 3)
            this_path = os.curdir

        # strip any "mooix:" prefix
        if this_path[:6] == "mooix:":
            this_path = this_path[6:]

        # read in the arguments from stdin and convert to a Result (derivative)
        # a method can return
        variables.args = args = Arguments(sys.stdin)
        debug('args: %s' % args.dict)

        # if there isn't a .mooix file here, then return now
        if not os.path.exists('%s/.mooix' % this_path):
            sys.exit(0)

        this = Thing(this_path)
        initialized = True

if not hasattr(sys, 'MOOD_EMBEDDED') and \
   os.path.basename(sys.argv[0]) != 'pydoc': # don't initialize if it's pydoc
    initialize()

__all__ = [ 'MOOROOT', 'this', 'MooixError', 'Thing', 'LOCK_UN', 'LOCK_SH',
            'LOCK_EX', 'LOCK_NB', 'args', 'background', 'exit',
            'OK', 'FAIL', 'SKIP', 'EXIT', 'SETIT', 'SETITREF' ]
