/*
 * Access to wrapped libc functions. Here be dragons.
 *
 * Copyright 2002-2003 by Joey Hess <joey@mooix.net>
 * under the terms of the modified BSD license given in full in the
 * file COPYRIGHT.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef __GNUC__
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#ifndef __USE_GNU
#define __USE_GNU
#endif
#endif
#include <dlfcn.h>

#define GENERATE_FUNCTIONS

/* Generates a function that calls a real unwrapped libc function. */
/* Note that this uses gnu cpp varargs "ARG...". For C99 compliance,
 * it should be changed to use "..." and then "__VA_ARGS__" */
#define func(FAILCODE, TYPE, FNAME, ARGS...) \
	TYPE real_##FNAME (ARGS) { \
		typedef TYPE (*FNAME##_type)(ARGS); \
		static FNAME##_type f; \
		if (! f) { \
			f = dlsym(RTLD_NEXT, #FNAME); \
			if (! f) \
				return FAILCODE; \
		}
#define args(ARGS...) \
		return f(ARGS); \
	}

#include "functions.h"
