#!/bin/bash
# copyright (C) 1997-2003 Jean-Luc Fontaine (mailto:jfontain@free.fr)
#
# moomps: This starts and stops moomps
#   (placed in /etc/rc.d/init.d/ on a Red Hat system).
# $Id: moomps.sh,v 1.15 2004/10/30 19:50:09 jfontain Exp $
#
# chkconfig: 345 56 50
# description: moomps (Modular Object Oriented Multi-Purpose Service)
#              uses moodss configuration (save) files to send email
#              alerts, update the system log when thresholds occur and
#              archive data in a SQL file based database or server.
#
# processname: /usr/sbin/moomps
# config: /etc/moomps/rc

PATH=/sbin:/bin:/usr/bin:/usr/sbin

# source functions library:
. /etc/init.d/functions

[ -f /usr/sbin/moomps ] || exit 1
[ -d /etc/moomps ] || exit 1

RETURN=0

start(){
    echo -n $"Starting moomps: "
    # link to process ID file in writable directory:
    ln -sf /etc/moomps/moomps.pid /var/run/
    # load all configuration files from directory:
    daemon --user moomps /usr/sbin/moomps --pid-file /etc/moomps/moomps.pid /etc/moomps/
    RETURN=$?
    echo
    touch /var/lock/subsys/moomps
    return $RETURN
}

stop(){
    echo -n $"Stopping moomps: "
    killproc moomps
    RETURN=$?
    echo
    rm -f /var/lock/subsys/moomps
    return $RETURN
}

restart(){
    stop
    start
}

condrestart(){
    [ -e /var/lock/subsys/moomps ] && restart
    return 0
}

# see how we were called:
case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    status)
        status moomps
        ;;
    reload | restart)
        restart
        ;;
    condrestart)
        condrestart
        ;;
    *)
        echo $"Usage: $0 {start|stop|status|restart|condrestart|reload}"
        RETURN=1
esac

exit $RETURN
