'Generated, don't change anything here.
Imports System
Imports System.IO
Imports System.Reflection
Imports NUnit.Framework

<TestFixture ()> _
Public Class FileSystemTestGenerated
	
'STARTCOPY
    Private DATA_DIR As String

    Sub New()
        Threading.Thread.CurrentThread.CurrentCulture = New Globalization.CultureInfo("en-US")
        Threading.Thread.CurrentThread.CurrentUICulture = Threading.Thread.CurrentThread.CurrentCulture

        DATA_DIR = Environment.GetEnvironmentVariable("DATA_DIR")
        If DATA_DIR Is Nothing OrElse DATA_DIR = String.Empty Then
            DATA_DIR = Path.Combine(Path.GetTempPath, MethodInfo.GetCurrentMethod.DeclaringType.Name.Replace("Generator", "Generated"))
        End If
    End Sub

    Private Sub Initialize()
        If Directory.Exists(DATA_DIR) = False Then
            Directory.CreateDirectory(DATA_DIR)
        End If
    End Sub

    Private Sub CleanUp()
        'Close all files and delete them
        Microsoft.VisualBasic.FileSystem.FileClose()
        If Directory.Exists(DATA_DIR) Then
            Directory.Delete(DATA_DIR, True)
        End If
    End Sub

    
	<Test ()> _
	Sub FilePutTest_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, True)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, False)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, " "c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, "￿"c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, CByte (0))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, CByte (255))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Int16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Int16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Int32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Int32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Int64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Int64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Single.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Single.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Single.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Single.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Single.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Single.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Double.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Double.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Double.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Double.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Double.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, Double.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, DateTime.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, DateTime.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, "")
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, CStr (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Append_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Append_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePut(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, True)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, False)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, " "c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, "￿"c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 63 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, CByte (0))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, CByte (255))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Int16.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Int16.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Int32.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Int32.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Int64.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Int64.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 255, 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Single.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 127, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Single.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 127, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Single.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 1, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Single.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 192, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Single.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 128, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Single.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 128, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Double.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 255, 255, 255, 239, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Double.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 255, 255, 255, 239, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Double.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 1, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Double.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 248, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Double.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 240, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, Double.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 240, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.OverflowException ('Value was either too large or too small for a Currency.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.OverflowException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Value was either too large or too small for a Currency.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.OverflowException ('Value was either too large or too small for a Currency.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.OverflowException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Value was either too large or too small for a Currency.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, DateTime.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, DateTime.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 231, 255, 255, 255, 64, 146, 70, 65 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, "")
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, CStr (Nothing))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Binary_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Binary_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePut(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_1'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_1?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_1?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, True)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_2'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_2?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_2?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, False)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_3'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_3?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_3?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, " "c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_4'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_4?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_4?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, "￿"c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_5'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_5?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_5?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, CByte (0))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_6'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_6?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_6?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, CByte (255))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_7'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_7?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_7?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Int16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_8'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_8?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_8?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Int16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_9'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_9?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_9?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Int32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_10'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_10?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_10?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Int32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_11'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_11?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_11?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Int64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_12'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_12?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_12?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Int64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_13'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_13?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_13?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Single.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_14'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_14?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_14?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Single.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_15'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_15?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_15?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Single.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_16'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_16?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_16?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Single.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_17'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_17?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_17?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Single.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_18'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_18?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_18?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Single.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_19'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_19?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_19?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Double.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_20'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_20?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_20?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Double.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_21'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_21?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_21?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Double.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_22'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_22?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_22?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Double.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_23'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_23?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_23?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Double.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_24'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_24?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_24?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, Double.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_25'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_25?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_25?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_26'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_26?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_26?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_27'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_27?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_27?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, DateTime.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_28'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_28?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_28?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, DateTime.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_29'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_29?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_29?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, "")
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_30'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_30?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_30?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, CStr (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_31'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_31?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_31?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_32'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_32?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_32?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Input_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Input_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePut(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutTest_Input_33'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutTest_Input_33?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutTest_Input_33?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, True)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, False)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, " "c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, "￿"c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, CByte (0))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, CByte (255))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Int16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Int16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Int32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Int32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Int64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Int64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Single.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Single.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Single.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Single.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Single.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Single.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Double.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Double.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Double.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Double.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Double.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, Double.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, DateTime.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, DateTime.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, "")
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, CStr (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Output_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Output_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePut(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, True)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, False)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, " "c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, "￿"c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 63 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, CByte (0))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, CByte (255))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Int16.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Int16.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Int32.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Int32.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Int64.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Int64.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 255, 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Single.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 127, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Single.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 127, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Single.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 1, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Single.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 192, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Single.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 128, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Single.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 128, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Double.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 255, 255, 255, 239, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Double.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 255, 255, 255, 255, 255, 255, 239, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Double.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 1, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Double.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 248, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Double.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 240, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, Double.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 240, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.OverflowException ('Value was either too large or too small for a Currency.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.OverflowException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Value was either too large or too small for a Currency.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.OverflowException ('Value was either too large or too small for a Currency.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.OverflowException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Value was either too large or too small for a Currency.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, DateTime.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, DateTime.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 231, 255, 255, 255, 64, 146, 70, 65 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, "")
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, CStr (Nothing))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutTest_Random_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutTest_Random_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePut(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, True)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, False)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, " "c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, "￿"c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, SByte.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, SByte.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Append_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, CByte (0))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, CByte (255))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Int16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Int16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, UInt16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, UInt16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Append_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Int32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Int32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, UInt32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, UInt32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Append_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Int64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Int64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, UInt64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Append_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, UInt64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Append_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Single.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Single.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Single.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Single.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Single.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Single.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Double.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Double.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Double.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Double.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Double.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, Double.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_34()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_34")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_35()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_35")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_36()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_36")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, DateTime.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_37()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_37")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, DateTime.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_38()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_38")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, "")
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_39()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_39")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, CStr (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_40()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_40")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Append_41()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Append_41")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			FilePutObject(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, System.DBNull.Value)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 1, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, True)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 11, 0, 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, False)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 11, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, " "c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 18, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, "￿"c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 18, 0, 63 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, SByte.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'SByte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'SByte' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, SByte.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'SByte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'SByte' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Binary_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, CByte (0))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 17, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, CByte (255))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 17, 0, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Int16.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 2, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Int16.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 2, 0, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, UInt16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UShort' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UShort' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, UInt16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UShort' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UShort' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Binary_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Int32.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 3, 0, 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Int32.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 3, 0, 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, UInt32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UInteger' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UInteger' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, UInt32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UInteger' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UInteger' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Binary_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Int64.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Int64.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 20, 0, 255, 255, 255, 255, 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, UInt64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'ULong' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'ULong' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Binary_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, UInt64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'ULong' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'ULong' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Binary_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Single.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 255, 255, 127, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Single.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 255, 255, 127, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Single.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 1, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Single.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 0, 0, 192, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Single.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 0, 0, 128, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Single.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 0, 0, 128, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Double.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 255, 255, 255, 255, 255, 255, 239, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Double.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 255, 255, 255, 255, 255, 255, 239, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Double.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 1, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Double.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 0, 0, 0, 0, 0, 0, 248, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Double.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 0, 0, 0, 0, 0, 0, 240, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, Double.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 0, 0, 0, 0, 0, 0, 240, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_34()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_34")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, -79228162514264337593543950335D)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 14, 0, 14, 0, 0, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_35()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_35")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, 79228162514264337593543950335D)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 14, 0, 14, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_36()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_36")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, DateTime.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 7, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_37()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_37")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, DateTime.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 7, 0, 231, 255, 255, 255, 64, 146, 70, 65 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_38()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_38")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, "")
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 8, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_39()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_39")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, CStr (Nothing))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_40()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_40")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(CObj(1), CObj (Nothing))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Binary_41()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Binary_41")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			FilePutObject(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_1'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_1?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_1?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, True)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_2'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_2?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_2?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, False)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_3'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_3?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_3?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, " "c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_4'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_4?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_4?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, "￿"c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_5'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_5?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_5?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, SByte.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_6'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_6?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_6?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, SByte.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_7'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_7?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_7?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Input_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, CByte (0))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_8'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_8?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_8?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, CByte (255))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_9'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_9?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_9?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Int16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_10'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_10?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_10?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Int16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_11'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_11?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_11?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, UInt16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_12'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_12?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_12?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, UInt16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_13'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_13?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_13?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Input_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Int32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_14'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_14?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_14?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Int32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_15'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_15?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_15?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, UInt32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_16'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_16?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_16?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, UInt32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_17'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_17?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_17?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Input_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Int64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_18'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_18?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_18?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Int64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_19'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_19?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_19?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, UInt64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_20'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_20?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_20?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Input_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, UInt64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_21'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_21?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_21?.>")
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Input_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Single.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_22'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_22?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_22?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Single.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_23'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_23?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_23?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Single.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_24'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_24?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_24?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Single.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_25'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_25?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_25?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Single.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_26'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_26?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_26?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Single.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_27'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_27?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_27?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Double.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_28'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_28?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_28?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Double.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_29'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_29?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_29?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Double.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_30'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_30?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_30?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Double.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_31'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_31?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_31?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Double.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_32'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_32?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_32?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, Double.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_33'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_33?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_33?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_34()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_34")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_34'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_34?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_34?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_35()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_35")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_35'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_35?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_35?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_36()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_36")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, DateTime.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_36'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_36?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_36?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_37()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_37")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, DateTime.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_37'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_37?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_37?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_38()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_38")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, "")
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_38'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_38?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_38?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_39()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_39")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, CStr (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_39'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_39?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_39?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_40()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_40")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_40'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_40?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_40?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Input_41()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Input_41")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			FilePutObject(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\FilePutObjectTest_Input_41'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*FilePutObjectTest_Input_41?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*FilePutObjectTest_Input_41?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, System.DBNull.Value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, True)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, False)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, " "c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, "￿"c)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, SByte.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, SByte.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Output_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, CByte (0))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, CByte (255))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Int16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Int16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, UInt16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, UInt16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Output_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Int32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Int32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, UInt32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, UInt32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Output_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Int64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Int64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, UInt64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Output_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, UInt64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Output_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Single.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Single.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Single.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Single.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Single.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Single.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Double.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Double.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Double.Epsilon)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Double.NaN)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Double.NegativeInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, Double.PositiveInfinity)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_34()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_34")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, -79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_35()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_35")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, 79228162514264337593543950335D)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_36()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_36")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, DateTime.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_37()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_37")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, DateTime.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_38()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_38")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, "")
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_39()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_39")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, CStr (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_40()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_40")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(CObj(1), CObj (Nothing))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Output_41()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Output_41")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			FilePutObject(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, System.DBNull.Value)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 1, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, True)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 11, 0, 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, False)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 11, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_4")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, " "c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 18, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_5")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, "￿"c)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 18, 0, 63 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_6()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_6")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, SByte.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'SByte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'SByte' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_7()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_7")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, SByte.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'SByte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'SByte' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Random_8()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_8")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, CByte (0))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 17, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_9()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_9")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, CByte (255))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 17, 0, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_10()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_10")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Int16.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 2, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_11()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_11")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Int16.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 2, 0, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_12()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_12")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, UInt16.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UShort' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UShort' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_13()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_13")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, UInt16.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UShort' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UShort' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Random_14()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_14")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Int32.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 3, 0, 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_15()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_15")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Int32.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 3, 0, 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_16()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_16")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, UInt32.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UInteger' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UInteger' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_17()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_17")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, UInt32.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'UInteger' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'UInteger' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Random_18()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_18")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Int64.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_19()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_19")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Int64.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 20, 0, 255, 255, 255, 255, 255, 255, 255, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_20()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_20")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, UInt64.MinValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'ULong' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'ULong' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
#If NET_VER >= 2.0 Then
	<Test ()> _
	Sub FilePutObjectTest_Random_21()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_21")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, UInt64.MaxValue)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException (''FilePutObject' of structure 'ULong' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("'FilePutObject' of structure 'ULong' is not valid.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
#End If
	<Test ()> _
	Sub FilePutObjectTest_Random_22()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_22")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Single.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 255, 255, 127, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_23()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_23")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Single.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 255, 255, 127, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_24()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_24")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Single.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 1, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_25()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_25")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Single.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 0, 0, 192, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_26()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_26")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Single.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 0, 0, 128, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_27()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_27")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Single.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 4, 0, 0, 0, 128, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_28()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_28")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Double.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 255, 255, 255, 255, 255, 255, 239, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_29()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_29")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Double.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 255, 255, 255, 255, 255, 255, 239, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_30()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_30")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Double.Epsilon)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 1, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_31()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_31")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Double.NaN)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 0, 0, 0, 0, 0, 0, 248, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_32()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_32")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Double.NegativeInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 0, 0, 0, 0, 0, 0, 240, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_33()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_33")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, Double.PositiveInfinity)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 5, 0, 0, 0, 0, 0, 0, 0, 240, 127 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_34()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_34")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, -79228162514264337593543950335D)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 14, 0, 14, 0, 0, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_35()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_35")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, 79228162514264337593543950335D)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 14, 0, 14, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_36()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_36")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, DateTime.MinValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 7, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_37()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_37")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, DateTime.MaxValue)
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 7, 0, 231, 255, 255, 255, 64, 146, 70, 65 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_38()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_38")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, "")
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 8, 0, 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_39()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_39")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, CStr (Nothing))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_40()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_40")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(CObj(1), CObj (Nothing))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FilePutObjectTest_Random_41()
		Dim filename As String = Path.Combine (DATA_DIR, "FilePutObjectTest_Random_41")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			FilePutObject(1, CType (Nothing, System.ValueType))
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 0, 0 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Append_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			Print(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Append_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Append_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			Print(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Append_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Append_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			Print(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Binary_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Binary_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			Print(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Binary_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			Print(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Binary_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Binary_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			Print(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Input_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Input_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			Print(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\PrintTest_Input_1'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*PrintTest_Input_1?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*PrintTest_Input_1?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Input_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Input_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			Print(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\PrintTest_Input_2'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*PrintTest_Input_2?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*PrintTest_Input_2?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Input_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			Print(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\PrintTest_Input_3'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*PrintTest_Input_3?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*PrintTest_Input_3?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Output_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Output_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			Print(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Output_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Output_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			Print(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Output_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Output_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			Print(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () {  }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Random_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Random_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			Print(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Random_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Random_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			Print(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintTest_Random_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintTest_Random_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			Print(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Append_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			PrintLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Append_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Append_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			PrintLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Append_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Append_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			PrintLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Binary_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Binary_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			PrintLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Binary_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			PrintLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Binary_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Binary_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			PrintLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Input_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Input_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			PrintLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\PrintLineTest_Input_1'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*PrintLineTest_Input_1?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*PrintLineTest_Input_1?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Input_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Input_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			PrintLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\PrintLineTest_Input_2'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*PrintLineTest_Input_2?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*PrintLineTest_Input_2?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Input_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			PrintLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\PrintLineTest_Input_3'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*PrintLineTest_Input_3?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*PrintLineTest_Input_3?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Output_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Output_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			PrintLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Output_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Output_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			PrintLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Output_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Output_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			PrintLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Random_1()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Random_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			PrintLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Random_2()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Random_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			PrintLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub PrintLineTest_Random_3()
		Dim filename As String = Path.Combine (DATA_DIR, "PrintLineTest_Random_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			PrintLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Append_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			Write(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 44 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Append_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Append_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			Write(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 44 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Append_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Append_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			Write(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 44 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Binary_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Binary_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			Write(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Binary_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			Write(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Binary_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Binary_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			Write(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Input_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Input_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			Write(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\WriteTest_Input_1'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*WriteTest_Input_1?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*WriteTest_Input_1?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Input_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Input_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			Write(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\WriteTest_Input_2'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*WriteTest_Input_2?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*WriteTest_Input_2?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Input_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			Write(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\WriteTest_Input_3'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*WriteTest_Input_3?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*WriteTest_Input_3?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Output_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Output_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			Write(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 44 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Output_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Output_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			Write(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 44 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Output_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Output_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			Write(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 44 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Random_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Random_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			Write(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Random_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Random_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			Write(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteTest_Random_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteTest_Random_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			Write(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Append_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			WriteLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Append_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Append_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			WriteLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Append_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Append_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Append)
			WriteLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Binary_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Binary_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			WriteLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Binary_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			WriteLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Binary_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Binary_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Binary)
			WriteLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Input_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Input_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			WriteLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\WriteLineTest_Input_1'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*WriteLineTest_Input_1?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*WriteLineTest_Input_1?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Input_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Input_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			WriteLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\WriteLineTest_Input_2'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*WriteLineTest_Input_2?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*WriteLineTest_Input_2?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Input_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Input)
			WriteLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.FileNotFoundException ('Could not find file '<DATA_DIR>\WriteLineTest_Input_3'.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.FileNotFoundException", ex.GetType.FullName, filename)
			Assert.IsTrue (ex.Message Like "Could not find file ?*WriteLineTest_Input_3?.", filename & " - <" & ex.Message & "> didn't match <Could not find file ?*WriteLineTest_Input_3?.>")
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Output_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Output_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			WriteLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Output_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Output_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			WriteLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Output_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Output_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Output)
			WriteLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Helper.CompareBytes (Helper.ReadAllBytes (filename), new Byte () { 35, 69, 82, 82, 79, 82, 32, 52, 52, 56, 35, 13, 10 }, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Random_1()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Random_1")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			WriteLine(1, New Object () {CStr (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Random_2()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Random_2")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			WriteLine(1, New Object () {CObj (Nothing)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub WriteLineTest_Random_3()
		Dim filename As String = Path.Combine (DATA_DIR, "WriteLineTest_Random_3")
		Try
			Initialize()
			FileOpen(1, filename, OpenMode.Random)
			WriteLine(1, New Object () {CType (Nothing, System.ValueType)})
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_0_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_0_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_0_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_0_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_0_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_0_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_0_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_0_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_0_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_0_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_0_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_0_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 2)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_0_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_0_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 2)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_0_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_0_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 2)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_0_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_0_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 2)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_0_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_0_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 2)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (True, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (True, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(255), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(255), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(-1), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(-1), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿ"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿ"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentOutOfRangeException ('Non-negative number required." & vbNewLine & "Parameter name: count')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentOutOfRangeException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Non-negative number required." & vbNewLine & "Parameter name: count", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_0_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_0_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_0_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_0_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_0_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_0_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.Exception ('Variable uses an Automation type not supported in Visual Basic.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.Exception", ex.GetType.FullName, filename)
			Assert.AreEqual ("Variable uses an Automation type not supported in Visual Basic.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_0_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_0_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_0_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_0_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_0_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_0_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.Exception ('Variable uses an Automation type not supported in Visual Basic.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.Exception", ex.GetType.FullName, filename)
			Assert.AreEqual ("Variable uses an Automation type not supported in Visual Basic.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿ"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿ"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("ÿÿ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""ÿÿ"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""ÿÿ"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""ÿÿ"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_0_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_0_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 255, 255 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_1_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_1_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_1_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_1_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual (" ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_1_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_1_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual (" ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_1_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_1_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_1_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_1_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_1_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_1_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 1)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_1_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_1_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 1)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_1_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_1_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 1)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_1_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_1_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 1)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_1_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_1_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_1_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_1_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_1_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_1_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_1_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_1_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_1_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_1_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_1_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_1_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_1_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_1_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IndexOutOfRangeException ('Index was outside the bounds of the array.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IndexOutOfRangeException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Index was outside the bounds of the array.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IndexOutOfRangeException ('Index was outside the bounds of the array.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IndexOutOfRangeException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Index was outside the bounds of the array.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_1_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_1_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_2_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_2_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_2_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_2_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("   €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_2_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_2_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("   €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_2_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_2_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_2_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_2_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_2_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_2_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 4)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_2_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_2_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 4)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_2_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_2_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 4)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_2_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_2_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 4)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_2_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_2_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 4)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (False, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (False, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Integer.MinValue, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Integer.MinValue, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CSng(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CSng(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_2_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_2_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_2_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_2_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_2_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_2_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_2_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_2_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_2_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_2_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_2_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_2_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_2_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_2_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_3_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_3_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_3_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_3_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("       €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_3_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_3_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("       €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_3_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_3_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_3_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_3_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_3_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_3_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 8)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_3_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_3_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 8)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_3_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_3_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 8)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_3_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_3_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 8)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_3_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_3_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 8)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (False, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (False, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CInt(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CInt(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Long.MinValue, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Long.MinValue, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CSng(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CSng(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CDbl(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CDbl(0), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (-922337203685477.5808D, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (-922337203685477.5808D, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (#12/30/1899 12:00:00 AM#, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_3_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_3_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (#12/30/1899 12:00:00 AM#, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_3_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_3_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_3_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_3_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_3_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_3_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_3_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_3_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_3_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_3_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€"c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_3_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_3_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_4_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_4_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_4_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_4_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_4_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_4_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_4_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_4_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_4_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_4_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_4_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_4_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 0)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_4_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_4_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 0)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_4_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_4_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 0)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_4_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_4_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 0)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_4_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_4_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 0)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_4_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_4_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_4_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_4_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_4_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_4_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_4_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_4_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_4_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_4_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_4_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_4_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Input past end of file.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Input past end of file.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_4_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_4_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () {  })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_5_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_5_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_5_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_5_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("  ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_5_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_5_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("  ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_5_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_5_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_5_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_5_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_5_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_5_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 3)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_5_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_5_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 3)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_5_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_5_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 3)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_5_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_5_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 3)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_5_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_5_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 3)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (True, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (True, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(18), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(18), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(18), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(18), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (" ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_5_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_5_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_5_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_5_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_5_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_5_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_5_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_5_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_5_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_5_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_5_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_5_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (" "c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string """" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string """" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string """" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_5_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_5_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 18, 0, 0 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_6_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_6_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_6_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_6_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("    €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_6_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_6_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("    €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_6_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_6_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_6_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_6_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_6_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_6_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 6)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_6_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_6_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 6)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_6_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_6_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 6)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_6_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_6_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 6)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_6_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_6_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 6)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (True, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (True, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(3), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CByte(3), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(3), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CShort(3), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CInt(3), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CInt(3), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CSng(4.203895E-45), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (CSng(4.203895E-45), value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual (Nothing, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.AreEqual ("   ", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_6_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_6_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.EndOfStreamException ('Unable to read beyond the end of the stream.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.EndOfStreamException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Unable to read beyond the end of the stream.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_6_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_6_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_6_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_6_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (Integer.MinValue, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_6_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_6_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_6_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_6_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGetObject(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetObjectTest_6_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetObjectTest_6_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGetObject(1, value)
			FileClose(1)
			Assert.AreEqual (Integer.MinValue, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Object_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Object_Append_1")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Object_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Object_Binary_2")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Object_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Object_Input_3")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Object_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Object_Output_4")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Object_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Object_Random_5")
		Try
			Dim value As System.Object = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Boolean_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Boolean_Append_1")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Boolean_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Boolean_Binary_2")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Boolean_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Boolean_Input_3")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Boolean' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Boolean' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Boolean_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Boolean_Output_4")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Boolean_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Boolean_Random_5")
		Try
			Dim value As System.Boolean = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Byte_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Byte_Append_1")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Byte_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Byte_Binary_2")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Byte_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Byte_Input_3")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Byte' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Byte' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Byte_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Byte_Output_4")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Byte_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Byte_Random_5")
		Try
			Dim value As System.Byte = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int16_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int16_Append_1")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int16_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int16_Binary_2")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int16_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int16_Input_3")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Short' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Short' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int16_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int16_Output_4")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int16_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int16_Random_5")
		Try
			Dim value As System.Int16 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int32_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int32_Append_1")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int32_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int32_Binary_2")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int32_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int32_Input_3")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Integer' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Integer' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int32_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int32_Output_4")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int32_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int32_Random_5")
		Try
			Dim value As System.Int32 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int64_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int64_Append_1")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int64_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int64_Binary_2")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int64_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int64_Input_3")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Long' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Long' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int64_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int64_Output_4")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Int64_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Int64_Random_5")
		Try
			Dim value As System.Int64 = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Char_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Char_Append_1")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Char_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Char_Binary_2")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Char_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Char_Input_3")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual (""c, value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Char_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Char_Output_4")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Char_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Char_Random_5")
		Try
			Dim value As System.Char = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Single_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Single_Append_1")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Single_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Single_Binary_2")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Single_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Single_Input_3")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Single' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Single' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Single_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Single_Output_4")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Single_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Single_Random_5")
		Try
			Dim value As System.Single = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Double_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Double_Append_1")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Double_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Double_Binary_2")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Double_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Double_Input_3")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Double' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Double' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Double_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Double_Output_4")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Double_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Double_Random_5")
		Try
			Dim value As System.Double = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Decimal_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Decimal_Append_1")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Decimal_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Decimal_Binary_2")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Decimal_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Decimal_Input_3")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Decimal' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Decimal' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Decimal_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Decimal_Output_4")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_Decimal_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_Decimal_Random_5")
		Try
			Dim value As System.Decimal = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_String_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_String_Append_1")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_String_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_String_Binary_2")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_String_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_String_Input_3")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_String_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_String_Output_4")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_String_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_String_Random_5")
		Try
			Dim value As System.String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_DateTime_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_DateTime_Append_1")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_DateTime_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_DateTime_Binary_2")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_DateTime_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_DateTime_Input_3")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.InvalidCastException ('Conversion from string ""€"" to type 'Date' is not valid.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.InvalidCastException", ex.GetType.FullName, filename)
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Conversion from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#Else
			Assert.AreEqual ("Cast from string ""€"" to type 'Date' is not valid.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_DateTime_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_DateTime_Output_4")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputTest_6_DateTime_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputTest_6_DateTime_Random_5")
		Try
			Dim value As System.DateTime = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 3, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			Input(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_7_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_7_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_7_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_7_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("        €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_7_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_7_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = LineInput(1)
			FileClose(1)
			Assert.AreEqual ("        €", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_7_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_7_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub LineInputTest_7_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "LineInputTest_7_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = LineInput(1)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_7_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_7_Append_1")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			value = InputString(1, 10)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_7_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_7_Binary_2")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			value = InputString(1, 10)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_7_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_7_Input_3")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			value = InputString(1, 10)
			FileClose(1)
			Assert.AreEqual ("€", value, filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.Fail ("Did not expect any exception, got " & ex.GetType.FullName & " (" & ex.Message, filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_7_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_7_Output_4")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			value = InputString(1, 10)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
#Else
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
#End If
#If NET_VER >= 2.0 Then
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message, filename)
#Else
			Assert.AreEqual ("Bad file mode.", ex.Message, filename)
#End If
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub InputStringTest_7_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "InputStringTest_7_Random_5")
		Try
			Dim value As String = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			value = InputString(1, 10)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_ValueType_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_ValueType_Append_1")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_ValueType_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_ValueType_Binary_2")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_ValueType_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_ValueType_Input_3")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_ValueType_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_ValueType_Output_4")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_ValueType_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_ValueType_Random_5")
		Try
			Dim value As System.ValueType = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.NullReferenceException ('Object reference not set to an instance of an object.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.NullReferenceException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Object reference not set to an instance of an object.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_Array_Append_1()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_Array_Append_1")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Append)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_Array_Binary_2()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_Array_Binary_2")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Binary)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.ArgumentException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Cannot determine array type because it is Nothing.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_Array_Input_3()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_Array_Input_3")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Input)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_Array_Output_4()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_Array_Output_4")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Output)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.IO.IOException ('Bad file mode.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
		Catch ex As Exception
			Assert.AreEqual ("System.IO.IOException", ex.GetType.FullName, filename)
			Assert.AreEqual ("Bad file mode.", ex.Message.Replace ("Acess", "Access"), filename)
		Finally
			CleanUp()
		End Try
	End Sub
	<Test ()> _
	Sub FileGetTest_7_Array_Random_5()
		Dim filename As String = Path.Combine (DATA_DIR, "FileGetTest_7_Array_Random_5")
		Try
			Dim value As System.Array = Nothing
			Initialize()
			Helper.WriteAllBytes (filename, new Byte () { 20, 0, 0, 0, 0, 0, 0, 0, 0, 128 })
			FileOpen(1, filename, OpenMode.Random)
			FileGet(1, value)
			FileClose(1)
			Assert.Fail ("Expected System.ArgumentException ('Cannot determine array type because it is Nothing.')", filename)
		Catch ex as NUnit.Framework.AssertionException
			Throw
