/* SerialConnection.c generated by valac 0.13.3.34-3eeb2-dirty, the Vala compiler
 * generated from SerialConnection.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/ioctl.h>
#include <glib/gi18n-lib.h>


#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;

#define MOSERIAL_SERIAL_CONNECTION_TYPE_LINE_END (moserial_serial_connection_line_end_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	gchar* echoReference;
	gchar* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

struct _moserialSerialConnectionPrivate {
	gboolean connected;
	struct termios newtio;
	struct termios restoretio;
	gint m_fd;
	GIOChannel* IOChannelFd;
	gint flags;
	guint* sourceId;
	gboolean localEcho;
};

typedef enum  {
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CR,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_LF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE
} moserialSerialConnectionLineEnd;

typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;


static gpointer moserial_serial_connection_parent_class = NULL;

GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionPrivate))
enum  {
	MOSERIAL_SERIAL_CONNECTION_DUMMY_PROPERTY
};
GType moserial_serial_connection_line_end_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings);
GType settings_access_mode_get_type (void) G_GNUC_CONST;
SettingsAccessMode settings_get_accessMode (Settings* self);
const gchar* settings_get_device (Settings* self);
static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings);
static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition);
static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static guint* _uint_dup (guint* self);
gboolean settings_get_localEcho (Settings* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
gint settings_get_baudRate (Settings* self);
gint settings_get_dataBits (Settings* self);
GType settings_parity_get_type (void) G_GNUC_CONST;
SettingsParity settings_get_parity (Settings* self);
gint settings_get_stopBits (Settings* self);
GType settings_handshake_get_type (void) G_GNUC_CONST;
SettingsHandshake settings_get_handshake (Settings* self);
gchar* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
moserialSerialConnection* moserial_serial_connection_new (void);
moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void moserial_serial_connection_finalize (GObject* obj);

const gchar* MOSERIAL_SERIAL_CONNECTION_LineEndStrings[6] = {"CR+LF end", "CR end", "LF end", "TAB end", "ESC end", "No end"};
const gchar* MOSERIAL_SERIAL_CONNECTION_LineEndValues[6] = {"\r\n", "\r", "\n", "\t", "\x1b", ""};

GType moserial_serial_connection_line_end_get_type (void) {
	static volatile gsize moserial_serial_connection_line_end_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_connection_line_end_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF", "crlf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_CR, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CR", "cr"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_LF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_LF", "lf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB, "MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB", "tab"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC, "MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC", "esc"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE, "MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE", "none"}, {0, NULL, NULL}};
		GType moserial_serial_connection_line_end_type_id;
		moserial_serial_connection_line_end_type_id = g_enum_register_static ("moserialSerialConnectionLineEnd", values);
		g_once_init_leave (&moserial_serial_connection_line_end_type_id__volatile, moserial_serial_connection_line_end_type_id);
	}
	return moserial_serial_connection_line_end_type_id__volatile;
}


static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_serial_connection_readBytes (self, source, condition);
	return result;
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer __uint_dup0 (gpointer self) {
	return self ? _uint_dup (self) : NULL;
}


gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self, Settings* settings) {
	gboolean result = FALSE;
	Settings* _tmp0_;
	SettingsAccessMode _tmp1_;
	SettingsAccessMode _tmp2_;
	Settings* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	struct termios _tmp14_;
	Settings* _tmp15_;
	gint _tmp16_;
	struct termios _tmp17_;
	gint _tmp18_;
	GIOChannel* _tmp19_;
	GIOChannel* _tmp20_;
	guint _tmp21_ = 0U;
	guint* _tmp22_;
	Settings* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = settings;
	_tmp1_ = settings_get_accessMode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == SETTINGS_ACCESS_MODE_READWRITE) {
		self->priv->flags = O_RDWR;
	} else {
		Settings* _tmp3_;
		SettingsAccessMode _tmp4_;
		SettingsAccessMode _tmp5_;
		_tmp3_ = settings;
		_tmp4_ = settings_get_accessMode (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == SETTINGS_ACCESS_MODE_READONLY) {
			self->priv->flags = O_RDONLY;
		} else {
			self->priv->flags = O_WRONLY;
		}
	}
	_tmp6_ = settings;
	_tmp7_ = settings_get_device (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->flags;
	_tmp10_ = open (_tmp8_, _tmp9_ | O_NONBLOCK, (mode_t) 0);
	self->priv->m_fd = _tmp10_;
	_tmp11_ = self->priv->m_fd;
	if (_tmp11_ < 0) {
		self->priv->m_fd = -1;
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->m_fd;
	tcflush (_tmp12_, TCIOFLUSH);
	_tmp13_ = self->priv->m_fd;
	_tmp14_ = self->priv->restoretio;
	tcgetattr (_tmp13_, &_tmp14_);
	_tmp15_ = settings;
	moserial_serial_connection_applySettings (self, _tmp15_);
	_tmp16_ = self->priv->m_fd;
	_tmp17_ = self->priv->newtio;
	tcsetattr (_tmp16_, TCSANOW, &_tmp17_);
	self->priv->connected = TRUE;
	_tmp18_ = self->priv->m_fd;
	_tmp19_ = g_io_channel_unix_new (_tmp18_);
	_g_io_channel_unref0 (self->priv->IOChannelFd);
	self->priv->IOChannelFd = _tmp19_;
	_tmp20_ = self->priv->IOChannelFd;
	_tmp21_ = g_io_add_watch (_tmp20_, G_IO_IN, _moserial_serial_connection_readBytes_gio_func, self);
	_tmp22_ = __uint_dup0 (&_tmp21_);
	_g_free0 (self->priv->sourceId);
	self->priv->sourceId = _tmp22_;
	_tmp23_ = settings;
	_tmp24_ = settings_get_localEcho (_tmp23_);
	_tmp25_ = _tmp24_;
	self->priv->localEcho = _tmp25_;
	result = TRUE;
	return result;
}


void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		guchar* _tmp1_ = NULL;
		guchar* b;
		gint b_length1;
		gint _b_size_;
		guchar* _tmp2_;
		gint _tmp2__length1;
		guchar _tmp3_;
		guchar _tmp4_;
		gint _tmp5_;
		guchar* _tmp6_;
		gint _tmp6__length1;
		gssize _tmp7_ = 0L;
		gsize x;
		gulong _tmp8_;
		gsize _tmp9_;
		_tmp1_ = g_new0 (guchar, 1);
		b = _tmp1_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp2_ = b;
		_tmp2__length1 = b_length1;
		_tmp3_ = byte;
		_tmp2_[0] = _tmp3_;
		_tmp4_ = _tmp2_[0];
		_tmp5_ = self->priv->m_fd;
		_tmp6_ = b;
		_tmp6__length1 = b_length1;
		_tmp7_ = write (_tmp5_, _tmp6_, (gsize) 1);
		x = (gsize) _tmp7_;
		_tmp8_ = self->tx;
		_tmp9_ = x;
		self->tx = _tmp8_ + _tmp9_;
		b = (g_free (b), NULL);
	}
}


void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		gint _tmp1_;
		gchar* _tmp2_;
		gint _tmp2__length1;
		gsize _tmp3_;
		gssize _tmp4_ = 0L;
		gsize x;
		gint _tmp5_;
		gulong _tmp6_;
		gsize _tmp7_;
		_tmp1_ = self->priv->m_fd;
		_tmp2_ = bytes;
		_tmp2__length1 = bytes_length1;
		_tmp3_ = size;
		_tmp4_ = write (_tmp1_, _tmp2_, _tmp3_);
		x = (gsize) _tmp4_;
		_tmp5_ = self->priv->m_fd;
		tcdrain (_tmp5_);
		_tmp6_ = self->tx;
		_tmp7_ = x;
		self->tx = _tmp6_ + _tmp7_;
	}
}


void moserial_serial_connection_doDisconnect (moserialSerialConnection* self) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		guint* _tmp1_;
		gulong _tmp5_;
		gulong _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gint _tmp9_;
		struct termios _tmp10_;
		gint _tmp11_;
		_tmp1_ = self->priv->sourceId;
		g_source_remove (*_tmp1_);
		_g_free0 (self->priv->sourceId);
		self->priv->sourceId = NULL;
		{
			GIOChannel* _tmp2_;
			_tmp2_ = self->priv->IOChannelFd;
			g_io_channel_shutdown (_tmp2_, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch8_g_io_channel_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally8;
		__catch8_g_io_channel_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("SerialConnection.vala:115: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_io_channel_unref0 (self->priv->IOChannelFd);
		self->priv->IOChannelFd = NULL;
		self->priv->connected = FALSE;
		self->forced_hex_view = FALSE;
		self->lastRxCharWasCR = FALSE;
		self->nonprintable = (gulong) 0;
		_tmp5_ = self->nonprintable;
		self->rx = _tmp5_;
		_tmp6_ = self->rx;
		self->tx = _tmp6_;
		_tmp7_ = g_strdup ("");
		_g_free0 (self->echoReference);
		self->echoReference = _tmp7_;
		_tmp8_ = g_strdup ("");
		_g_free0 (self->echoCompare);
		self->echoCompare = _tmp8_;
		_tmp9_ = self->priv->m_fd;
		_tmp10_ = self->priv->newtio;
		tcsetattr (_tmp9_, TCSANOW, &_tmp10_);
		_tmp11_ = self->priv->m_fd;
		close (_tmp11_);
	}
}


static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	guchar* _tmp0_ = NULL;
	guchar* m_buf;
	gint m_buf_length1;
	gint _m_buf_size_;
	gint _tmp1_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	gssize _tmp3_ = 0L;
	gint bytesRead;
	gulong _tmp4_;
	gint _tmp5_;
	gint _tmp10_;
	guchar* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_new0 (guchar, 128);
	m_buf = _tmp0_;
	m_buf_length1 = 128;
	_m_buf_size_ = m_buf_length1;
	_tmp1_ = self->priv->m_fd;
	_tmp2_ = m_buf;
	_tmp2__length1 = m_buf_length1;
	_tmp3_ = read (_tmp1_, _tmp2_, (gsize) 128);
	bytesRead = (gint) _tmp3_;
	_tmp4_ = self->rx;
	_tmp5_ = bytesRead;
	self->rx = _tmp4_ + ((gulong) _tmp5_);
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp9_;
		_tmp7_ = gtk_events_pending ();
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = gdk_events_pending ();
			_tmp6_ = _tmp8_;
		}
		_tmp9_ = _tmp6_;
		if (!_tmp9_) {
			break;
		}
		gtk_main_iteration_do (TRUE);
	}
	_tmp10_ = bytesRead;
	if (_tmp10_ < 0) {
		result = FALSE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	}
	_tmp11_ = m_buf;
	_tmp11__length1 = m_buf_length1;
	_tmp12_ = bytesRead;
	g_signal_emit_by_name (self, "new-data", _tmp11_, _tmp11__length1, _tmp12_);
	_tmp13_ = self->priv->localEcho;
	if (_tmp13_) {
		guchar* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		_tmp14_ = m_buf;
		_tmp14__length1 = m_buf_length1;
		_tmp15_ = bytesRead;
		moserial_serial_connection_sendBytes (self, (gchar*) _tmp14_, _tmp14__length1, (gsize) _tmp15_);
	}
	_tmp16_ = self->priv->connected;
	result = _tmp16_;
	m_buf = (g_free (m_buf), NULL);
	return result;
}


static void moserial_serial_connection_applySettings (moserialSerialConnection* self, Settings* settings) {
	guint baudRate;
	Settings* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	struct termios _tmp3_;
	guint _tmp4_;
	struct termios _tmp5_;
	guint _tmp6_;
	gint dataBits = 0;
	Settings* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	Settings* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp22_;
	gint _tmp23_;
	tcflag_t _tmp32_;
	tcflag_t _tmp33_;
	Settings* _tmp34_;
	SettingsParity _tmp35_;
	SettingsParity _tmp36_;
	tcflag_t _tmp42_;
	Settings* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gboolean _tmp48_ = FALSE;
	Settings* _tmp49_;
	SettingsHandshake _tmp50_;
	SettingsHandshake _tmp51_;
	gboolean _tmp55_;
	struct termios _tmp58_;
	cc_t _tmp59_;
	struct termios _tmp60_;
	cc_t _tmp61_;
	tcflag_t _tmp62_;
	gint mcs;
	gint _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gboolean _tmp66_ = FALSE;
	Settings* _tmp67_;
	SettingsHandshake _tmp68_;
	SettingsHandshake _tmp69_;
	gboolean _tmp73_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	baudRate = (guint) 0;
	_tmp0_ = settings;
	_tmp1_ = settings_get_baudRate (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case 300:
		{
			baudRate = (guint) B300;
			break;
		}
		case 600:
		{
			baudRate = (guint) B600;
			break;
		}
		case 1200:
		{
			baudRate = (guint) B1200;
			break;
		}
		case 2400:
		{
			baudRate = (guint) B2400;
			break;
		}
		case 4800:
		{
			baudRate = (guint) B4800;
			break;
		}
		case 9600:
		{
			baudRate = (guint) B9600;
			break;
		}
		case 19200:
		{
			baudRate = (guint) B19200;
			break;
		}
		case 38400:
		{
			baudRate = (guint) B38400;
			break;
		}
		case 57600:
		{
			baudRate = (guint) B57600;
			break;
		}
		case 115200:
		{
			baudRate = (guint) B115200;
			break;
		}
		case 230400:
		{
			baudRate = (guint) B230400;
			break;
		}
		case 460800:
		{
			baudRate = (guint) B460800;
			break;
		}
		case 576000:
		{
			baudRate = (guint) B576000;
			break;
		}
		case 921600:
		{
			baudRate = (guint) B921600;
			break;
		}
		case 1000000:
		{
			baudRate = (guint) B1000000;
			break;
		}
		case 2000000:
		{
			baudRate = (guint) B2000000;
			break;
		}
		default:
		break;
	}
	_tmp3_ = self->priv->newtio;
	_tmp4_ = baudRate;
	cfsetospeed (&_tmp3_, (speed_t) _tmp4_);
	_tmp5_ = self->priv->newtio;
	_tmp6_ = baudRate;
	cfsetispeed (&_tmp5_, (speed_t) _tmp6_);
	_tmp7_ = settings;
	_tmp8_ = settings_get_dataBits (_tmp7_);
	_tmp9_ = _tmp8_;
	dataBits = _tmp9_;
	_tmp11_ = settings;
	_tmp12_ = settings_get_dataBits (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == 7) {
		gboolean _tmp14_ = FALSE;
		Settings* _tmp15_;
		SettingsParity _tmp16_;
		SettingsParity _tmp17_;
		gboolean _tmp21_;
		_tmp15_ = settings;
		_tmp16_ = settings_get_parity (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == SETTINGS_PARITY_MARK) {
			_tmp14_ = TRUE;
		} else {
			Settings* _tmp18_;
			SettingsParity _tmp19_;
			SettingsParity _tmp20_;
			_tmp18_ = settings;
			_tmp19_ = settings_get_parity (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp14_ = _tmp20_ == SETTINGS_PARITY_SPACE;
		}
		_tmp21_ = _tmp14_;
		_tmp10_ = _tmp21_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp22_ = _tmp10_;
	if (_tmp22_) {
		dataBits = 8;
	}
	_tmp23_ = dataBits;
	switch (_tmp23_) {
		case 5:
		{
			struct termios _tmp24_;
			tcflag_t _tmp25_;
			_tmp24_ = self->priv->newtio;
			_tmp25_ = _tmp24_.c_cflag;
			self->priv->newtio.c_cflag = (_tmp25_ & (~CSIZE)) | CS5;
			break;
		}
		case 6:
		{
			struct termios _tmp26_;
			tcflag_t _tmp27_;
			_tmp26_ = self->priv->newtio;
			_tmp27_ = _tmp26_.c_cflag;
			self->priv->newtio.c_cflag = (_tmp27_ & (~CSIZE)) | CS6;
			break;
		}
		case 7:
		{
			struct termios _tmp28_;
			tcflag_t _tmp29_;
			_tmp28_ = self->priv->newtio;
			_tmp29_ = _tmp28_.c_cflag;
			self->priv->newtio.c_cflag = (_tmp29_ & (~CSIZE)) | CS7;
			break;
		}
		default:
		case 8:
		{
			struct termios _tmp30_;
			tcflag_t _tmp31_;
			_tmp30_ = self->priv->newtio;
			_tmp31_ = _tmp30_.c_cflag;
			self->priv->newtio.c_cflag = (_tmp31_ & (~CSIZE)) | CS8;
			break;
		}
	}
	_tmp32_ = self->priv->newtio.c_cflag;
	self->priv->newtio.c_cflag = _tmp32_ | (CLOCAL | CREAD);
	_tmp33_ = self->priv->newtio.c_cflag;
	self->priv->newtio.c_cflag = _tmp33_ & (~(PARENB | PARODD));
	_tmp34_ = settings;
	_tmp35_ = settings_get_parity (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp36_ == SETTINGS_PARITY_EVEN) {
		tcflag_t _tmp37_;
		_tmp37_ = self->priv->newtio.c_cflag;
		self->priv->newtio.c_cflag = _tmp37_ | PARENB;
	} else {
		Settings* _tmp38_;
		SettingsParity _tmp39_;
		SettingsParity _tmp40_;
		_tmp38_ = settings;
		_tmp39_ = settings_get_parity (_tmp38_);
		_tmp40_ = _tmp39_;
		if (_tmp40_ == SETTINGS_PARITY_ODD) {
			tcflag_t _tmp41_;
			_tmp41_ = self->priv->newtio.c_cflag;
			self->priv->newtio.c_cflag = _tmp41_ | (PARENB | PARODD);
		}
	}
	_tmp42_ = self->priv->newtio.c_cflag;
	self->priv->newtio.c_cflag = _tmp42_ & (~CRTSCTS);
	_tmp43_ = settings;
	_tmp44_ = settings_get_stopBits (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_ == 2) {
		tcflag_t _tmp46_;
		_tmp46_ = self->priv->newtio.c_cflag;
		self->priv->newtio.c_cflag = _tmp46_ | CSTOPB;
	} else {
		tcflag_t _tmp47_;
		_tmp47_ = self->priv->newtio.c_cflag;
		self->priv->newtio.c_cflag = _tmp47_ & (~CSTOPB);
	}
	self->priv->newtio.c_iflag = IGNBRK;
	_tmp49_ = settings;
	_tmp50_ = settings_get_handshake (_tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ == SETTINGS_HANDSHAKE_SOFTWARE) {
		_tmp48_ = TRUE;
	} else {
		Settings* _tmp52_;
		SettingsHandshake _tmp53_;
		SettingsHandshake _tmp54_;
		_tmp52_ = settings;
		_tmp53_ = settings_get_handshake (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp48_ = _tmp54_ == SETTINGS_HANDSHAKE_BOTH;
	}
	_tmp55_ = _tmp48_;
	if (_tmp55_) {
		tcflag_t _tmp56_;
		_tmp56_ = self->priv->newtio.c_iflag;
		self->priv->newtio.c_iflag = _tmp56_ | (IXON | IXOFF);
	} else {
		tcflag_t _tmp57_;
		_tmp57_ = self->priv->newtio.c_iflag;
		self->priv->newtio.c_iflag = _tmp57_ & (~((IXON | IXOFF) | IXANY));
	}
	self->priv->newtio.c_lflag = (tcflag_t) 0;
	self->priv->newtio.c_oflag = (tcflag_t) 0;
	_tmp58_ = self->priv->newtio;
	_tmp58_.c_cc[VTIME] = (cc_t) 1;
	_tmp59_ = _tmp58_.c_cc[VTIME];
	_tmp60_ = self->priv->newtio;
	_tmp60_.c_cc[VMIN] = (cc_t) 1;
	_tmp61_ = _tmp60_.c_cc[VMIN];
	_tmp62_ = self->priv->newtio.c_lflag;
	self->priv->newtio.c_lflag = _tmp62_ & (~(ECHONL | NOFLSH));
	mcs = 0;
	_tmp63_ = self->priv->m_fd;
	ioctl (_tmp63_, TIOCMGET, &mcs);
	_tmp64_ = mcs;
	mcs = _tmp64_ | TIOCM_RTS;
	_tmp65_ = self->priv->m_fd;
	ioctl (_tmp65_, TIOCMSET, &mcs);
	_tmp67_ = settings;
	_tmp68_ = settings_get_handshake (_tmp67_);
	_tmp69_ = _tmp68_;
	if (_tmp69_ == SETTINGS_HANDSHAKE_HARDWARE) {
		_tmp66_ = TRUE;
	} else {
		Settings* _tmp70_;
		SettingsHandshake _tmp71_;
		SettingsHandshake _tmp72_;
		_tmp70_ = settings;
		_tmp71_ = settings_get_handshake (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp66_ = _tmp72_ == SETTINGS_HANDSHAKE_BOTH;
	}
	_tmp73_ = _tmp66_;
	if (_tmp73_) {
		tcflag_t _tmp74_;
		_tmp74_ = self->priv->newtio.c_cflag;
		self->priv->newtio.c_cflag = _tmp74_ | CRTSCTS;
	} else {
		tcflag_t _tmp75_;
		_tmp75_ = self->priv->newtio.c_cflag;
		self->priv->newtio.c_cflag = _tmp75_ & (~CRTSCTS);
	}
}


gchar* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self) {
	gchar* result = NULL;
	gchar* r = NULL;
	gulong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->nonprintable;
	if (_tmp0_ > ((gulong) 0)) {
		const gchar* _tmp1_ = NULL;
		gulong _tmp2_;
		gulong _tmp3_;
		gulong _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp1_ = _ ("TX: %lu, RX: %lu (%lu unprintable)");
		_tmp2_ = self->tx;
		_tmp3_ = self->rx;
		_tmp4_ = self->nonprintable;
		_tmp5_ = g_strdup_printf (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
		_g_free0 (r);
		r = _tmp5_;
	} else {
		const gchar* _tmp6_ = NULL;
		gulong _tmp7_;
		gulong _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp6_ = _ ("TX: %lu, RX: %lu");
		_tmp7_ = self->tx;
		_tmp8_ = self->rx;
		_tmp9_ = g_strdup_printf (_tmp6_, _tmp7_, _tmp8_);
		_g_free0 (r);
		r = _tmp9_;
	}
	result = r;
	return result;
}


moserialSerialConnection* moserial_serial_connection_construct (GType object_type) {
	moserialSerialConnection * self = NULL;
	self = (moserialSerialConnection*) g_object_new (object_type, NULL);
	return self;
}


moserialSerialConnection* moserial_serial_connection_new (void) {
	return moserial_serial_connection_construct (MOSERIAL_TYPE_SERIAL_CONNECTION);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}


static void moserial_serial_connection_class_init (moserialSerialConnectionClass * klass) {
	moserial_serial_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSerialConnectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = moserial_serial_connection_finalize;
	g_signal_new ("new_data", MOSERIAL_TYPE_SERIAL_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_INT, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_INT);
}


static void moserial_serial_connection_instance_init (moserialSerialConnection * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = MOSERIAL_SERIAL_CONNECTION_GET_PRIVATE (self);
	self->tx = (gulong) 0;
	self->rx = (gulong) 0;
	self->nonprintable = (gulong) 0;
	self->forced_hex_view = FALSE;
	self->lastRxCharWasCR = FALSE;
	_tmp0_ = g_strdup ("");
	self->echoReference = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->echoCompare = _tmp1_;
	self->priv->m_fd = -1;
	self->priv->flags = 0;
}


static void moserial_serial_connection_finalize (GObject* obj) {
	moserialSerialConnection * self;
	self = MOSERIAL_SERIAL_CONNECTION (obj);
	_g_free0 (self->echoReference);
	_g_free0 (self->echoCompare);
	_g_io_channel_unref0 (self->priv->IOChannelFd);
	_g_free0 (self->priv->sourceId);
	G_OBJECT_CLASS (moserial_serial_connection_parent_class)->finalize (obj);
}


GType moserial_serial_connection_get_type (void) {
	static volatile gsize moserial_serial_connection_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSerialConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialConnection), 0, (GInstanceInitFunc) moserial_serial_connection_instance_init, NULL };
		GType moserial_serial_connection_type_id;
		moserial_serial_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSerialConnection", &g_define_type_info, 0);
		g_once_init_leave (&moserial_serial_connection_type_id__volatile, moserial_serial_connection_type_id);
	}
	return moserial_serial_connection_type_id__volatile;
}



