/* InputParser.c generated by valac 0.28.1, the Vala compiler
 * generated from InputParser.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_INPUT_PARSER (input_parser_get_type ())
#define INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INPUT_PARSER, InputParser))
#define INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INPUT_PARSER, InputParserClass))
#define IS_INPUT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INPUT_PARSER))
#define IS_INPUT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INPUT_PARSER))
#define INPUT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INPUT_PARSER, InputParserClass))

typedef struct _InputParser InputParser;
typedef struct _InputParserClass InputParserClass;
typedef struct _InputParserPrivate InputParserPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	HEX_PARSE_ERROR_INVALID_INPUT
} HexParseError;
#define HEX_PARSE_ERROR hex_parse_error_quark ()
struct _InputParser {
	GObject parent_instance;
	InputParserPrivate * priv;
};

struct _InputParserClass {
	GObjectClass parent_class;
};


static gpointer input_parser_parent_class = NULL;

GQuark hex_parse_error_quark (void);
GType input_parser_get_type (void) G_GNUC_CONST;
enum  {
	INPUT_PARSER_DUMMY_PROPERTY
};
gchar* input_parser_statusReplace (const gchar* oldString);
guchar* input_parser_parseHex (const gchar* s, int* result_length1, GError** error);
static guchar input_parser_xtoi (gunichar c);
InputParser* input_parser_new (void);
InputParser* input_parser_construct (GType object_type);


GQuark hex_parse_error_quark (void) {
	return g_quark_from_static_string ("hex_parse_error-quark");
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* input_parser_statusReplace (const gchar* oldString) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (oldString != NULL, NULL);
	_tmp0_ = oldString;
	_tmp1_ = string_replace (_tmp0_, "\\r", "\\n");
	result = _tmp1_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


guchar* input_parser_parseHex (const gchar* s, int* result_length1, GError** error) {
	guchar* result = NULL;
	glong len = 0L;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guchar* r = NULL;
	glong _tmp3_ = 0L;
	guchar* _tmp4_ = NULL;
	gint r_length1 = 0;
	gint _r_size_ = 0;
	guchar* _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	len = (glong) _tmp2_;
	_tmp3_ = len;
	_tmp4_ = g_new0 (guchar, (_tmp3_ + 1) / 2);
	r = _tmp4_;
	r_length1 = (_tmp3_ + 1) / 2;
	_r_size_ = r_length1;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				glong _tmp8_ = 0L;
				gunichar c = 0U;
				gint i = 0;
				gint temp = 0;
				const gchar* _tmp9_ = NULL;
				gunichar _tmp10_ = 0U;
				gunichar _tmp11_ = 0U;
				guchar _tmp12_ = '\0';
				gint _tmp13_ = 0;
				glong _tmp16_ = 0L;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				guchar* _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				guchar _tmp34_ = '\0';
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = x;
					x = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = x;
				_tmp8_ = len;
				if (!(((glong) _tmp7_) < ((_tmp8_ + 1) / 2))) {
					break;
				}
				_tmp9_ = s;
				_tmp10_ = string_get_char (_tmp9_, (glong) 0);
				c = _tmp10_;
				_tmp11_ = c;
				_tmp12_ = input_parser_xtoi (_tmp11_);
				i = (gint) _tmp12_;
				_tmp13_ = i;
				if (_tmp13_ > 15) {
					const gchar* _tmp14_ = NULL;
					GError* _tmp15_ = NULL;
					_tmp14_ = _ ("Invalid Input");
					_tmp15_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp14_);
					_inner_error_ = _tmp15_;
					if (_inner_error_->domain == HEX_PARSE_ERROR) {
						g_propagate_error (error, _inner_error_);
						r = (g_free (r), NULL);
						return NULL;
					} else {
						r = (g_free (r), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp16_ = len;
				if (_tmp16_ > ((glong) 1)) {
					gint _tmp17_ = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gunichar _tmp21_ = 0U;
					gunichar _tmp22_ = 0U;
					guchar _tmp23_ = '\0';
					gint _tmp24_ = 0;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					_tmp17_ = i;
					i = _tmp17_ * 16;
					_tmp18_ = s;
					_tmp19_ = g_utf8_next_char (_tmp18_);
					s = _tmp19_;
					_tmp20_ = s;
					_tmp21_ = string_get_char (_tmp20_, (glong) 0);
					c = _tmp21_;
					_tmp22_ = c;
					_tmp23_ = input_parser_xtoi (_tmp22_);
					temp = (gint) _tmp23_;
					_tmp24_ = temp;
					if (_tmp24_ > 15) {
						const gchar* _tmp25_ = NULL;
						GError* _tmp26_ = NULL;
						_tmp25_ = _ ("Invalid Input");
						_tmp26_ = g_error_new_literal (HEX_PARSE_ERROR, HEX_PARSE_ERROR_INVALID_INPUT, _tmp25_);
						_inner_error_ = _tmp26_;
						if (_inner_error_->domain == HEX_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							r = (g_free (r), NULL);
							return NULL;
						} else {
							r = (g_free (r), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp27_ = i;
					_tmp28_ = temp;
					i = _tmp27_ + _tmp28_;
				}
				_tmp29_ = s;
				_tmp30_ = g_utf8_next_char (_tmp29_);
				s = _tmp30_;
				_tmp31_ = r;
				_tmp31__length1 = r_length1;
				_tmp32_ = x;
				_tmp33_ = i;
				_tmp31_[_tmp32_] = (guchar) _tmp33_;
				_tmp34_ = _tmp31_[_tmp32_];
			}
		}
	}
	_tmp35_ = r;
	_tmp35__length1 = r_length1;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	return result;
}


static guchar input_parser_xtoi (gunichar c) {
	guchar result = '\0';
	guchar i = '\0';
	gunichar _tmp0_ = 0U;
	i = (guchar) 16;
	_tmp0_ = c;
	switch (_tmp0_) {
		case '0':
		{
			i = (guchar) 0;
			break;
		}
		case '1':
		{
			i = (guchar) 1;
			break;
		}
		case '2':
		{
			i = (guchar) 2;
			break;
		}
		case '3':
		{
			i = (guchar) 3;
			break;
		}
		case '4':
		{
			i = (guchar) 4;
			break;
		}
		case '5':
		{
			i = (guchar) 5;
			break;
		}
		case '6':
		{
			i = (guchar) 6;
			break;
		}
		case '7':
		{
			i = (guchar) 7;
			break;
		}
		case '8':
		{
			i = (guchar) 8;
			break;
		}
		case '9':
		{
			i = (guchar) 9;
			break;
		}
		case 'a':
		{
			i = (guchar) 10;
			break;
		}
		case 'b':
		{
			i = (guchar) 11;
			break;
		}
		case 'c':
		{
			i = (guchar) 12;
			break;
		}
		case 'd':
		{
			i = (guchar) 13;
			break;
		}
		case 'e':
		{
			i = (guchar) 14;
			break;
		}
		case 'f':
		{
			i = (guchar) 15;
			break;
		}
		case 'A':
		{
			i = (guchar) 10;
			break;
		}
		case 'B':
		{
			i = (guchar) 11;
			break;
		}
		case 'C':
		{
			i = (guchar) 12;
			break;
		}
		case 'D':
		{
			i = (guchar) 13;
			break;
		}
		case 'E':
		{
			i = (guchar) 14;
			break;
		}
		case 'F':
		{
			i = (guchar) 15;
			break;
		}
		default:
		break;
	}
	result = i;
	return result;
}


InputParser* input_parser_construct (GType object_type) {
	InputParser * self = NULL;
	self = (InputParser*) g_object_new (object_type, NULL);
	return self;
}


InputParser* input_parser_new (void) {
	return input_parser_construct (TYPE_INPUT_PARSER);
}


static void input_parser_class_init (InputParserClass * klass) {
	input_parser_parent_class = g_type_class_peek_parent (klass);
}


static void input_parser_instance_init (InputParser * self) {
}


GType input_parser_get_type (void) {
	static volatile gsize input_parser_type_id__volatile = 0;
	if (g_once_init_enter (&input_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (InputParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) input_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (InputParser), 0, (GInstanceInitFunc) input_parser_instance_init, NULL };
		GType input_parser_type_id;
		input_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "InputParser", &g_define_type_info, 0);
		g_once_init_leave (&input_parser_type_id__volatile, input_parser_type_id);
	}
	return input_parser_type_id__volatile;
}



