/* Profile.c generated by valac 0.28.1, the Vala compiler
 * generated from Profile.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer profile_parent_class = NULL;

GType profile_get_type (void) G_GNUC_CONST;
enum  {
	PROFILE_DUMMY_PROPERTY
};
void profile_saveWindowSize (Profile* self, gint w, gint h);
void profile_saveWindowPanedPosition (Profile* self, gint pos);
gint profile_getWindowPanedPosition (Profile* self);
gint profile_getWindowWidth (Profile* self);
gint profile_getWindowHeight (Profile* self);
gboolean profile_load (Profile* self, const gchar* filename, GtkWindow* window);
void profile_toString (Profile* self);
void profile_save (Profile* self, const gchar* filename, GtkWindow* window);
Profile* profile_new (void);
Profile* profile_construct (GType object_type);
static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void profile_finalize (GObject* obj);


void profile_saveWindowSize (Profile* self, gint w, gint h) {
	gint _tmp0_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = w;
	if (_tmp0_ > 0) {
		GKeyFile* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = self->keyFile;
		_tmp2_ = w;
		g_key_file_set_integer (_tmp1_, "window", "width", _tmp2_);
	}
	_tmp3_ = h;
	if (_tmp3_ > 0) {
		GKeyFile* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->keyFile;
		_tmp5_ = h;
		g_key_file_set_integer (_tmp4_, "window", "height", _tmp5_);
	}
}


void profile_saveWindowPanedPosition (Profile* self, gint pos) {
	GKeyFile* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->keyFile;
	_tmp1_ = pos;
	g_key_file_set_integer (_tmp0_, "window", "paned_pos", _tmp1_);
}


gint profile_getWindowPanedPosition (Profile* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = self->keyFile;
		_tmp2_ = g_key_file_get_integer (_tmp1_, "window", "paned_pos", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch23_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally23;
	__catch23_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally23:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gint profile_getWindowWidth (Profile* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = self->keyFile;
		_tmp2_ = g_key_file_get_integer (_tmp1_, "window", "width", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch24_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally24;
	__catch24_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally24:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gint profile_getWindowHeight (Profile* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_ = 0;
		GKeyFile* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = self->keyFile;
		_tmp2_ = g_key_file_get_integer (_tmp1_, "window", "height", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch25_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally25;
	__catch25_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally25:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gboolean profile_load (Profile* self, const gchar* filename, GtkWindow* window) {
	gboolean result = FALSE;
	gchar* f = NULL;
	gboolean default_profile = FALSE;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	default_profile = FALSE;
	_tmp0_ = filename;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		default_profile = TRUE;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_strdup_printf ("%s/moserial.conf", _tmp1_);
		_g_free0 (f);
		f = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = filename;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (f);
		f = _tmp4_;
	}
	{
		GKeyFile* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = self->keyFile;
		_tmp6_ = f;
		g_key_file_load_from_file (_tmp5_, _tmp6_, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch26_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch26_g_file_error;
			}
			_g_free0 (f);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = TRUE;
		_g_free0 (f);
		return result;
	}
	goto __finally26;
	__catch26_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		result = TRUE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	goto __finally26;
	__catch26_g_file_error:
	{
		GError* e = NULL;
		gboolean _tmp10_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = default_profile;
		if (!_tmp10_) {
			GtkMessageDialog* errorDialog = NULL;
			GtkWindow* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			GtkMessageDialog* _tmp16_ = NULL;
			GtkMessageDialog* _tmp17_ = NULL;
			GtkMessageDialog* _tmp18_ = NULL;
			_tmp11_ = window;
			_tmp12_ = _ ("Error: Could not open file");
			_tmp13_ = filename;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp11_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s: %s\n%s", _tmp12_, _tmp13_, _tmp15_);
			g_object_ref_sink (_tmp16_);
			errorDialog = _tmp16_;
			_tmp17_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp17_);
			_tmp18_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp18_);
			_g_object_unref0 (errorDialog);
		}
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	__finally26:
	_g_free0 (f);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void profile_toString (Profile* self) {
	gsize s = 0UL;
	FILE* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->keyFile;
	_tmp3_ = g_key_file_to_data (_tmp1_, &_tmp2_, NULL);
	s = _tmp2_;
	_tmp4_ = _tmp3_;
	fprintf (_tmp0_, "%s\n", _tmp4_);
	_g_free0 (_tmp4_);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void profile_save (Profile* self, const gchar* filename, GtkWindow* window) {
	GFile* file = NULL;
	GFileOutputStream* fos = NULL;
	gchar* f = NULL;
	gboolean default_profile = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	default_profile = FALSE;
	_tmp0_ = filename;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		default_profile = TRUE;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_strdup_printf ("%s/moserial.conf", _tmp1_);
		_g_free0 (f);
		f = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = filename;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (f);
		f = _tmp4_;
	}
	_tmp5_ = f;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_g_object_unref0 (file);
	file = _tmp6_;
	{
		gsize s = 0UL;
		gchar* data = NULL;
		GFileOutputStream* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFileOutputStream* _tmp9_ = NULL;
		GFileOutputStream* _tmp10_ = NULL;
		GKeyFile* _tmp11_ = NULL;
		gsize _tmp12_ = 0UL;
		gchar* _tmp13_ = NULL;
		GFileOutputStream* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		guint8* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		guint8* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		_tmp8_ = file;
		_tmp9_ = g_file_replace (_tmp8_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (data);
			goto __catch27_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (fos);
		fos = _tmp10_;
		_tmp11_ = self->keyFile;
		_tmp13_ = g_key_file_to_data (_tmp11_, &_tmp12_, NULL);
		s = _tmp12_;
		_g_free0 (data);
		data = _tmp13_;
		_tmp14_ = fos;
		_tmp15_ = data;
		_tmp16_ = string_get_data (_tmp15_, &_tmp16__length1);
		_tmp17_ = _tmp16_;
		_tmp17__length1 = _tmp16__length1;
		g_output_stream_write ((GOutputStream*) _tmp14_, _tmp17_, (gsize) _tmp17__length1, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			_g_free0 (data);
			goto __catch27_g_error;
		}
		_g_object_unref0 (_tmp7_);
		_g_free0 (data);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		FILE* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = stdout;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		fprintf (_tmp18_, "profile.save error: %s\n", _tmp20_);
		_tmp21_ = default_profile;
		if (!_tmp21_) {
			GtkMessageDialog* errorDialog = NULL;
			GtkWindow* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			GError* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			GtkMessageDialog* _tmp27_ = NULL;
			GtkMessageDialog* _tmp28_ = NULL;
			GtkMessageDialog* _tmp29_ = NULL;
			_tmp22_ = window;
			_tmp23_ = _ ("Error: Could not open file");
			_tmp24_ = filename;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			_tmp27_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp22_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s: %s\n%s", _tmp23_, _tmp24_, _tmp26_);
			g_object_ref_sink (_tmp27_);
			errorDialog = _tmp27_;
			_tmp28_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp28_);
			_tmp29_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp29_);
			_g_object_unref0 (errorDialog);
		}
		_g_error_free0 (e);
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (f);
		_g_object_unref0 (fos);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (f);
	_g_object_unref0 (fos);
	_g_object_unref0 (file);
}


Profile* profile_construct (GType object_type) {
	Profile * self = NULL;
	self = (Profile*) g_object_new (object_type, NULL);
	return self;
}


Profile* profile_new (void) {
	return profile_construct (TYPE_PROFILE);
}


static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Profile * self;
	GKeyFile* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (profile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE, Profile);
	_tmp0_ = g_key_file_new ();
	_g_key_file_free0 (self->keyFile);
	self->keyFile = _tmp0_;
	return obj;
}


static void profile_class_init (ProfileClass * klass) {
	profile_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = profile_constructor;
	G_OBJECT_CLASS (klass)->finalize = profile_finalize;
}


static void profile_instance_init (Profile * self) {
}


static void profile_finalize (GObject* obj) {
	Profile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROFILE, Profile);
	_g_key_file_free0 (self->keyFile);
	G_OBJECT_CLASS (profile_parent_class)->finalize (obj);
}


GType profile_get_type (void) {
	static volatile gsize profile_type_id__volatile = 0;
	if (g_once_init_enter (&profile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Profile), 0, (GInstanceInitFunc) profile_instance_init, NULL };
		GType profile_type_id;
		profile_type_id = g_type_register_static (G_TYPE_OBJECT, "Profile", &g_define_type_info, 0);
		g_once_init_leave (&profile_type_id__volatile, profile_type_id);
	}
	return profile_type_id__volatile;
}



