#ifndef _INCLUDE_FFMPEG_H_
#define _INCLUDE_FFMPEG_H_

#ifdef HAVE_FFMPEG
#include "avformat.h"
#endif

struct ffmpeg {
#ifdef HAVE_FFMPEG
	AVFormatContext *oc;
	AVStream *video_st;
	AVCodecContext *c;

	AVFrame *picture;
	uint8_t *video_outbuf;
	int video_outbuf_size;
	FILE *f;

	void *udata;

	unsigned char *y;
	unsigned char *u;
	unsigned char *v;
	int width;
	int height;
	int vbr;
	char codec[20];
#else
	int dummy;
#endif
};

void ffmpeg_init(void);
extern struct ffmpeg *ffmpeg_open(char *, char *, unsigned char *, unsigned char *, unsigned char *, int, int, int, int, int);
extern struct ffmpeg *ffmpeg_open_mpeg4(char *, char *, unsigned char *, unsigned char *, unsigned char *, int, int, int, int, int);
extern struct ffmpeg *ffmpeg_open_mpeg1(char *, char *, unsigned char *, unsigned char *, unsigned char *, int, int, int, int, int);
extern void ffmpeg_close(struct ffmpeg *);
extern void ffmpeg_close_mpeg4(struct ffmpeg *);
extern void ffmpeg_close_mpeg1(struct ffmpeg *);
extern void ffmpeg_put_image(struct ffmpeg *);
extern void ffmpeg_put_image_mpeg4(struct ffmpeg *);
extern void ffmpeg_put_image_mpeg1(struct ffmpeg *);
void ffmpeg_put_other_image(struct ffmpeg *, unsigned char *, unsigned char *, unsigned char *);
void ffmpeg_put_other_image_mpeg4(struct ffmpeg *, unsigned char *, unsigned char *, unsigned char *);
void ffmpeg_put_other_image_mpeg1(struct ffmpeg *, unsigned char *, unsigned char *, unsigned char *);
void ffmpeg_cleanups(struct ffmpeg *);
#endif /* _INCLUDE_FFMPEG_H_ */
