#include "uitagbrowser.h"
#include "uieditor.h"

uitagbrowser uitb;

static string getscopename(motortagbrowser::viewscope nscope) {
    switch(nscope) {
	case motortagbrowser::File:
	    return _("Current file");
	case motortagbrowser::Project:
	    return _("Current project");
	case motortagbrowser::Everything:
	    return _("Everything");
    }

    return "";
}

uitagbrowser::uitagbrowser(): mpos(0) {
}

uitagbrowser::~uitagbrowser() {
}

int uitagbrowser::mkeys(verticalmenu &m, int k) {
    string oldsearch = uitb.search;

    switch(k) {
        case KEY_BACKSPACE:
	    if(!uitb.search.empty()) {
		uitb.search = oldsearch.substr(0, oldsearch.size()-1);
	    }
            break;

        case KEY_DC:
	    uitb.search = ed.atcursor() != uitb.search ? ed.atcursor() : "";
	    break;

	case KEY_F(2):
	    uitb.changemode();
	    break;

	case CTRL('r'):
	    uitb.reload();
	    break;

        default:
            if(isprint(k)) {
                if(!uitb.modified) {
                    uitb.search = "";
                    uitb.modified = true;
                }
                
                uitb.search += k;
            }
            break;
    }

    if(oldsearch != uitb.search) {
        if((uitb.search.size() > oldsearch.size()) && !m.getcount()) {
            uitb.input();
        } else {
            uitb.makemenu(m);
        }
    }

    return -1;
}

void uitagbrowser::title() {
    w.set_titlef(uiconf.getcolor(cp_menuhl), _(" Symbols [%s] "),
	getscopename(tagbrowser.getscope()).c_str());
}

void uitagbrowser::changemode() {
    int n;
    verticalmenu cm(uiconf.getcolor(cp_menufr), uiconf.getcolor(cp_menusel));
    cm.setwindow(textwindow(w.x1, w.y1, w.x1+20, 0, uiconf.getcolor(cp_menufr)));

    for(motortagbrowser::viewscope scope = motortagbrowser::File;
    scope != motortagbrowser::viewscope_size; (int) scope += 1) {
	cm.additem(0, scope, (string) " " + getscopename(scope));
	if(scope == tagbrowser.getscope())
	    cm.setpos(cm.getcount()-1);

    }

    cm.scale();
    n = cm.open();
    cm.close();

    if(n) {
	int c = (int) cm.getref(n-1);

	if(c != tagbrowser.getscope()) {
	    tagbrowser.setscope((motortagbrowser::viewscope) c);
	    reload();
	}
    }
}

void uitagbrowser::reload() {
    ui.autosave();
    tagbrowser.clear();
    makemenu(m);
    title();
}

void uitagbrowser::makemenu(verticalmenu &m) {
    int len;
    string buf, desc, skind;
    vector<motortagbrowser::record>::iterator it;

    tags = tagbrowser.fetch(search);
    m.clear();

    for(it = tags.begin(); it != tags.end(); it++) {
        buf = " " + it->getname();
	desc = it->getbrowsertagname();
	
        if((skind = it->getinfo()).size() && (skind[skind.size()-1] != ':')) {
            if(desc.size()) desc += ", ";
            desc += skind;
        }

        if((len = w.x2-w.x1-buf.size()-desc.size()-2) < 2) {
            len = 2;
            buf.resize(w.x2-w.x1-buf.size()-4);
        }

        buf += skind.assign(len, ' ') + desc;
        m.additem(0, it-tags.begin(), buf);
    }

    ui.log(_("Symbols: type to find, ~Del~ clear, ~F2~ set scope, ~^R~ reload, ~Enter~ go to source"));
    m.redraw();
    input();
}

void uitagbrowser::input() {
    attrset(uiconf.getcolor(cp_menufr));
    mvhline(w.y2-1, w.x1+2, ' ', w.x2-w.x1-2);
    w.write(2, w.y2-w.y1-1, uiconf.getcolor(cp_menuhl), search);
}

void uitagbrowser::exec() {
    int n, k;
    bool r;

    if(search.empty())
	search = ed.atcursor();

    tags = tagbrowser.fetch(search);
    if(!tagbrowser.ok()) {
	return;
    }

    w = textwindow(0, 0, DIALOG_WIDTH, DIALOG_HEIGHT, uiconf.getcolor(cp_menufr), TW_CENTERED);

    title();
    w.open();
    w.separatey(w.y2-w.y1-2);

    m = verticalmenu(w.x1+1, w.y1+1, w.x2, w.y2-2, uiconf.getcolor(cp_menufr),
	uiconf.getcolor(cp_menusel));

    m.otherkeys = &mkeys;
    modified = false;

    makemenu(m);
    m.setpos(mpos);

    if(r = (n = m.open())) {
        k = (int) m.getref(n-1);
        mpos = n-1;
    }

    w.close();

    if(r)
    if(!tags.empty())
	ui.loadeditfile((tags.begin()+k)->geteditfile());

    ui.log();
}
