//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Plugin "Shares mounting"
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef SHARES_MOUNT
#define SHARES_MOUNT

#include <QObject>
#include <QList>
#include "plugininterface.h"

class QWidget;
class QDialog;
class QDockWidget;
class QTextBrowser;
class QAction;
class QPushButton;
class QCheckBox;
class QLineEdit;
class QTreeWidget;
class ChooseMountPointWidget;
class QGroupBox;
class QTreeWidgetItem;
class QRadioButton;
class QLabel;

class SharesMount : public QObject, public MountManagerPlugin
{
	Q_OBJECT
	Q_INTERFACES(MountManagerPlugin)
	private slots:
		void saveSettings();
		void add();
		void addShare();
		void edit();
		void editShare();
		void remove();
		void cancel();
		
		void typeChanged();
		void itemChanged(QTreeWidgetItem *,QTreeWidgetItem *);
	private:
		QDialog *mainWidget;
		Actions actions;
		QTreeWidget *treeWidget;
		QPushButton *addButton;
		QPushButton *editButton;
		QPushButton *removeButton;
		QPushButton *closeButton;

		QGroupBox *typeGroupBox;
		QRadioButton *nfsType;
		QRadioButton *smbType;

		QLineEdit *smbNameLine;
		QLineEdit *smbPassLine;
		QWidget *sbmOptionsWidget;
		
		QGroupBox *groupBox;
		QLineEdit *serverLine;
		QLineEdit *remoteDirLine;
		ChooseMountPointWidget *mountPointLine;
		QLineEdit *optionsLine;
		QLabel *optionsLabel;
		
		QPushButton *addShareButton;
		QPushButton *editShareButton;
		
		QPushButton *cancelButton;

		QString fstabTextExceptShares;

		void loadSettings();
		void clearLines();
		void searchSharesLinesInFstab();
		bool checkLinesContent();
		void setContentToItem(QTreeWidgetItem *item);
		
		QTreeWidgetItem *currentEditedItem;
	public:
		SharesMount(QWidget *parent = 0);
		~SharesMount();

		void setParent(QObject *parent);

		const QString pluginName() const;
		const QString pluginDescription() const;
		
		QDialog* dialog() const;
		QDockWidget* dockWidget() const;
		QMenu* menu() const;
		QToolBar* toolBar() const;
		
		Actions menuActions() const;
};

#endif
