//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Plugin "Tips of the day"
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QDialog>
#include <QtGui/QAction>
#include <QtGui/QLabel>
#include <QtGui/QTextBrowser>
#include <QtGui/QCheckBox>
#include <QtGui/QPushButton>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtCore/QDir>
#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include <QtCore/QSettings>
#include <QtPlugin>
#include "tips.h"
#include "../../sources/gui/const.h"


TipsDialog::TipsDialog(QWidget *parent) {
	QFile file(":/resources/tips.txt");
	file.open(QIODevice::ReadOnly);
	QTextStream stream(&file);

	QString line;
	int emptyLinesInRow = 0;
	QString currentTipText;
	while (!stream.atEnd()) {
		line = stream.readLine();
		if (line.isEmpty())
			emptyLinesInRow++;
		else
			emptyLinesInRow = 0;
		currentTipText += line;
		if (emptyLinesInRow == 2 || (!currentTipText.isEmpty() && stream.atEnd()))
			if (!currentTipText.isEmpty()) {
				tips.append(new Tip(currentTipText,tips.count()));
				currentTipText.clear();
			}
	}
	
	mainWidget = new QDialog(parent);

	textBrowser = new QTextBrowser;

	showOnStartup = new QCheckBox(tr("Show tips on startup"));

	nextButton = new QPushButton;
	nextButton->setIcon(QIcon(":/resources/next.png"));
	nextButton->setFlat(true);
	nextButton->setEnabled(tips.count() > 0);
	connect(nextButton,SIGNAL(clicked()),this,SLOT(next()));
	
	backButton = new QPushButton;
	backButton->setIcon(QIcon(":/resources/previous.png"));
	backButton->setFlat(true);
	backButton->setEnabled(false);
	connect(backButton,SIGNAL(clicked()),textBrowser,SLOT(backward()));
	connect(textBrowser,SIGNAL(backwardAvailable(bool)),backButton,SLOT(setEnabled(bool)));

	closeButton = new QPushButton;
	closeButton->setIcon(QIcon(":/resources/close.png"));
	closeButton->setFlat(true);
	connect(closeButton,SIGNAL(clicked()),mainWidget,SLOT(hide()));

	QLabel *headerLabel = new QLabel("<font size='4'><center><b>" + tr("Did you know?") + "</b></center></font>");
	
	QAction *action = new QAction(this);
	action->setText(tr("Tips of the day"));
	action->setIcon(QIcon(":/resources/main.png"));
	connect(action,SIGNAL(triggered()),this,SLOT(show()));
	actions.append(action);

	QHBoxLayout *buttonLayout = new QHBoxLayout;
	buttonLayout->addWidget(showOnStartup);
	buttonLayout->addStretch();
	buttonLayout->addWidget(backButton);
	buttonLayout->addWidget(nextButton);
	buttonLayout->addWidget(closeButton);
	buttonLayout->setMargin(0);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(headerLabel);
	mainLayout->addWidget(textBrowser);
	mainLayout->addLayout(buttonLayout);
	
	mainWidget->setLayout(mainLayout);
	
	mainWidget->setWindowTitle(tr("Tips of the day"));
	mainWidget->setWindowIcon(QIcon(":/resources/main.png"));
	loadSettings();
}

TipsDialog::~TipsDialog() {
	foreach (QAction *action,actions)
		delete action;
	delete textBrowser;
	delete showOnStartup;
	delete nextButton;
	delete backButton;
	delete closeButton;
	delete mainWidget;
}

void TipsDialog::setParent(QObject *parent) {
	QSettings settings(ORGANIZATION,PROGRAM_NAME);
	if (settings.value("Tips/ShowOnStartup",true).toBool())
		connect(parent,SIGNAL(started()),this,SLOT(show()));
	connect(parent,SIGNAL(finished()),this,SLOT(saveSettings()));
}

const QString TipsDialog::pluginName() const {
	return tr("Tips of the day");
}

const QString TipsDialog::pluginDescription() const {
	return tr("You can read different advices for usage of MountManager and information about mounting in Linux.");
}
	
QDialog* TipsDialog::dialog() const {
	return mainWidget;
}

QDockWidget* TipsDialog::dockWidget() const {
	return 0;
}

QMenu* TipsDialog::menu() const {
	return 0;
}

QToolBar* TipsDialog::toolBar() const {
	return 0;
}

Actions TipsDialog::menuActions() const {
	return actions;
}

int TipsDialog::randomIndex() {
	if (watchedTipsIndexes.count() == tips.count())
		watchedTipsIndexes.clear();
	int randomNumber = (int)(double(tips.count())*rand()/(RAND_MAX+1.0));
	while (watchedTipsIndexes.contains(randomNumber))
		randomNumber = (int)(double(tips.count())*rand()/(RAND_MAX+1.0));
	return randomNumber;
}

void TipsDialog::show() {
	next();
	mainWidget->show();
}

void TipsDialog::next() {
	int index = randomIndex();
	watchedTipsIndexes.append(index);
	textBrowser->setHtml(tips[index]->tipContent);
}

void TipsDialog::saveSettings() {
	QSettings settings(ORGANIZATION,PROGRAM_NAME);
	settings.setValue("Tips/ShowOnStartup",showOnStartup->isChecked());
	settings.setValue("Tips/Size",mainWidget->size());
}

void TipsDialog::loadSettings() {
	QSettings settings(ORGANIZATION,PROGRAM_NAME);
	showOnStartup->setChecked(settings.value("Tips/ShowOnStartup",true).toBool());
	mainWidget->resize(settings.value("Tips/Size",QSize(450,300)).toSize());
}

Q_EXPORT_PLUGIN2(tipsplugin,TipsDialog)
