//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DISKCORE_H
#define DISKCORE_H

#include <QProcess>
#include "diskhal.h"
#include "diskoptionscenter.h"
#include "diskbackup.h"

class DiskDevice;

class DiskCore : public DiskHal, public DiskOptionsCenter, public DiskBackUp
{
	Q_OBJECT
	public slots:
		void mount(const QString &blockName,const QString& mountPoint, const QString& fs, const QString& options);
		void unmount(DiskDevice *deviceToUnmount);
		void unmount(const QString &blockName);
		void mountAll();
		void unmountAll();
	private slots:
		void processFinished(int,QProcess::ExitStatus);
	signals:
		void errorAppeared(const QString& errorText);
	private:
		QString errorText;

		QProcess *process;
	public:
		DiskCore(const QString &backupPath = QString(),bool debug = true);
		~DiskCore();
		const QString& error() const;
};

#endif
