//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QLineEdit>
#include <QPushButton>
#include <QFileDialog>
#include <QHBoxLayout>
#include "choosemountpointwidget.h"
#include "const.h"

ChooseMountPointWidget::ChooseMountPointWidget(QString defaultMountPoint) {
	lineEdit = new QLineEdit;
	lineEdit->setReadOnly(true);
	lineEdit->setText(defaultMountPoint);
	currentMountPoint = defaultMountPoint;

	pushButton = new QPushButton;
	pushButton->setIcon(QIcon(ICONS_PATH"choose.png"));

	connect(pushButton,SIGNAL(clicked()),this,SLOT(chooseMountPoint()));
	connect(lineEdit,SIGNAL(textChanged(const QString &)),this,SLOT(setMountPoint(const QString&)));

	QHBoxLayout *mainLayout = new QHBoxLayout;
	mainLayout->addWidget(lineEdit);
	mainLayout->addWidget(pushButton);
	setLayout(mainLayout);
}

ChooseMountPointWidget::~ChooseMountPointWidget() {
	delete lineEdit;
	delete pushButton;
}

void ChooseMountPointWidget::chooseMountPoint() {
	QString tempMountPoint;
	if (!currentMountPoint.isEmpty())
		tempMountPoint = QFileDialog::getExistingDirectory(this,tr("Choose mount point"),currentMountPoint);
	else
		tempMountPoint = QFileDialog::getExistingDirectory(this,tr("Choose mount point"),QString("/mnt"));
	if (tempMountPoint.isEmpty() && currentMountPoint.isEmpty()) {
		emit (mountPointValidSignal(false));
		return;
	}
	lineEdit->setText(tempMountPoint);
	currentMountPoint = tempMountPoint;
	emit (mountPointChanged(lineEdit->text()));
	emit (mountPointValidSignal(true));
}

bool ChooseMountPointWidget::isValid() const {
	return !lineEdit->text().isEmpty();
}

const QString& ChooseMountPointWidget::mountPoint() const {
	return currentMountPoint;
}

void ChooseMountPointWidget::setMountPoint(const QString& mountPoint) {
	currentMountPoint = mountPoint;
	lineEdit->setText(mountPoint);
	emit(mountPointChanged(mountPoint));
	emit(mountPointValidSignal(!mountPoint.isEmpty()));
}

void ChooseMountPointWidget::setReadOnly(bool isReadOnly) {
	lineEdit->setReadOnly(isReadOnly);
}
