//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include "infobutton.h"
#include "const.h"
#include "popupwindow.h"

InfoButton::InfoButton(PopupWindow *popup,const QString& text, const QString& header) {
	setIcon(QIcon(QString(ICONS_PATH) + "info.png"));
	setFlat(true);
	popupWindow = popup;
	popupText = text;
	popupHeader = header;
	connect(this,SIGNAL(clicked()),this,SLOT(setPopupData()));
}

void InfoButton::setPopupText(const QString& text) {
	popupText = text;
}

void InfoButton::setPopupHeaderText(const QString& header) {
	popupHeader = header;
}

void InfoButton::setPopupData() {
	if (popupText.isEmpty())
		popupWindow->setText(tr("Cannot find documentation for it. Try to install new version of MountManager or report about it to developer."));
	else
		popupWindow->setText(popupText);
	if (popupHeader.isEmpty())
		popupWindow->setHeaderText(tr("Popup window"));
	else
		popupWindow->setHeaderText(popupHeader);
	popupWindow->showPopup();
}
