//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef SPECIALWIDGETS_H
#define SPECIALWIDGETS_H

#include <QtGui/QGroupBox>
#include <QtCore/QString>

class Option;
class QLabel;
class QCheckBox;

class PermissionsWidget : public QGroupBox
{
	Q_OBJECT
	signals:
		void permissionsChanged();
	private:
		QLabel *readLabel;
		QLabel *writeLabel;
		QLabel *executeLabel;
		
		QLabel *ownerLabel;
		QCheckBox *ownerRead;
		QCheckBox *ownerWrite;
		QCheckBox *ownerExecute;

		QLabel *groupLabel;
		QCheckBox *groupRead;
		QCheckBox *groupWrite;
		QCheckBox *groupExecute;

		QLabel *otherLabel;
		QCheckBox *otherRead;
		QCheckBox *otherWrite;
		QCheckBox *otherExecute;
		
		QString currentCode;

		Option *option;
	public:
		PermissionsWidget(Option *option);
		~PermissionsWidget();

		void setCode(const QString& code);
		QString& code();
		QString codeForFstab();
		bool isDefaultValue();
};

#endif
