//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef USBMANAGERFSCELLWIDGET_H
#define USBMANAGERFSCELLWIDGET_H

#include <QWidget>

class QLabel;
class QPushButton;

class UsbManagerFsCellWidget : public QWidget
{
	Q_OBJECT
	public slots:
		void setFileSystem(const QString &fs);
		void setOptions(const QString &options);
	signals:
		void editFsOptionsSignal();
	private:
		QPushButton *editButton;
		QLabel *fileSystemLabel;
		QLabel *optionsLabel;
		int cellIndex;

		QString cellIdentifier;
		int cellRow;
	public:
		UsbManagerFsCellWidget(int index);
		~UsbManagerFsCellWidget();

		int index() const;

		const QString &identifier() const;
		QString fileSystem() const;
		void setIdentifier(const QString &identifier);
		void setRow(int row);
		int row() const;
};

#endif
