//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtCore/QVariant>
#include <QtGui/QLabel>
#include <QtGui/QGridLayout>
#include "../core/diskdevice.h"
#include "diskwidget.h"

DiskWidget::DiskWidget(DiskDevice *device) {
	mainLayout = new QGridLayout;
	
	QLabel *diskLabel = new QLabel;
	diskLabel->setAlignment(Qt::AlignTop);
	
	diskLabel->setText("<b>" + tr("Information about %1").arg(device->blockName()) + ":</b><br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("Type") + ": " + device->type() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("Product") + ":" + device->product() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("Size") + ": " + device->size(DiskDevice::Truncation) + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ "Major: " + QVariant(device->majorNumber()).toString() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ "Minor: " + QVariant(device->minorNumber()).toString() + "<br>"
		  );
	labels.append(diskLabel);
	mainLayout->addWidget(diskLabel,0,0);
	mainLayout->setColumnStretch(2,1);
	currentLayoutRow = 1;
	QWidget *mainWidget = new QWidget;
	mainWidget->setLayout(mainLayout);
	setWidget(mainWidget);
	setWidgetResizable(true);
}

DiskWidget::~DiskWidget() {
	foreach (QLabel *label, labels)
		delete label;
	delete mainLayout;
}

void DiskWidget::addVolume(DiskDevice *device) {
	QLabel *volumeLabel = new QLabel;
	volumesList.append(device);
	volumeLabel->setText("<br><b>" + tr("Information about %1").arg(device->blockName()) + ":</b><br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("Product") + ": " + device->product() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("File system") + ": " + device->fileSystem() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("Label") + ": " + device->label() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("Number of blocks") + ": " + QVariant(device->blocks()).toString() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ tr("Size") + ": " + device->size(DiskDevice::Truncation) + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ "Vendor:" + device->vendor() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ "Major: " + QVariant(device->majorNumber()).toString() + "<br>&nbsp;&nbsp;&nbsp;&nbsp;"
			+ "Minor: " + QVariant(device->minorNumber()).toString() + "<br>"
		  );
	if (labels.count() % 2 == 0) {
		mainLayout->addWidget(volumeLabel,currentLayoutRow,1);
		currentLayoutRow++;
	} else
		mainLayout->addWidget(volumeLabel,currentLayoutRow,0);
	mainLayout->setRowStretch(currentLayoutRow+1,1);
	labels.append(volumeLabel);
}
