//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QContextMenuEvent>
#include "treewidget.h"
#include "menu.h"

TreeWidget::TreeWidget(bool isContextMenuEnabled) {
	contextMenu = 0;
	contextMenuEnabled = isContextMenuEnabled;
	setContextMenuEnabled(contextMenuEnabled);
}

void TreeWidget::setContextMenuEnabled(bool isEnabled) {
	// If context menu is enabled and context menu object doesn't exist create it
	if (isEnabled && !contextMenu) contextMenu = new Menu;
	contextMenuEnabled = isEnabled;
}

void TreeWidget::setContextMenuHeader(const QString &headerText) {
	if (contextMenu)
		contextMenu->setHeaderText(headerText);
}

void TreeWidget::setContextMenuIcon(const QIcon &icon) {
	if (contextMenu)
		contextMenu->setHeaderIcon(icon);
}

void TreeWidget::addContextMenuAction(QAction *newAction) {
	if (contextMenu)
		contextMenu->addAction(newAction);
}

void TreeWidget::addContextMenuSeparator() {
	if (contextMenu)
		contextMenu->addSeparator();
}

void TreeWidget::contextMenuEvent(QContextMenuEvent *event) {
	if (!contextMenuEnabled)
		return;
	emit(contextMenuEventSignal());
	if (itemAt(event->x(),event->y())) {
		contextMenu->move(event->globalX(),event->globalY());
		contextMenu->show();
	}
}
