/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  Brent Schartung <bschartung@gmail.com>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Dorando <mozilla@dorando.at>
 *  HJ van Rantwijk <bugs4HJ@netscape.net>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Martin.T.Kutschker <Martin.T.Kutschker@blackbox.net>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Pekka Aleksi Knuutila <aleksi.knuutila@edu.lahti.fi>
 *  Scott R. Turner <srt@aero.org>
 *  Tim Williamson <chsman@hotmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//----------------------
//-- Global variables --
//----------------------
var mgStatusPopup;
var mgPopup = null;
var mgContent = null;
var mgString; //array holding localized stroke names
var gestureInProgress = false;
var globalOnLink = false; //array that holds a list of all the links traversed during gesture
var globalOnImage = false; //string containing an image href or false
var globalSrcEvent = false; //event which started the active gesture.

var mgState = {
  inputField : null,
  currentNode : null,
  gestureStartTime : 0,
  gestureDone : false,
  previousSelection : null,
  oX : 0, oY : 0,
  gridMoves : new Array(),
  gesture : new Array(),
  localizedGesture : new Array(),
  lastGestureTime : 0,
  lastMoveTime : 0,
  gestureTimeout : null,
  statusTimer : null,
  allowContext : false,
  history : new Array(),
  rockerCode : "",
  linkTemp : null,
  lastError : ""
};

var mgObserver = {
  mgPrefTimeout    : null,
  mgRockerInterval : null,
  obs              : Components.classes["@mozilla.org/observer-service;1"]
                     .getService(Components.interfaces.nsIObserverService),

  createEvt : function(what, data) {
    var mData = data.split("|");
    var evt = document.createEvent("MouseEvents");
    evt.initMouseEvent(what, 1, 1, window, 1,
                       mData[1], mData[2], 0, 0, 0, 0, 0, 0, mData[0], window);

    return evt;
  },

  observe : function(subject, topic, data) {
    /*when MozGest pref was changed, we reinitialize
     (except when sidebar settings changed)
     use a timeout to avoid multiple inits if more than
     one pref was changed. Not bullet proof. */
    if (topic.indexOf("nsPref") == 0) {
      if (data.indexOf("sideBar") == 0 || data == "selectedTabIndex" ||
          data == "importFrom" || data == "firstStart")
        return;

      clearTimeout(mgObserver.mgPrefTimeout);
      mgObserver.mgPrefTimeout = setTimeout(mozgestInit, 200);
    }

    if (topic == "domwindowopened")
      mgResetRocker(true);

    if (topic == "mozgestButtonUp") {
      mgObserver.mgClearInterval();

      if (mgCommon.winWatcher.activeWindow != window) {
        mgResetRocker(true);
        return;
      }

      try {
        mgEndGesture(this.createEvt("mouseup", data), true);
        gestureInProgress = false;
      }
      catch (e) {}
    }

    if (mgCommon.winWatcher.activeWindow != window)
      return;

    if (topic == "mozgestButtonDown") {
      mgObserver.mgClearInterval();
      try {
        if (navigator.platform != "Win32" && mgMouseInContent(this.createEvt("mousedown", data)))
          mgPopup.hidePopup();
      }
      catch (e) {}
    }

    if (topic == "mozgestRockerDown") {
      mgObserver.mgClearInterval();
      gestureInProgress = false;

      try {
        var evt = this.createEvt("mousedown", data);
        setTimeout(mgStartGesture, 0, evt);

        if (mgPrefs.staticRockers)
          mgObserver.mgSetInterval(evt);
      }
      catch (e) {}
    }

    if (topic == "mozgestGetBaseWin")
      mgMouseService.setBaseWin(mgGetBaseWin());
  },

  register : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .addObserver("", this, false);

    mgCommon.winWatcher.registerNotification(this);

    if (mgMouseEvents) {
      this.obs.addObserver(this, "mozgestGetBaseWin", false);
      this.obs.addObserver(this, "mozgestRockerDown", false);
      this.obs.addObserver(this, "mozgestButtonUp", false);
      this.obs.addObserver(this, "mozgestButtonDown", false);
    }
  },

  unregister : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .removeObserver("", this);

    mgCommon.winWatcher.unregisterNotification(this);

    if (mgMouseEvents) {
      this.obs.removeObserver(this, "mozgestGetBaseWin");
      this.obs.removeObserver(this, "mozgestRockerDown");
      this.obs.removeObserver(this, "mozgestButtonUp");
      this.obs.removeObserver(this, "mozgestButtonDown");
    }
  },

  mgSetInterval : function(e, wheelCode) {
    mgObserver.mgClearInterval();

    if (e) {
      mgObserver.mgRockerInterval = setInterval(mgStartGesture, mgPrefs.staticRockersDelay, e);
    }
    else if (wheelCode) {
      mgObserver.mgRockerInterval = setInterval(mgFireRocker, mgPrefs.staticRockersDelay, wheelCode);
    }
  },

  mgClearInterval : function() {
    clearInterval(mgObserver.mgRockerInterval);
    mgObserver.mgRockerInterval = null;
  }
}

//--------------------------------
//-- Startup/shutdown functions --
//--------------------------------
function mgStartup(e) {
  window.removeEventListener("load", mgStartup, false);
  document.loadOverlay("chrome://mozgest/content/contextOverlay.xul", null);
  mgInitNotification();

  //this comes from windowTypes.js
  mgWindowTypes.init();
  mgWindowType = mgWindowTypes.getWindowType(document.location);

  if (mgWindowType) {
    mgCommon.dump("Startup");
    mgLoadStrings();
    mozgestInit();
    mgObserver.register();
    window.addEventListener("unload", function () {mgObserver.unregister()}, false);
  }
}

function mozgestInit() {
  mgPrefs.init();
  mgComponentLoader.initMouseService(true);

  //turn gestures recognition on/off
  if (mgPrefs.get(mgWindowType))
    mgAddWindowWatch();
  else
    mgRemoveWindowWatch();

  try {
    mgPrefs.prefs.getBoolPref("firstStart");
  }
  catch (e) {
    mgPrefs.prefs.setBoolPref("firstStart", true);
    mgPrefs.prefs.setIntPref("selectedTabIndex", 3);
    setTimeout("openDialog('chrome://mozgest/content/pref/pref-mozgest.xul','','chrome,resizable,centerscreen')", 500);
  }
}

function mgLoadStrings() {
  //load localized strings and cache often used strings
  mgString = new Array();
  mgString["R"] = mgGetString("a.right");
  mgString["L"] = mgGetString("a.left");
  mgString["U"] = mgGetString("a.up");
  mgString["D"] = mgGetString("a.down");
  mgString["1"] = mgGetString("a.d1");
  mgString["3"] = mgGetString("a.d3");
  mgString["7"] = mgGetString("a.d7");
  mgString["9"] = mgGetString("a.d9");
  mgString["gesture"] = mgGetString("g.gesture");
}

function mgAddWindowWatch() {
  mgCommon.dump("Get Contentarea");

  if (document.documentElement.getAttribute("windowtype") == "navigator:browser")
    mgContent = mgGetContentArea().mPanelContainer;
  else
    mgContent = mgGetContentArea();

  mgRemoveWindowWatch();
  mgCommon.dump("Adding Listeners");

  mgContent.addEventListener("mousedown", mgStartGesture, true);
  mgContent.addEventListener("draggesture", mgOnDragGestureEvent, true);

  if (mgPrefs.enableWheelRockers)
    mgContent.addEventListener("DOMMouseScroll", mgMousewheelHandler, true);

  window.addEventListener("mouseup", mgEndGesture, true);
  window.addEventListener("keydown", mgAllowContextByKeyPress, true);
  window.addEventListener("mousemove", mgProcessCoordinates, true);
  window.addEventListener("popupshowing", mgPopupListener, true);
  mgContent.addEventListener("contextmenu", mgContextMenuListener, true);
  mgContent.addEventListener("click", mgOnClickHandler, true);
  mgContent.addEventListener("dblclick", mgOnClickHandler, true);
}

function mgRemoveWindowWatch() {
  mgCommon.dump("Removing Listeners");
  mgContent.removeEventListener("mousedown", mgStartGesture, true);
  mgContent.removeEventListener("draggesture", mgOnDragGestureEvent, true);
  mgContent.removeEventListener("DOMMouseScroll", mgMousewheelHandler, true);
  mgContent.removeEventListener("contextmenu", mgContextMenuListener, true);
  window.removeEventListener("mouseup", mgEndGesture, true);
  window.removeEventListener("keydown", mgAllowContextByKeyPress, true);
  window.removeEventListener("mousemove", mgProcessCoordinates, true);
  window.removeEventListener("popupshowing", mgPopupListener, true);
  mgContent.removeEventListener("click", mgOnClickHandler, true);
  mgContent.removeEventListener("dblclick", mgOnClickHandler, true);
}

function mgInitNotification() {
  if (!document.getElementById("mgStatusPopup")) {
    var mgSet = document.createElement("popupset");
    mgStatusPopup = document.createElement("tooltip");
    mgStatusPopup.id = "mgStatusPopup";
    mgStatusPopup.setAttribute("onpopupshown", "this.mgOpen=true");
    mgStatusPopup.setAttribute("onpopuphidden", "this.mgOpen=false;this.hidden=true;setTimeout('mgStatusPopup.hidden=false',0)");
    mgStatusPopup.setAttribute("onmouseover", "if (!gestureInProgress) this.hidePopup()");
    var mgStatusLabel = document.createElement("label");
    mgStatusLabel.id = "mgStatusLabel";
    mgStatusLabel.setAttribute("crop", "end");
    mgStatusLabel.setAttribute("flex", "1");
    mgStatusPopup.appendChild(mgStatusLabel);
    mgSet.appendChild(mgStatusPopup);
    document.documentElement.appendChild(mgSet);
    window.addEventListener("blur", function () {
                                     if (mgPrefs["status.isEnabled"])
                                       mgStatusPopup.hidePopup()
                                    }, true);
  }
}

//-----------------------
//-- Integration hooks --
//-- everything needed for co-existing with or disabling regular app functions
//-----------------------
function mgContextMenuListener(e) {
  if (mgAppInfo.platform == "Windows" || mgAppInfo.geckoShortVersion > 1.8) {
    if (!mgState.allowContext) {
      e.preventDefault();
      e.stopPropagation();
    }
  }
  else {
    addEventListener("popupshowing", mgDisableContextMenu, true);
    setTimeout("removeEventListener('popupshowing', mgDisableContextMenu, true)", 5);
  }
}

function mgDisableContextMenu(e) {
  mgPopup = e.originalTarget;

  if (!mgState.allowContext)
    e.preventDefault();
}

function mgAllowContextByKeyPress(e) {
  if (!gestureInProgress) {
    mgState.allowContext = true;
    mgState.gestureDone = false;
  }
}

function mgPopupListener(e) {
  if (e.originalTarget.nodeName.indexOf("tooltip") != -1)
    return;

  mgPopup = e.originalTarget;
  if (e.target.id == "autoscroller") {
    if (!e.target.hasAttribute("mozgestWasHere")) {
      e.target.addEventListener("mousedown", function(e) {mgStartGesture(e, true)}, true);
      e.target.setAttribute("mozgestWasHere", true);
    }
  }
}

function mgOnClickHandler(e) {
  if (mgState.gestureDone) {
    mgCommon.dump("Stopping " + e.type + " event caused by last gesture");
    e.preventDefault();
    e.stopPropagation();
    return false;
  }

  if (e.button < 2) {
    var node = e.originalTarget;

    if (node.localName.toLowerCase() != "a")
      return null;

    if (!node.getAttribute || !node.hasAttribute("href"))
      return null;

    var href = node.getAttribute("href");

    if (href.indexOf("mozgest://") == 0) {
      mgCommon.dump("Link click " + href);
      mgStorage.processURL(href, node.ownerDocument.location);
      e.stopPropagation();
      e.preventDefault();
    }
  }
  return null;
}

function mgOnDragGestureEvent(e) {
  if (gestureInProgress) {
    e.preventDefault();
    e.stopPropagation();
  }
}

//---------------------------------
//-- The gesture recognizer core --
//---------------------------------
function mgProcessCoordinates(e) {
  if (mgState.rockerCode.length > 1 &&
      (e.screenX < mgState.oX -25 || e.screenX > mgState.oX +25 ||
       e.screenY < mgState.oY -25 || e.screenY > mgState.oY +25))
    mgResetRocker(true);

  if (!mgPrefs.enableStrokes || !gestureInProgress)
    return;

  var now = (new Date).getTime();

  if (mgState.gesture.length < 1) {
    if (mgPrefs.mousebutton == 1 && (e.screenX != mgState.oX || e.screenY != mgState.oY)) {
      if (mgStopAutoScroll())
        return;
    }
  }

  var x_dir = e.screenX - mgState.oX;
  var y_dir = e.screenY - mgState.oY;
  var x = Math.abs(x_dir);
  var y = Math.abs(y_dir);

  if (x >= mgPrefs.grid/2 || y >= mgPrefs.grid/2) { // process each half-grid
    //diagonal movement:
    //mgPrefs.diagonalTolerance = 75 means that a movement is recognized as diagonal when
    //x/y or y/x is between 0.25 and 1
    if ( mgPrefs.diagonalTolerance != 0 && ( (x/y >= (1-mgPrefs.diagonalTolerance/100) && x/y <= 1)
        || (y/x >= (1-mgPrefs.diagonalTolerance/100) && y/x <= 1) ) ) {

      if (x_dir < 0 && y_dir > 0)
        mgPush("1");
      else if (x_dir > 0 && y_dir > 0)
        mgPush("3");
      else if (x_dir < 0 && y_dir < 0)
        mgPush("7");
      else if (x_dir > 0 && y_dir < 0)
        mgPush("9");
    }
    //horizontal move:
    else if (x > y) {
      if (x_dir > 0)
        mgPush("R");
      else if (x_dir < 0)
        mgPush("L");
    }
    //vertical move:
    else if (x < y) {
      if (y_dir > 0)
        mgPush("D");
      else if (y_dir < 0)
        mgPush("U");
    }

    mgState.lastGestureTime = now;
    clearTimeout(mgState.gestureTimeout);
    mgState.gestureTimeout = setTimeout("mgEndGesture(null);", mgPrefs.delay);
    mgState.oX = e.screenX;
    mgState.oY = e.screenY;
  }
  mgState.lastMoveTime = now;

  if (mgState.currentNode != e.originalTarget)
    mgExamineHoveredElement(e.originalTarget);

  mgState.currentNode = e.originalTarget;
}

function mgPush(code) {
  mgState.gridMoves.push(code);
  if (mgState.gridMoves.length == 2) {
    if (mgState.gridMoves[0] == mgState.gridMoves[1] || mgState.gesture.length == 0)
      mgDoPush(mgState.gridMoves.pop());

    mgState.gridMoves.length = 0;
  }
}

function mgDoPush(code) {
  if (mgState.gesture[mgState.gesture.length-1] != code) {
    mgState.gesture.push(code);
    mgState.localizedGesture.push(mgString[code]);
    mgShowStatus(mgState.gesture.join(""));
  }
}

function mgExamineHoveredElement(node, inContentCheck) {
  var imgNode = node;
  var CI = Components.interfaces;

  if (inContentCheck) {
    if (mgMouseEvents && mgState.rockerCode.length > 1)
      return true;

    globalOnLink = globalOnImage = false;
    var checkNode = node;

    for (checkNode; checkNode; checkNode = checkNode.parentNode) {
      var n = checkNode.nodeName.toLowerCase();

      if (n == "scrollbar" || n == "object" || n == "embed")
        return false;
    }
  }

  for (node; node; node = node.parentNode) {
    if (node instanceof CI.nsIDOMHTMLAnchorElement ||
        node instanceof CI.nsIDOMHTMLAreaElement ||
        node instanceof CI.nsIDOMHTMLLinkElement) {

      if (!globalOnLink) {
        globalOnLink = new Array();
        mgState.linkTemp = new Array();
      }

      if (!(node.href in mgState.linkTemp)) {
        mgState.linkTemp[node.href] = node.href;
        globalOnLink.push(node);
      }
      break;
    }
  }

  for (imgNode; imgNode; imgNode = imgNode.parentNode) {
    if (!globalOnImage && imgNode instanceof CI.nsIDOMHTMLImageElement) {
      globalOnImage = imgNode;
      break;
    }
  }
  return true;
}

function mgStartGesture(e, isPopup) {
  mgReleaseRocker(e);
  mgState.allowContext = false;
  mgState.gestureDone = false;
  mgState.oX = e.screenX;
  mgState.oY = e.screenY;

  if (mgExamineHoveredElement(e.originalTarget, true) && !mgCheckForRocker(e) && !isPopup) {
    globalSrcEvent = e;
    mgState.currentNode = e.originalTarget;

    if (!gestureInProgress && mgPrefs.enableStrokes && eval(mgPrefs.gestureCondition)) {
      // check if it's possible to draw trails
      if (mgNativeTrails && mgPrefs["trails.enabled"])
        mgMouseService.initTrails(mgGetBaseWin());

      gestureInProgress = true;
      mgState.gestureStartTime = mgState.lastGestureTime = (new Date).getTime();
      mgState.lastMoveTime = mgState.gesture.length = mgState.localizedGesture.length = 0;;

      if (mgPrefs.mousebutton == 0) {
        mgState.inputField = null;
        var nodeName = globalSrcEvent.target.nodeName.toLowerCase();

        if (nodeName == "input" || nodeName == "textarea") {
          mgState.inputField = globalSrcEvent.target;
          mgState.selStart = mgState.inputField.selectionStart;
          mgState.selEnd = mgState.inputField.selectionEnd;
        }

        mgState.previousSelection = null;
        var sel = mgGetSelection();

        if (sel && sel.rangeCount > 0)
          mgState.previousSelection = sel.getRangeAt(0);

        mgState.gestureTimeout = setTimeout("mgEndGesture(null);", mgPrefs.lmbGestureLimit);
      }
    }
  }
}

function mgEndGesture(e, synth) {
  mgReleaseRocker(e);
  clearTimeout(mgState.statusTimer);
  clearTimeout(mgState.gestureTimeout);

  if (gestureInProgress) {
    gestureInProgress = false;
    mgState.gestureStartTime = false;

    if (mgNativeTrails)
      mgMouseService.stopTrails();

    mgState.gestureDone = (mgState.gesture.join("") != "") ? true : false;

    if (e == null) {
      if (mgState.gestureDone)
        mgShowStatus(null, mgGetString("g.aborted"));
    }
    else if (mgState.gestureDone)
      setTimeout(mgFireGesture, 0, mgState.gesture.join(""));
  }

  if (mgPrefs["status.isEnabled"])
    mgState.statusTimer = setTimeout("mgStatusPopup.hidePopup();", mgPrefs["status.timeout"]);

  if (!synth && e && !mgState.gestureDone && (e.button == 2 ||
      (navigator.platform.indexOf("Mac") == 0 && e.button == 0 && e.ctrlKey))) {
    mgState.allowContext = true;

    //contextmenu on mousedown
    if (navigator.platform != "Win32") {
      if (e.originalTarget.ownerDocument && e.originalTarget.ownerDocument == document)
        return;

      if (mgMouseInContent(e)) {
        document.popupNode = e.target;
        document.mozgestPopupRangeParent = e.rangeParent;
        document.mozgestPopupRangeOffset = e.rangeOffset;

        if (mgAppInfo.geckoShortVersion > 1.8) {
          var ev = e.view.document.createEvent ('MouseEvents');
          ev.initMouseEvent('contextmenu', true, true, e.view, 1, e.screenX, e.screenY,
                            e.pageX, e.pageY, 0, 0, 0, 0, 2, null);

          try {
            e.originalTarget.dispatchEvent(ev);
          }
          catch (err) {
            e.target.dispatchEvent(ev);
          }

          if ("gContextMenu" in window) {
            try {
              gContextMenu.setTarget(document.popupNode, e.rangeParent, e.rangeOffset);
              gContextMenu.initItems();
            }
            catch (err) {}
          }
          return;
        }

        var mgPopupBox = mgPopup.boxObject.QueryInterface(Components.interfaces.nsIPopupBoxObject);
        document.popupNode = e.originalTarget;

        try {
          mgPopupBox.showPopup(mgPopup.ownerDocument.documentElement, mgPopup,
                               e.clientX, e.clientY, "context", "bottomleft", "topleft");
        }
        catch (err) {}
      }
    }
  }
}

function mgMouseInContent(e) {
  var ctBox = mgContent.boxObject;

  if (e.screenY >= ctBox.screenY &&
      e.screenY <= ctBox.screenY + ctBox.height &&
      e.screenX >= ctBox.screenX &&
      e.screenX <= ctBox.screenX + ctBox.width)
    return true;
  else
    return false;
}

function mgGetBaseWin() {
  var mgDocShell = mgGetContentArea().docShell;
  return mgDocShell.QueryInterface(Components.interfaces.nsIBaseWindow);
}

function mgShowStatus(code, errorMSG) {
  if (mgPrefs["status.isEnabled"]) {
    clearTimeout(mgState.statusTimer);
    var statusText;

    if (!errorMSG) {
      statusText = mgString["gesture"] + " " +
                   ((code.toString().indexOf(":") == 0) ? code : mgState.localizedGesture);
      var nameTemp = mgGetMapping(code)[1];

      if (nameTemp)
        statusText += " (" + nameTemp + ")";
    }
    else
      statusText = errorMSG;

    mgStatusPopup.firstChild.setAttribute("value", statusText);

    var isOpen = false;

    if (mgStatusPopup.boxObject.popupState) {
      if (mgStatusPopup.boxObject.popupState == "open")
        isOpen = true;
    }
    else if (mgStatusPopup.mgOpen)
      isOpen = true;

    if (!isOpen) {
      var width = 500;

      try {
        width = parseInt(document.defaultView.getComputedStyle(mgStatusPopup, null).getPropertyValue("max-width"));
      }
      catch (e) {}

      var elt = mgPrefs["status.anchorElement"];
      elt = eval(elt);

      if (!elt)
        elt = document.documentElement;

      var box = elt.boxObject;

      switch(mgPrefs["status.align"]) {
        case 0: //topLeft
          mgStatusPopup.showPopup(elt, -1 , -1, "tooltip", "topleft", "bottomleft");
          break;
        case 1: //topRight
          mgStatusPopup.showPopup(elt, -1 , -1, "tooltip", "topright", "bottomright");
          break;
        case 2: //bottomLeft
          mgStatusPopup.showPopup(elt, box.screenX, box.screenY + box.height, "tooltip", null, null);
          break;
        case 3: //bottomRight
          mgStatusPopup.showPopup(elt, box.screenX + box.width - width, box.screenY + box.height, "tooltip", null, null);
          break;
      }
    }
    if (errorMSG)
      mgState.statusTimer = setTimeout("mgStatusPopup.hidePopup();", mgPrefs["status.timeout"]);
  }
}

function mgGetMapping(code) {
  var aM = _mgMS.activeMappings;
  var mapping = false;
  var name = false;

  if (code in aM[mgWindowType])
    mapping = aM[mgWindowType][code];
  else if (code in aM["window"])
    mapping = aM["window"][code];

  if (mapping) {
    if (mapping.name)
      name = decodeURIComponent(mapping.name);
    else
      name = mgGetString(mapping.func);
  }

  return [mapping, name];
}

//--------------------
//-- Ugly Overrides --
//--------------------
function openEditorContextMenu (popup) {
  InlineSpellCheckerUI.clearSuggestionsFromMenu();
  InlineSpellCheckerUI.initFromEvent((document.mozgestPopupRangeParent) ? document.mozgestPopupRangeParent : document.popupRangeParent,
                                     (document.mozgestPopupRangeOffset) ? document.mozgestPopupRangeOffset : document.popupRangeOffset);
  var onMisspelling = InlineSpellCheckerUI.overMisspelling;
  document.getElementById('spellCheckSuggestionsSeparator').hidden = !onMisspelling;
  document.getElementById('spellCheckAddToDictionary').hidden = !onMisspelling;
  document.getElementById('spellCheckIgnoreWord').hidden = !onMisspelling;
  var separator = document.getElementById('spellCheckAddSep');
  separator.hidden = !onMisspelling;
  document.getElementById('spellCheckNoSuggestions').hidden = !onMisspelling ||
      InlineSpellCheckerUI.addSuggestionsToMenu(popup, separator, 5);

  updateEditItems();
}