use ExtUtils::MakeMaker;
#
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
#
# If any modules outside of the core perl distribution are required,
# these should be included as a PREREQ_PM entry in WriteMakefile below, 
# as indicated in the example. This example requires the modules 
# MOD1 and MOD2 to be installed, with minimal versions 1 and 5,
# respectively. If the version number is 0, any version is sufficient.
#
# As well, if you wish to force a minimal perl version to run the
# script, insert a line, for example,
#
#   require 5.004;
#
# below.

my %opts = (
    'NAME'	=> 'mp3cd',
    'VERSION_FROM' => 'scripts/mp3cd', # finds $VERSION
    'EXE_FILES' => [ qw( scripts/mp3cd ) ], # scripts to install
    'PREREQ_PM' => {
			'Getopt::Long' => 0,
			'Pod::Usage' => 0,
			'File::Path' => 0,
			'Config::Simple' => 0,
			'Cwd' => 0,
		},
    'PREREQ_FATAL' => 1,
);

if ($ExtUtils::MakeMaker::VERSION >= 5.43) {
    $opts{AUTHOR}   = 'Kees Cook <kees@outflux.net>';
    $opts{ABSTRACT_FROM} = 'scripts/mp3cd';
}

WriteMakefile( %opts )
