/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Stack;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.EventListenerList;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTimePanel;
import viewer.zoomable.TimeEvent;
import viewer.zoomable.TimeListener;

public class ModelTime
extends DefaultBoundedRangeModel
implements AdjustmentListener {
    private static final long serialVersionUID = 3500L;
    private int MAX_SCROLLBAR_PIXELS = 0x40000000;
    private double tGlobal_min;
    private double tGlobal_max;
    private double tGlobal_extent;
    private double tView_init;
    private double tView_extent;
    private double old_tView_init;
    private double tZoom_focus;
    private int iView_width = -1;
    private double iViewPerTime;
    private double iScrollbarPerTime;
    private double tZoomScale = 1.0;
    private double tZoomFactor;
    private double logZoomFactor;
    private ModelTimePanel params_display = null;
    private EventListenerList time_listener_list = new EventListenerList();
    private TimeEvent time_chg_evt = null;
    private Window root_window;
    private JScrollBar scrollbar;
    private Stack zoom_undo_stack = new Stack();
    private Stack zoom_redo_stack = new Stack();
    static /* synthetic */ Class class$viewer$zoomable$TimeListener;

    public ModelTime(Window window, double d, double d2) {
        this.root_window = window;
        this.setTimeGlobalMinimum(d);
        this.setTimeGlobalMaximum(d2);
        this.setTimeZoomFocus();
        this.tZoomFactor = 2.0;
        this.logZoomFactor = Math.log(this.tZoomFactor);
    }

    private void setTimeGlobalMinimum(double d) {
        this.old_tView_init = this.tGlobal_min = d;
        this.tView_init = this.tGlobal_min;
    }

    private void setTimeGlobalMaximum(double d) {
        this.tGlobal_max = d;
        this.tView_extent = this.tGlobal_extent = this.tGlobal_max - this.tGlobal_min;
        this.iScrollbarPerTime = (double)this.MAX_SCROLLBAR_PIXELS / this.tGlobal_extent;
    }

    private void setTimeViewPosition(double d) {
        this.old_tView_init = this.tView_init;
        this.tView_init = d < this.tGlobal_min ? this.tGlobal_min : (d > this.tGlobal_max - this.tView_extent ? this.tGlobal_max - this.tView_extent : d);
    }

    private void setTimeViewExtent(double d) {
        if (d < this.tGlobal_extent) {
            this.tView_extent = d;
            if (this.tView_init > this.tGlobal_max - this.tView_extent) {
                this.old_tView_init = this.tView_init;
                this.tView_init = this.tGlobal_max - this.tView_extent;
            }
        } else {
            this.tView_extent = this.tGlobal_extent;
            this.old_tView_init = this.tView_init;
            this.tView_init = this.tGlobal_min;
        }
    }

    public double getTimeGlobalMinimum() {
        return this.tGlobal_min;
    }

    public double getTimeGlobalMaximum() {
        return this.tGlobal_max;
    }

    public double getTimeViewPosition() {
        return this.tView_init;
    }

    public double getTimeViewExtent() {
        return this.tView_extent;
    }

    public void setViewPixelsPerUnitTime(int n) {
        this.iView_width = n;
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
    }

    public double getViewPixelsPerUnitTime() {
        return this.iViewPerTime;
    }

    public double computeTimeViewExtent(double d) {
        return (double)this.iView_width * d;
    }

    public int getViewportMovingDir() {
        double d = this.tView_init - this.old_tView_init;
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public void setScrollBar(JScrollBar jScrollBar) {
        this.scrollbar = jScrollBar;
    }

    public void removeScrollBar() {
        this.scrollbar = null;
    }

    public void setParamDisplay(ModelTimePanel modelTimePanel) {
        this.params_display = modelTimePanel;
    }

    public void removeParamDisplay(ModelTimePanel modelTimePanel) {
        this.params_display = null;
    }

    private void updateParamDisplay() {
        if (this.params_display != null) {
            if (this.time_chg_evt == null) {
                this.time_chg_evt = new TimeEvent(this);
            }
            this.params_display.timeChanged(this.time_chg_evt);
            this.params_display.zoomLevelChanged();
        }
    }

    public void addTimeListener(TimeListener timeListener) {
        this.time_listener_list.add(class$viewer$zoomable$TimeListener == null ? (class$viewer$zoomable$TimeListener = ModelTime.class$("viewer.zoomable.TimeListener")) : class$viewer$zoomable$TimeListener, timeListener);
    }

    public void removeTimeListener(TimeListener timeListener) {
        this.time_listener_list.remove(class$viewer$zoomable$TimeListener == null ? (class$viewer$zoomable$TimeListener = ModelTime.class$("viewer.zoomable.TimeListener")) : class$viewer$zoomable$TimeListener, timeListener);
    }

    protected void fireTimeChanged() {
        Object[] objectArray = this.time_listener_list.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$viewer$zoomable$TimeListener == null ? ModelTime.class$("viewer.zoomable.TimeListener") : class$viewer$zoomable$TimeListener)) continue;
            if (this.time_chg_evt == null) {
                this.time_chg_evt = new TimeEvent(this);
            }
            ((TimeListener)objectArray[i + 1]).timeChanged(this.time_chg_evt);
        }
    }

    private int time2pixel(double d) {
        return (int)Math.round((d - this.tGlobal_min) * this.iScrollbarPerTime);
    }

    private double pixel2time(int n) {
        return (double)n / this.iScrollbarPerTime + this.tGlobal_min;
    }

    private int timeRange2pixelRange(double d) {
        return (int)Math.round(d * this.iScrollbarPerTime);
    }

    private double pixelRange2timeRange(int n) {
        return (double)n / this.iScrollbarPerTime;
    }

    public void updatePixelCoords() {
        super.setRangeProperties(this.time2pixel(this.tView_init), this.timeRange2pixelRange(this.tView_extent), this.time2pixel(this.tGlobal_min), this.time2pixel(this.tGlobal_max), super.getValueIsAdjusting());
    }

    public void updateTimeCoords() {
        if (this.iScrollbarPerTime > 0.0) {
            this.tGlobal_min = this.pixel2time(super.getMinimum());
            this.tGlobal_max = this.pixel2time(super.getMaximum());
            this.tGlobal_extent = this.tGlobal_max - this.tGlobal_min;
            this.old_tView_init = this.tView_init;
            this.tView_init = this.pixel2time(super.getValue());
            this.tView_extent = this.pixelRange2timeRange(super.getExtent());
            this.updateParamDisplay();
        }
    }

    public void setTimeZoomFactor(double d) {
        this.tZoomFactor = d;
        this.logZoomFactor = Math.log(this.tZoomFactor);
    }

    public double getTimeZoomFactor() {
        return this.tZoomFactor;
    }

    public void setTimeZoomFocus() {
        this.tZoom_focus = this.tView_init + this.tView_extent / 2.0;
    }

    public void setTimeZoomFocus(double d) {
        this.tZoom_focus = d;
        this.updateParamDisplay();
    }

    public double getTimeZoomFocus() {
        return this.tZoom_focus;
    }

    public int getZoomLevel() {
        return (int)Math.round(Math.log(this.tZoomScale) / this.logZoomFactor);
    }

    private void setScrollBarIncrements() {
        if (this.scrollbar != null) {
            int n = super.getExtent();
            if (n <= 0) {
                Dialogs.error(this.root_window, "You have reached the Zoom limit! Time ScrollBar has 0 BLOCK Increment. Zoom out or risk crashing the viewer.");
                n = 0;
            }
            this.scrollbar.setBlockIncrement(n);
            int n2 = this.timeRange2pixelRange(this.tView_extent * (double)Parameters.TIME_SCROLL_UNIT_RATIO);
            if (n2 <= 0) {
                Dialogs.error(this.root_window, "You have reached the Zoom limit! Time ScrollBar has 0 UNIT Increment. Zoom out or risk crashing the viewer.");
                n2 = 0;
            }
            this.scrollbar.setUnitIncrement(n2);
        }
    }

    public void scroll(double d) {
        this.setTimeViewPosition(this.tView_init + d);
        this.updatePixelCoords();
    }

    public void scroll(int n) {
        double d = (double)n / this.iViewPerTime;
        this.scroll(d);
    }

    public void scroll(int n, boolean bl) {
        this.old_tView_init = this.tView_init;
        double d = (double)n / this.iViewPerTime;
        int n2 = this.timeRange2pixelRange(d);
        super.setRangeProperties(super.getValue() + n2, super.getExtent(), super.getMinimum(), super.getMaximum(), bl);
        this.tView_init = this.pixel2time(super.getValue());
        this.updateParamDisplay();
    }

    public void zoomHome() {
        this.tZoomScale = 1.0;
        this.setTimeViewExtent(this.tGlobal_extent);
        this.setTimeViewPosition(this.tGlobal_min);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
        this.zoom_undo_stack.clear();
        this.zoom_redo_stack.clear();
    }

    private void updateZoomStack(Stack stack) {
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox();
        timeBoundingBox.setEarliestTime(this.tView_init);
        timeBoundingBox.setLatestFromEarliest(this.tView_extent);
        stack.push(timeBoundingBox);
    }

    public void zoomIn() {
        this.updateZoomStack(this.zoom_undo_stack);
        this.tZoomScale *= this.tZoomFactor;
        double d = this.tView_init < this.tZoom_focus && this.tZoom_focus < this.tView_init + this.tView_extent ? this.tZoom_focus : this.tView_init + this.tView_extent / 2.0;
        double d2 = (d - this.tView_init) / this.tView_extent;
        this.setTimeViewExtent(this.tView_extent / this.tZoomFactor);
        this.setTimeViewPosition(d - this.tView_extent * d2);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    public void zoomOut() {
        this.updateZoomStack(this.zoom_undo_stack);
        this.tZoomScale /= this.tZoomFactor;
        double d = this.tView_init < this.tZoom_focus && this.tZoom_focus < this.tView_init + this.tView_extent ? this.tZoom_focus : this.tView_init + this.tView_extent / 2.0;
        double d2 = (d - this.tView_init) / this.tView_extent;
        this.setTimeViewExtent(this.tView_extent * this.tZoomFactor);
        this.setTimeViewPosition(d - this.tView_extent * d2);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    public void zoomRapidly(double d, double d2) {
        double d3 = this.tView_extent / d2;
        this.updateZoomStack(this.zoom_undo_stack);
        this.tZoomScale *= d3;
        this.setTimeViewExtent(d2);
        this.setTimeViewPosition(d);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    private void zoomBack(double d, double d2) {
        double d3 = this.tView_extent / d2;
        this.tZoomScale *= d3;
        this.setTimeViewExtent(d2);
        this.setTimeViewPosition(d);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    public void zoomUndo() {
        if (!this.zoom_undo_stack.empty()) {
            this.updateZoomStack(this.zoom_redo_stack);
            TimeBoundingBox timeBoundingBox = (TimeBoundingBox)this.zoom_undo_stack.pop();
            this.zoomBack(timeBoundingBox.getEarliestTime(), timeBoundingBox.getDuration());
            timeBoundingBox = null;
        }
    }

    public void zoomRedo() {
        if (!this.zoom_redo_stack.empty()) {
            this.updateZoomStack(this.zoom_undo_stack);
            TimeBoundingBox timeBoundingBox = (TimeBoundingBox)this.zoom_redo_stack.pop();
            this.zoomBack(timeBoundingBox.getEarliestTime(), timeBoundingBox.getDuration());
            timeBoundingBox = null;
        }
    }

    public boolean isZoomUndoStackEmpty() {
        return this.zoom_undo_stack.empty();
    }

    public boolean isZoomRedoStackEmpty() {
        return this.zoom_redo_stack.empty();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (Debug.isActive()) {
            Debug.println("ModelTime: AdjustmentValueChanged()'s START: ");
            Debug.println("adj_evt = " + adjustmentEvent);
        }
        if (Debug.isActive()) {
            Debug.println("ModelTime(before) = " + this.toString());
        }
        this.updateTimeCoords();
        if (Debug.isActive()) {
            Debug.println("ModelTime(after) = " + this.toString());
        }
        this.fireTimeChanged();
        if (Debug.isActive()) {
            Debug.println("ModelTime: AdjustmentValueChanged()'s END: ");
        }
    }

    public String toString() {
        String string = super.toString() + ",  " + "tGlobal_min=" + this.tGlobal_min + ", " + "tGlobal_max=" + this.tGlobal_max + ", " + "tView_init=" + this.tView_init + ", " + "tView_extent=" + this.tView_extent + ", " + "iView_width=" + this.iView_width + ", " + "iViewPerTime=" + this.iViewPerTime + ", " + "iScrollbarPerTime=" + this.iScrollbarPerTime;
        return this.getClass().getName() + "{" + string + "}";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

