/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class Event {
    private static int Base_Half_Width = 6;
    private static int Base_Width = 3;
    private static double Max_LineSeg2Pt_DistSQ = 10.0;

    public static void setBaseWidth(int n) {
        Base_Half_Width = n / 2;
        if (Base_Half_Width < 0) {
            Base_Half_Width = 0;
        }
        Base_Width = Base_Half_Width + Base_Half_Width;
    }

    public static void setPixelClosenessTolerance(int n) {
        Max_LineSeg2Pt_DistSQ = n * n + 1;
    }

    public static int draw(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, DrawnBox drawnBox, double d, float f, float f2, float f3) {
        boolean bl;
        int n = coordPixelXform.convertTimeToPixel(d);
        if (drawnBox.coversEvent(n)) {
            return 0;
        }
        drawnBox.set(n);
        boolean bl2 = bl = n > 0 && n < coordPixelXform.getImageWidth();
        if (!bl) {
            return 0;
        }
        int n2 = coordPixelXform.convertRowToPixel(f);
        int n3 = coordPixelXform.convertRowToPixel(f2);
        int n4 = coordPixelXform.convertRowToPixel(f3);
        Stroke stroke2 = null;
        if (stroke != null) {
            stroke2 = graphics2D.getStroke();
            graphics2D.setStroke(stroke);
        }
        int n5 = 0;
        int n6 = 0;
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n, n4);
        if (n3 != n2) {
            n5 = n - Base_Half_Width;
            n6 = n2 - n3 - 1;
            graphics2D.fillArc(n5, n3, Base_Width, n6, 0, 360);
        }
        graphics2D.setColor(Color.white);
        if (n2 != n4) {
            graphics2D.drawArc(n5, n3, Base_Width, n6, 0, 360);
        } else {
            graphics2D.drawLine(n - Base_Half_Width, n3, n + Base_Half_Width, n3);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke2);
        }
        return 1;
    }

    public static boolean containsPixel(CoordPixelXform coordPixelXform, Point point, double d, float f, float f2) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = coordPixelXform.convertTimeToPixel(d);
        double d7 = Line2D.ptSegDistSq(d6, d5 = (double)coordPixelXform.convertRowToPixel(f), d6, d4 = (double)coordPixelXform.convertRowToPixel(f2), d3 = (double)point.x, d2 = (double)point.y);
        return d7 < Max_LineSeg2Pt_DistSQ;
    }
}

