/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Method;
import base.drawable.YCoordMap;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataInputStream;
import base.io.MixedDataOutput;
import base.io.MixedDataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import logformat.slog2.Permutation;

public class LineIDMap
extends TreeMap
implements MixedDataIO {
    private static final long serialVersionUID = 500L;
    private int num_treenodes;
    private String title_label;
    private String[] column_labels;
    private Method[] methods;

    public LineIDMap() {
        this.num_treenodes = 0;
        this.title_label = null;
        this.column_labels = null;
        this.methods = null;
    }

    public LineIDMap(int n) {
        this.num_treenodes = n;
        this.title_label = null;
        this.column_labels = null;
        this.methods = null;
    }

    public LineIDMap(YCoordMap yCoordMap) {
        int n;
        this.num_treenodes = yCoordMap.getNumOfColumns() - 1;
        this.title_label = yCoordMap.getTitleName();
        this.column_labels = yCoordMap.getColumnNames();
        this.methods = yCoordMap.getMethods();
        if (this.column_labels.length != this.num_treenodes) {
            System.err.print("LineIDMap: Warning!\nThe input column_labels[] are ");
            for (n = 0; n < this.column_labels.length; ++n) {
                System.err.print(this.column_labels[n] + " ");
            }
            System.err.println();
            System.err.println("\tThe number of column labels is expected to be " + this.num_treenodes + ".");
        }
        int n2 = yCoordMap.getNumOfRows();
        int[] nArray = yCoordMap.getMapElems();
        if (nArray.length != n2 * (this.num_treenodes + 1)) {
            System.err.println("Warning: The input YCoordMap contains " + nArray.length + " elements.  " + "But the number is expected to be " + n2 * (this.num_treenodes + 1) + ".");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Integer n4 = new Integer(nArray[n3++]);
            Integer[] integerArray = new Integer[this.num_treenodes];
            for (n = 0; n < this.num_treenodes; ++n) {
                integerArray[n] = new Integer(nArray[n3++]);
            }
            super.put(n4, integerArray);
        }
    }

    public YCoordMap toYCoordMap() {
        int[] nArray;
        int n;
        int n2 = super.size();
        int n3 = this.num_treenodes + 1;
        String string = this.title_label;
        String[] stringArray = this.column_labels;
        int[] nArray2 = new int[n2 * n3];
        int n4 = 0;
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer n5 = (Integer)entry.getKey();
            Integer[] integerArray = (Integer[])entry.getValue();
            nArray2[n4++] = n5;
            for (n = 0; n < integerArray.length; ++n) {
                nArray2[n4++] = integerArray[n];
            }
        }
        if (n4 < nArray2.length) {
            throw new IllegalStateException("LineIDMap's TreeMap contains less int than the expected " + nArray2.length + ".");
        }
        if (this.methods != null && this.methods.length > 0) {
            nArray = new int[this.methods.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.methods[n].getMethodIndex();
            }
        } else {
            nArray = null;
        }
        return new YCoordMap(n2, n3, string, stringArray, nArray2, nArray);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public void setTitle(String string) {
        this.title_label = string;
    }

    public String getTitle() {
        return this.title_label;
    }

    public void setColumnLabels(String[] stringArray) {
        if (stringArray.length != this.num_treenodes) {
            System.err.print("Warning: The input column_labels[] is ");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.print(stringArray[i] + " ");
            }
            System.err.println();
            System.err.println("The number of column labels is expected to be " + this.num_treenodes + ".");
        }
        this.column_labels = stringArray;
    }

    public String[] getColumnLabels() {
        return this.column_labels;
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        int n;
        mixedDataOutput.writeString(this.title_label);
        mixedDataOutput.writeInt(this.num_treenodes);
        for (n = 0; n < this.num_treenodes; ++n) {
            mixedDataOutput.writeString(this.column_labels[n]);
        }
        mixedDataOutput.writeInt(super.size());
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer n2 = (Integer)entry.getKey();
            Integer[] integerArray = (Integer[])entry.getValue();
            mixedDataOutput.writeInt(n2);
            for (n = 0; n < this.num_treenodes; ++n) {
                mixedDataOutput.writeInt(integerArray[n]);
            }
        }
        if (this.methods != null && this.methods.length > 0) {
            mixedDataOutput.writeShort((short)this.methods.length);
            for (n = 0; n < this.methods.length; ++n) {
                this.methods[n].writeObject(mixedDataOutput);
            }
        } else {
            mixedDataOutput.writeShort(0);
        }
    }

    public LineIDMap(MixedDataInput mixedDataInput) throws IOException {
        this();
        this.readObject(mixedDataInput);
    }

    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        int n;
        this.title_label = mixedDataInput.readString();
        this.num_treenodes = mixedDataInput.readInt();
        this.column_labels = new String[this.num_treenodes];
        for (n = 0; n < this.num_treenodes; ++n) {
            this.column_labels[n] = mixedDataInput.readString();
        }
        int n2 = mixedDataInput.readInt();
        for (int i = 0; i < n2; ++i) {
            Integer n3 = new Integer(mixedDataInput.readInt());
            Integer[] integerArray = new Integer[this.num_treenodes];
            for (n = 0; n < this.num_treenodes; ++n) {
                integerArray[n] = new Integer(mixedDataInput.readInt());
            }
            super.put(n3, integerArray);
        }
        n2 = mixedDataInput.readShort();
        if (n2 > 0) {
            this.methods = new Method[n2];
            for (n = 0; n < n2; ++n) {
                this.methods[n] = new Method(mixedDataInput);
            }
        } else {
            this.methods = null;
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Title: " + this.title_label + "\n");
        stringBuffer.append("Column Labels: LineID -> ");
        for (n = 0; n < this.num_treenodes; ++n) {
            stringBuffer.append(this.column_labels[n] + " ");
        }
        stringBuffer.append("\n");
        Iterator iterator = super.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer n3 = (Integer)entry.getKey();
            Integer[] integerArray = (Integer[])entry.getValue();
            stringBuffer.append(++n2 + ", " + n3 + ":  ");
            for (n = 0; n < this.num_treenodes; ++n) {
                stringBuffer.append(integerArray[n] + " ");
            }
            stringBuffer.append("\n");
        }
        if (this.methods != null && this.methods.length > 0) {
            stringBuffer.append("methods=< ");
            for (n = 0; n < this.methods.length; ++n) {
                stringBuffer.append(this.methods[n] + " ");
            }
            stringBuffer.append(">\n");
        }
        return stringBuffer.toString();
    }

    public static final void main(String[] stringArray) {
        String string = stringArray[0].trim();
        boolean bl = string.equals("write");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LineIDMap lineIDMap = null;
        if (bl) {
            int n;
            int[] nArray;
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            Permutation permutation = new Permutation(n2, n3);
            while (permutation.hasMoreElements()) {
                nArray = (int[])permutation.nextElement();
                arrayList.add(nArray);
                arrayList.add(nArray.clone());
            }
            Collections.shuffle(arrayList);
            lineIDMap = new LineIDMap(n2);
            lineIDMap.setTitle("SLOG2 LineIDMap sample");
            String[] stringArray2 = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray2[n] = "column" + n;
            }
            lineIDMap.setColumnLabels(stringArray2);
            Iterator iterator = arrayList.iterator();
            n = 1;
            while (iterator.hasNext()) {
                nArray = (int[])iterator.next();
                Integer[] integerArray = new Integer[nArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    integerArray[i] = new Integer(nArray[i]);
                }
                lineIDMap.put(new Integer(10000 + n), integerArray);
                ++n;
            }
            System.out.println("LineIDMap:\n" + lineIDMap);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("tmp_LineIDMap.dat");
                MixedDataOutputStream mixedDataOutputStream = new MixedDataOutputStream(fileOutputStream);
                lineIDMap.writeObject(mixedDataOutputStream);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream("tmp_LineIDMap.dat");
                MixedDataInputStream mixedDataInputStream = new MixedDataInputStream(fileInputStream);
                lineIDMap = new LineIDMap(mixedDataInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
            System.out.println(lineIDMap);
        }
    }
}

