/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.CategorySummary;
import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class CategoryWeight
extends CategorySummary
implements DataIO {
    public static final int BYTESIZE = 20;
    public static final Comparator INDEX_ORDER = new IndexOrder();
    private static final int INVALID_INDEX = Integer.MIN_VALUE;
    private int type_idx;
    private Category type;
    private int width;
    private int height;

    public CategoryWeight() {
        this.type = null;
        this.type_idx = Integer.MIN_VALUE;
        this.width = 0;
        this.height = 0;
    }

    public CategoryWeight(Category new_type, float new_incl_r, float new_excl_r, long new_num_real_objs) {
        super(new_incl_r, new_excl_r, new_num_real_objs);
        this.type = new_type;
        this.type_idx = this.type.getIndex();
    }

    public CategoryWeight(CategoryWeight type_wgt) {
        super(type_wgt);
        this.type = type_wgt.type;
        this.type_idx = type_wgt.type_idx;
    }

    public void setPixelWidth(int wdh) {
        this.width = wdh;
    }

    public int getPixelWidth() {
        return this.width;
    }

    public void setPixelHeight(int hgt) {
        this.height = hgt;
    }

    public int getPixelHeight() {
        return this.height;
    }

    public Category getCategory() {
        return this.type;
    }

    public boolean resolveCategory(Map categorymap) {
        if (this.type == null && this.type_idx != Integer.MIN_VALUE) {
            this.type = (Category)categorymap.get(new Integer(this.type_idx));
            if (this.type != null) {
                return true;
            }
        }
        return false;
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeInt(this.type_idx);
        super.writeObject(outs);
    }

    public CategoryWeight(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.type_idx = ins.readInt();
        super.readObject(ins);
    }

    public String toInfoBoxString(int print_status) {
        StringBuffer rep = new StringBuffer("legend=");
        if (this.type != null) {
            rep.append(this.type.getName());
        } else {
            rep.append("null:" + this.type_idx);
        }
        rep.append(", ");
        rep.append(super.toInfoBoxString(print_status));
        return rep.toString();
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("(type=" + this.type_idx);
        if (this.type != null) {
            rep.append(":" + this.type.getName());
        } else {
            rep.append(", ");
        }
        rep.append(super.toString());
        rep.append(")");
        return rep.toString();
    }

    private static class IndexOrder
    implements Comparator {
        private IndexOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategoryWeight type_wgt1 = (CategoryWeight)o1;
            CategoryWeight type_wgt2 = (CategoryWeight)o2;
            return type_wgt1.type_idx - type_wgt2.type_idx;
        }
    }
}

