/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class CategoryRatios
implements DataIO {
    public static final int BYTESIZE = 8;
    public static final Comparator INCL_RATIO_ORDER = new InclRatioOrder();
    public static final Comparator EXCL_RATIO_ORDER = new ExclRatioOrder();
    public static final int PRINT_ALL_RATIOS = 0;
    public static final int PRINT_INCL_RATIO = 1;
    public static final int PRINT_EXCL_RATIO = 2;
    private static final String TITLE_ALL_RATIOS = "*** All Duration Ratios:";
    private static final String TITLE_INCL_RATIO = "*** Inclusive Duration Ratio:";
    private static final String TITLE_EXCL_RATIO = "*** Exclusive Duration Ratio:";
    private float incl_ratio;
    private float excl_ratio;

    public CategoryRatios() {
        this.incl_ratio = 0.0f;
        this.excl_ratio = 0.0f;
    }

    public CategoryRatios(float new_incl_r, float new_excl_r) {
        this.incl_ratio = new_incl_r;
        this.excl_ratio = new_excl_r;
    }

    public CategoryRatios(CategoryRatios type_rts) {
        this.incl_ratio = type_rts.incl_ratio;
        this.excl_ratio = type_rts.excl_ratio;
    }

    public float getRatio(boolean isInclusive) {
        if (isInclusive) {
            return this.incl_ratio;
        }
        return this.excl_ratio;
    }

    public void rescaleAllRatios(float ftr) {
        this.incl_ratio *= ftr;
        this.excl_ratio *= ftr;
    }

    public void addAllRatios(CategoryRatios a_type_rts, float ftr) {
        this.incl_ratio += a_type_rts.incl_ratio * ftr;
        this.excl_ratio += a_type_rts.excl_ratio * ftr;
    }

    public void addExclusiveRatio(float extra_ratio) {
        this.excl_ratio += extra_ratio;
    }

    public void addInclusiveRatio(float extra_ratio) {
        this.incl_ratio += extra_ratio;
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeFloat(this.incl_ratio);
        outs.writeFloat(this.excl_ratio);
    }

    public CategoryRatios(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.incl_ratio = ins.readFloat();
        this.excl_ratio = ins.readFloat();
    }

    public static String getPrintTitle(int print_status) {
        if (print_status == 1) {
            return TITLE_INCL_RATIO;
        }
        if (print_status == 2) {
            return TITLE_EXCL_RATIO;
        }
        return TITLE_ALL_RATIOS;
    }

    public String toInfoBoxString(int print_status) {
        if (print_status == 1) {
            return "ratio=" + this.incl_ratio;
        }
        if (print_status == 2) {
            return "ratio=" + this.excl_ratio;
        }
        return "incl_ratio=" + this.incl_ratio + ", excl_ratio=" + this.excl_ratio;
    }

    public String toString() {
        return "ratios=" + this.incl_ratio + "," + this.excl_ratio;
    }

    private static class ExclRatioOrder
    implements Comparator {
        private ExclRatioOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategoryRatios type_rts1 = (CategoryRatios)o1;
            CategoryRatios type_rts2 = (CategoryRatios)o2;
            float diff = type_rts1.excl_ratio - type_rts2.excl_ratio;
            return diff < 0.0f ? -1 : (diff == 0.0f ? 0 : 1);
        }
    }

    private static class InclRatioOrder
    implements Comparator {
        private InclRatioOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategoryRatios type_rts1 = (CategoryRatios)o1;
            CategoryRatios type_rts2 = (CategoryRatios)o2;
            float diff = type_rts1.incl_ratio - type_rts2.incl_ratio;
            return diff < 0.0f ? -1 : (diff == 0.0f ? 0 : 1);
        }
    }
}

