/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import logformat.clog2.MixedDataInputStream;

public class RecDefState {
    public static final int RECTYPE = 2;
    private static final int BYTESIZE = 112;
    public int stateID;
    public Integer startetype;
    public Integer finaletype;
    public String color;
    public String name;
    public String format;

    public int readFromDataStream(MixedDataInputStream in) {
        try {
            this.stateID = in.readInt();
            this.startetype = new Integer(in.readInt());
            this.finaletype = new Integer(in.readInt());
            in.skipBytes(4);
            this.color = in.readString(24);
            this.name = in.readString(32);
            this.format = in.readString(40);
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 112;
    }

    public int skipBytesFromDataStream(DataInputStream in) {
        try {
            in.skipBytes(112);
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 112;
    }

    public static List getUndefinedInitedStateDefs(int eventID_1st, int stateID_count) {
        int evtID = eventID_1st;
        ArrayList<RecDefState> defs = new ArrayList<RecDefState>(stateID_count);
        for (int idx = 0; idx < stateID_count; ++idx) {
            RecDefState def = new RecDefState();
            def.startetype = new Integer(evtID++);
            def.finaletype = new Integer(evtID++);
            def.color = "pink";
            def.name = null;
            def.format = null;
            defs.add(def);
        }
        return defs;
    }

    public String toString() {
        return "RecDefState[ stateID=" + this.stateID + ", startetype=" + this.startetype + ", finaletype=" + this.finaletype + ", color=" + this.color + ", name=" + this.name + ", format=" + this.format + " ]";
    }

    public static final void main(String[] args) {
        List defs = RecDefState.getUndefinedInitedStateDefs(0, 10);
        Iterator itr = defs.iterator();
        while (itr.hasNext()) {
            System.out.println((RecDefState)itr.next());
        }
    }
}

