/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Drawable;
import java.util.Stack;
import javax.swing.JTree;

public class NestingStacks {
    private static float Nesting_Height_Reduction = 0.8f;
    private static float Initial_Nesting_Height = 0.8f;
    private static float Half_Initial_Nesting_Height = 0.4f;
    private JTree tree_view;
    private Stack[] nesting_stacks;
    private boolean hasNestingStacksBeenUsed;
    private boolean isTimeBoxScrolling;
    private int num_rows;

    public NestingStacks(JTree in_tree_view) {
        this.tree_view = in_tree_view;
        this.nesting_stacks = null;
    }

    public static void setNestingHeightReduction(float new_reduction) {
        if (new_reduction > 0.0f && new_reduction < 1.0f) {
            Nesting_Height_Reduction = new_reduction;
        }
    }

    public static void setInitialNestingHeight(float new_init_height) {
        if (new_init_height > 0.0f && new_init_height < 1.0f) {
            Initial_Nesting_Height = new_init_height;
            Half_Initial_Nesting_Height = Initial_Nesting_Height / 2.0f;
        }
    }

    public static float getHalfInitialNestingHeight() {
        return Half_Initial_Nesting_Height;
    }

    public void initialize(boolean isScrolling) {
        this.isTimeBoxScrolling = isScrolling;
        this.num_rows = this.tree_view.getRowCount();
        this.nesting_stacks = new Stack[this.num_rows];
        for (int irow = 0; irow < this.num_rows; ++irow) {
            this.nesting_stacks[irow] = !this.tree_view.isExpanded(irow) ? new Stack() : null;
        }
        this.hasNestingStacksBeenUsed = false;
    }

    public void reset() {
        if (this.hasNestingStacksBeenUsed) {
            for (int irow = 0; irow < this.num_rows; ++irow) {
                if (this.nesting_stacks[irow] == null) continue;
                this.nesting_stacks[irow].clear();
            }
        } else {
            this.hasNestingStacksBeenUsed = true;
        }
    }

    public void finish() {
        for (int irow = 0; irow < this.num_rows; ++irow) {
            if (this.nesting_stacks[irow] == null) continue;
            this.nesting_stacks[irow] = null;
        }
    }

    public boolean isReadyToGetNestingFactorFor(Drawable cur_dobj) {
        if (this.isTimeBoxScrolling) {
            return cur_dobj.isNestingFactorUninitialized();
        }
        return true;
    }

    public float getNestingFactorFor(Drawable cur_dobj) {
        int rowID = cur_dobj.getRowID();
        Stack nesting_stack = this.nesting_stacks[rowID];
        float nesting_ftr = 1.0f;
        while (!nesting_stack.empty()) {
            Drawable dobj = (Drawable)nesting_stack.peek();
            if (dobj.covers(cur_dobj)) {
                nesting_ftr = dobj.getNestingFactor() * Nesting_Height_Reduction;
                nesting_stack.push(cur_dobj);
                return nesting_ftr;
            }
            nesting_stack.pop();
        }
        nesting_ftr = Initial_Nesting_Height;
        nesting_stack.push(cur_dobj);
        return nesting_ftr;
    }
}

