/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import logformat.slog2.BufForObjects;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.input.InputLog;
import logformat.slog2.input.TreeFloor;
import logformat.slog2.input.TreeFloorList;
import logformat.slog2.input.TreeNode;

public class TreeTrunk
extends TreeFloorList {
    public static final int TIMEBOX_DISJOINTED = -1;
    public static final int TIMEBOX_EQUAL = 0;
    public static final int TIMEBOX_SCROLLING = 1;
    public static final int TIMEBOX_ZOOMING = 2;
    private static boolean isDebugging = false;
    private static TimeBoundingBox timeframe_root;
    private short depth_root;
    private short depth_init;
    private short iZoom_level;
    private double duration_root;
    private double tZoomFactor;
    private double logZoomFactor;
    private InputLog slog_ins;
    private Drawable.Order node_dobj_order;
    private static final double TOLERANCE = (double)0.01f;

    public TreeTrunk(InputLog in_slog, Drawable.Order in_dobj_order) {
        super(in_dobj_order);
        this.slog_ins = in_slog;
        timeframe_root = null;
        this.node_dobj_order = in_dobj_order.isStartTimeOrdered() ? null : Drawable.INCRE_FINALTIME_ORDER;
    }

    public void initFromTreeTop() {
        FileBlockPtr blockptr = this.slog_ins.getFileBlockPtrToTreeRoot();
        if (blockptr.isNULL()) {
            return;
        }
        TreeNode treeroot = this.slog_ins.readTreeNode(blockptr);
        if (treeroot == null) {
            return;
        }
        if (this.node_dobj_order != null) {
            treeroot.reorderDrawables(this.node_dobj_order);
        }
        this.depth_root = treeroot.getTreeNodeID().depth;
        timeframe_root = new TimeBoundingBox(treeroot);
        this.duration_root = timeframe_root.getDuration();
        this.depth_init = this.depth_root;
        this.iZoom_level = 0;
        this.tZoomFactor = this.slog_ins.getNumChildrenPerNode();
        this.logZoomFactor = Math.log(this.tZoomFactor);
        super.init(this.depth_root);
        super.put(treeroot, treeroot);
    }

    public void setTimeZoomFactor(double time_zoom_factor) {
        this.tZoomFactor = time_zoom_factor;
        this.logZoomFactor = Math.log(this.tZoomFactor);
    }

    public double getTimeZoomFactor() {
        return this.tZoomFactor;
    }

    public TreeNode getTreeRoot() {
        return (TreeNode)super.getRoot();
    }

    public void growInTreeWindow(TreeNode treenode, short in_depth_init, TimeBoundingBox time_win) {
        this.depth_init = in_depth_init;
        this.growChildren(treenode, this.depth_init, time_win);
        super.updateLowestDepth();
    }

    private void growChildren(TreeNode treenode, short in_depth, TimeBoundingBox time_win) {
        if (treenode != null && treenode.getTreeNodeID().depth > in_depth) {
            if (treenode.overlaps(time_win)) {
                BufForObjects[] childstubs = treenode.getChildStubs();
                for (int idx = 0; idx < childstubs.length; ++idx) {
                    BufForObjects childstub = childstubs[idx];
                    TreeNode childnode = super.get(childstub);
                    if (childstub.overlaps(time_win)) {
                        if (childnode == null) {
                            FileBlockPtr blockptr = childstub.getFileBlockPtr();
                            childnode = this.slog_ins.readTreeNode(blockptr);
                            if (this.node_dobj_order != null) {
                                childnode.reorderDrawables(this.node_dobj_order);
                            }
                            super.put(childstub, childnode);
                        }
                        this.growChildren(childnode, in_depth, time_win);
                        continue;
                    }
                    if (childnode == null) continue;
                    this.removeChildren(childnode, in_depth);
                    if (isDebugging) {
                        TreeTrunk.debug_println("TreeTrunk.growChildren(): remove(" + childstub.getTreeNodeID() + ")");
                    }
                    super.remove(childstub);
                }
            } else {
                String err_msg = "TreeTrunk.growChildren(): ERROR!\n\t treenode.overlaps( time_win ) != true\n\t " + treenode.getTreeNodeID() + "does NOT overlap with " + time_win;
                throw new IllegalStateException(err_msg);
            }
        }
    }

    private void removeChildren(TreeNode treenode, short in_depth) {
        if (treenode != null && treenode.getTreeNodeID().depth > in_depth) {
            BufForObjects[] childstubs = treenode.getChildStubs();
            for (int idx = 0; idx < childstubs.length; ++idx) {
                BufForObjects childstub = childstubs[idx];
                TreeNode childnode = super.get(childstub);
                if (childnode == null) continue;
                this.removeChildren(childnode, in_depth);
                if (isDebugging) {
                    TreeTrunk.debug_println("TreeTrunk.removeChildren(): remove(" + childstub.getTreeNodeID() + ")");
                }
                super.remove(childstub);
            }
        }
    }

    public void setNumOfViewsPerUpdate(int num_views) {
        this.duration_root *= (double)num_views;
    }

    private short getZoomLevel(TimeBoundingBox time_win) {
        return (short)Math.round(Math.log(this.duration_root / time_win.getDuration()) / this.logZoomFactor);
    }

    public void zoomTimeWindowTo(TimeBoundingBox time_win) {
        if (isDebugging) {
            TreeTrunk.debug_println("zoomTimeWindowTo( " + time_win + " )");
        }
        this.iZoom_level = this.getZoomLevel(time_win);
        TreeFloor lowester = super.getLowestFloor();
        TreeFloor coverer = super.getCoveringFloor(time_win);
        short coverer_depth = coverer.getDepth();
        short lowester_depth = lowester.getDepth();
        short next_depth = (short)(this.depth_init - this.iZoom_level);
        if (next_depth < 0) {
            next_depth = 0;
        }
        if (next_depth > this.depth_root) {
            next_depth = this.depth_root;
        }
        if (isDebugging) {
            TreeTrunk.debug_println("coverer_depth = " + coverer_depth);
            TreeTrunk.debug_println("lowester_depth = " + lowester_depth);
            TreeTrunk.debug_println("iZoom_level = " + this.iZoom_level);
            TreeTrunk.debug_println("next_depth = " + next_depth);
        }
        if (next_depth < coverer_depth) {
            Iterator nodes = coverer.values().iterator();
            while (nodes.hasNext()) {
                TreeNode treenode = (TreeNode)nodes.next();
                if (treenode.overlaps(time_win)) {
                    this.growChildren(treenode, next_depth, time_win);
                    continue;
                }
                this.removeChildren(treenode, next_depth);
                if (isDebugging) {
                    TreeTrunk.debug_println("TreeTrunk.zoomTimeWindowTo(): remove(" + treenode.getTreeNodeID() + ")");
                }
                nodes.remove();
            }
            super.removeAllChildFloorsBelow(next_depth);
        }
        if (isDebugging) {
            TreeTrunk.debug_println(super.toStubString());
        }
    }

    public void scrollTimeWindowTo(TimeBoundingBox time_win) {
        TreeFloor lowester;
        if (isDebugging) {
            TreeTrunk.debug_println("scrollTimeWindowTo( " + time_win + " )");
        }
        if (!(lowester = super.getLowestFloor()).covers(time_win)) {
            short lowester_depth;
            TreeFloor coverer = super.getCoveringFloor(time_win);
            short coverer_depth = coverer.getDepth();
            short next_depth = lowester_depth = lowester.getDepth();
            if (isDebugging) {
                TreeTrunk.debug_println("coverer_depth = " + coverer_depth);
                TreeTrunk.debug_println("lowester_depth = " + lowester_depth);
                TreeTrunk.debug_println("iZoom_level = " + this.iZoom_level);
                TreeTrunk.debug_println("next_depth = " + next_depth);
            }
            if (next_depth < coverer_depth) {
                Iterator nodes = coverer.values().iterator();
                while (nodes.hasNext()) {
                    TreeNode treenode = (TreeNode)nodes.next();
                    if (treenode.overlaps(time_win)) {
                        this.growChildren(treenode, next_depth, time_win);
                        continue;
                    }
                    this.removeChildren(treenode, next_depth);
                    if (isDebugging) {
                        TreeTrunk.debug_println("TreeTrunk.scrollTimeWindowTo(): remove(" + treenode.getTreeNodeID() + ")");
                    }
                    nodes.remove();
                }
                super.removeAllChildFloorsBelow(next_depth);
            }
        }
        if (isDebugging) {
            TreeTrunk.debug_println(super.toStubString());
        }
    }

    public int updateTimeWindow(TimeBoundingBox time_win_old, TimeBoundingBox time_win_new) {
        if (timeframe_root.overlaps(time_win_new)) {
            if (!time_win_old.equals(time_win_new)) {
                double time_ratio = time_win_new.getDuration() / time_win_old.getDuration();
                if (Math.abs(time_ratio - 1.0) <= (double)0.01f) {
                    this.scrollTimeWindowTo(time_win_new);
                    return 1;
                }
                this.zoomTimeWindowTo(time_win_new);
                return 2;
            }
            return 0;
        }
        if (isDebugging) {
            TreeTrunk.debug_println("TreeTrunk.updateTimeWindow(): ERROR!\n\t TimeWindow disjoints from TimeFrame@TreeRoot.\n\t TimeWin@TreeRoot = " + timeframe_root + "\n" + "\t TimeWin_old      = " + time_win_old + "\n" + "\t TimeWin_new      = " + time_win_new + "\n");
        }
        return -1;
    }

    public void setDebuggingEnabled(boolean bvalue) {
        isDebugging = bvalue;
    }

    public boolean isDebugging() {
        return isDebugging;
    }

    private static void debug_println(String str) {
        System.out.println(str);
    }
}

