/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import logformat.slog2.LineIDMap;
import viewer.common.ActableTextField;
import viewer.common.Dialogs;
import viewer.common.Routines;
import viewer.common.TopWindow;
import viewer.first.HTMLviewer;
import viewer.first.LogFileOperations;

public class FirstPanel
extends JPanel {
    private static final long serialVersionUID = 14100L;
    private static String about_str = "Jumpshot-4, the SLOG-2 viewer.\nbug-reports/questions:\n            chan@mcs.anl.gov";
    private static String manual_path = "/html/usersguide.html";
    private static String faq_path = "/html/faq_index.html";
    private static String js_icon_path = "/images/jumpshot.gif";
    private static String open_icon_path = "/images/Open24.gif";
    private static String convert_icon_path = "/images/Convert24.gif";
    private static String show_icon_path = "/images/New24.gif";
    private static String close_icon_path = "/images/Stop24.gif";
    private static String legend_icon_path = "/images/Properties24.gif";
    private static String prefer_icon_path = "/images/Preferences24.gif";
    private static String manual_icon_path = "/images/Help24.gif";
    private static String faq_icon_path = "/images/Information24.gif";
    private static String about_icon_path = "/images/About24.gif";
    private ActableTextField logname_fld;
    private JComboBox pulldown_list;
    private JButton file_select_btn;
    private JButton file_convert_btn;
    private JButton file_close_btn;
    private JButton show_timeline_btn;
    private JButton show_legend_btn;
    private JButton edit_prefer_btn;
    private JButton help_manual_btn;
    private JButton help_faq_btn;
    private JButton help_about_btn;
    private HTMLviewer manual_viewer;
    private HTMLviewer faq_viewer;
    private LogFileOperations file_ops;
    private String logfile_name;
    private int view_ID;

    public FirstPanel(boolean isApplet, String filename, int view_idx) {
        super.setLayout(new BorderLayout());
        Border lowered_border = BorderFactory.createLoweredBevelBorder();
        Border etched_border = BorderFactory.createEtchedBorder();
        this.file_ops = new LogFileOperations(isApplet);
        this.logfile_name = filename;
        this.view_ID = view_idx;
        Dimension row_pref_sz = new Dimension(410, 27);
        Dimension lbl_pref_sz = new Dimension(110, 25);
        Dimension fld_pref_sz = new Dimension(row_pref_sz.width - lbl_pref_sz.width, lbl_pref_sz.height);
        JPanel ctr_panel = new JPanel();
        ctr_panel.setLayout(new BoxLayout(ctr_panel, 1));
        ctr_panel.add(Box.createVerticalGlue());
        JPanel logname_panel = new JPanel();
        logname_panel.setAlignmentX(0.5f);
        logname_panel.setLayout(new BoxLayout(logname_panel, 0));
        JLabel label = new JLabel(" LogName : ");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        logname_panel.add(label);
        this.logname_fld = new ActableTextField(this.logfile_name, 40);
        this.logname_fld.setBorder(BorderFactory.createCompoundBorder(lowered_border, etched_border));
        this.logname_fld.addActionListener(new LogNameTextFieldListener());
        Routines.setShortJComponentSizes(this.logname_fld, fld_pref_sz);
        logname_panel.add(this.logname_fld);
        Routines.setShortJComponentSizes(logname_panel, row_pref_sz);
        ctr_panel.add(logname_panel);
        ctr_panel.add(Box.createVerticalGlue());
        ctr_panel.add(Box.createVerticalStrut(4));
        JPanel map_panel = new JPanel();
        map_panel.setAlignmentX(0.5f);
        map_panel.setLayout(new BoxLayout(map_panel, 0));
        label = new JLabel(" ViewMap : ");
        Routines.setShortJComponentSizes(label, lbl_pref_sz);
        map_panel.add(label);
        this.pulldown_list = new JComboBox();
        this.pulldown_list.setBorder(lowered_border);
        this.pulldown_list.addActionListener(new ViewMapComboBoxListener());
        Routines.setShortJComponentSizes(this.pulldown_list, fld_pref_sz);
        map_panel.add(this.pulldown_list);
        Routines.setShortJComponentSizes(map_panel, row_pref_sz);
        ctr_panel.add(map_panel);
        ctr_panel.add(Box.createVerticalGlue());
        ctr_panel.setBorder(etched_border);
        super.add((Component)ctr_panel, "Center");
        JToolBar toolbar = this.createToolBarAndButtons(0);
        super.add((Component)toolbar, "South");
    }

    private JToolBar createToolBarAndButtons(int orientation) {
        JToolBar toolbar = new JToolBar(orientation);
        toolbar.setFloatable(true);
        Insets btn_insets = new Insets(1, 1, 1, 1);
        URL icon_URL = null;
        icon_URL = this.getURL(open_icon_path);
        this.file_select_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("SELECT");
        this.file_select_btn.setToolTipText("Select a new logfile");
        this.file_select_btn.setMargin(btn_insets);
        this.file_select_btn.addActionListener(new FileSelectButtonListener());
        toolbar.add(this.file_select_btn);
        icon_URL = null;
        icon_URL = this.getURL(convert_icon_path);
        this.file_convert_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("CONVERT");
        this.file_convert_btn.setToolTipText("Invoke the Logfile Convertor");
        this.file_convert_btn.setMargin(btn_insets);
        this.file_convert_btn.addActionListener(new FileConvertButtonListener());
        toolbar.add(this.file_convert_btn);
        toolbar.addSeparator();
        icon_URL = null;
        icon_URL = this.getURL(legend_icon_path);
        this.show_legend_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("LEGEND");
        this.show_legend_btn.setToolTipText("Display the Legend window");
        this.show_legend_btn.setMargin(btn_insets);
        this.show_legend_btn.addActionListener(new ShowLegendButtonListener());
        toolbar.add(this.show_legend_btn);
        icon_URL = null;
        icon_URL = this.getURL(show_icon_path);
        this.show_timeline_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("TIMELINE");
        this.show_timeline_btn.setToolTipText("Display the Timeline window");
        this.show_timeline_btn.setMargin(btn_insets);
        this.show_timeline_btn.addActionListener(new ViewMapComboBoxListener());
        toolbar.add(this.show_timeline_btn);
        toolbar.addSeparator();
        icon_URL = null;
        icon_URL = this.getURL(prefer_icon_path);
        this.edit_prefer_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("PREFERENCE");
        this.edit_prefer_btn.setToolTipText("Open the Preference window");
        this.edit_prefer_btn.setMargin(btn_insets);
        this.edit_prefer_btn.addActionListener(new EditPreferButtonListener());
        toolbar.add(this.edit_prefer_btn);
        toolbar.addSeparator();
        icon_URL = null;
        icon_URL = this.getURL(manual_icon_path);
        this.help_manual_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("MANUAL");
        this.help_manual_btn.setToolTipText("Open the user's manual window");
        this.help_manual_btn.setMargin(btn_insets);
        this.help_manual_btn.addActionListener(new HelpManualButtonListener());
        toolbar.add(this.help_manual_btn);
        icon_URL = null;
        icon_URL = this.getURL(faq_icon_path);
        this.help_faq_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("FAQ");
        this.help_faq_btn.setToolTipText("Open the FAQ window");
        this.help_faq_btn.setMargin(btn_insets);
        this.help_faq_btn.addActionListener(new HelpFAQsButtonListener());
        toolbar.add(this.help_faq_btn);
        icon_URL = null;
        icon_URL = this.getURL(about_icon_path);
        this.help_about_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("ABOUT");
        this.help_about_btn.setToolTipText("Open the About-This window");
        this.help_about_btn.setMargin(btn_insets);
        this.help_about_btn.addActionListener(new HelpAboutButtonListener());
        icon_URL = null;
        icon_URL = this.getURL(close_icon_path);
        this.file_close_btn = icon_URL != null ? new JButton(new ImageIcon(icon_URL)) : new JButton("CLOSE");
        this.file_close_btn.setToolTipText("Close the logfile");
        this.file_close_btn.setMargin(btn_insets);
        this.file_close_btn.addActionListener(new FileCloseButtonListener());
        this.manual_viewer = new HTMLviewer("Manual", this.help_manual_btn);
        this.faq_viewer = new HTMLviewer("FAQs", this.help_faq_btn);
        return toolbar;
    }

    public void init() {
        this.file_ops.init();
        if (this.logfile_name != null) {
            this.logname_fld.fireActionPerformed();
        }
    }

    private URL getURL(String filename) {
        return this.getClass().getResource(filename);
    }

    private void setMapPullDownMenu(List list) {
        this.pulldown_list.removeAllItems();
        Iterator linemaps = list.iterator();
        while (linemaps.hasNext()) {
            String map_title = "  " + ((LineIDMap)linemaps.next()).getTitle();
            this.pulldown_list.addItem(map_title);
        }
    }

    public JButton getLogFileSelectButton() {
        return this.file_select_btn;
    }

    public JButton getLogFileConvertButton() {
        return this.file_convert_btn;
    }

    public JButton getLogFileCloseButton() {
        return this.file_close_btn;
    }

    public JButton getShowLegendButton() {
        return this.show_legend_btn;
    }

    public JButton getShowTimelineButton() {
        return this.show_timeline_btn;
    }

    public JButton getEditPreferenceButton() {
        return this.edit_prefer_btn;
    }

    public JButton getHelpManualButton() {
        return this.help_manual_btn;
    }

    public JButton getHelpFAQsButton() {
        return this.help_faq_btn;
    }

    public JButton getHelpAboutButton() {
        return this.help_about_btn;
    }

    private class FileCloseButtonListener
    implements ActionListener {
        private FileCloseButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FirstPanel.this.file_ops.disposeLogFileAndResources();
            FirstPanel.this.pulldown_list.removeAllItems();
        }
    }

    private class HelpAboutButtonListener
    implements ActionListener {
        private HelpAboutButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            URL icon_URL = FirstPanel.this.getURL(js_icon_path);
            if (icon_URL != null) {
                ImageIcon js_icon = new ImageIcon(icon_URL);
                Dialogs.info(TopWindow.First.getWindow(), about_str, js_icon);
            } else {
                Dialogs.info(TopWindow.First.getWindow(), about_str, null);
            }
        }
    }

    private class HelpFAQsButtonListener
    implements ActionListener {
        private HelpFAQsButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            URL faq_URL = FirstPanel.this.getURL(faq_path);
            if (faq_URL != null) {
                FirstPanel.this.faq_viewer.init(faq_URL);
                FirstPanel.this.faq_viewer.setVisible(true);
            } else {
                Dialogs.warn(TopWindow.First.getWindow(), "Cannot locate " + faq_path + ".");
            }
        }
    }

    private class HelpManualButtonListener
    implements ActionListener {
        private HelpManualButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            URL manual_URL = FirstPanel.this.getURL(manual_path);
            if (manual_URL != null) {
                FirstPanel.this.manual_viewer.init(manual_URL);
                FirstPanel.this.manual_viewer.setVisible(true);
            } else {
                Dialogs.warn(TopWindow.First.getWindow(), "Cannot locate " + manual_path + ".");
            }
        }
    }

    private class EditPreferButtonListener
    implements ActionListener {
        private EditPreferButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FirstPanel.this.file_ops.showPreferenceWindow();
        }
    }

    private class ShowLegendButtonListener
    implements ActionListener {
        private ShowLegendButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FirstPanel.this.file_ops.showLegendWindow();
        }
    }

    private class ViewMapComboBoxListener
    implements ActionListener {
        private ViewMapComboBoxListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FirstPanel.this.view_ID = FirstPanel.this.pulldown_list.getSelectedIndex();
            if (FirstPanel.this.view_ID >= 0 && FirstPanel.this.view_ID < FirstPanel.this.pulldown_list.getItemCount()) {
                FirstPanel.this.file_ops.createTimelineWindow(FirstPanel.this.view_ID);
            }
        }
    }

    private class LogNameTextFieldListener
    implements ActionListener {
        private LogNameTextFieldListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FirstPanel.this.file_ops.disposeLogFileAndResources();
            List lineIDmaps = FirstPanel.this.file_ops.openLogFile(FirstPanel.this.logname_fld);
            if (lineIDmaps != null) {
                FirstPanel.this.setMapPullDownMenu(lineIDmaps);
            }
        }
    }

    private class FileConvertButtonListener
    implements ActionListener {
        private FileConvertButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String new_filename = null;
            String filename = FirstPanel.this.logname_fld.getText();
            new_filename = filename != null && filename.length() > 0 ? FirstPanel.this.file_ops.convertLogFile(filename) : FirstPanel.this.file_ops.convertLogFile(null);
            if (new_filename != null && new_filename.length() > 0) {
                FirstPanel.this.logname_fld.setText(new_filename);
                FirstPanel.this.logname_fld.fireActionPerformed();
            }
        }
    }

    private class FileSelectButtonListener
    implements ActionListener {
        private FileSelectButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String filename = FirstPanel.this.file_ops.selectLogFile();
            if (filename != null && filename.length() > 0) {
                FirstPanel.this.logname_fld.setText(filename);
                FirstPanel.this.logname_fld.fireActionPerformed();
            }
        }
    }
}

