/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.Window;
import java.io.File;
import java.util.List;
import javax.swing.JTextField;
import logformat.slog2.input.InputLog;
import viewer.common.Dialogs;
import viewer.common.LogFileChooser;
import viewer.common.Parameters;
import viewer.common.PreferenceFrame;
import viewer.common.SwingWorker;
import viewer.common.TopWindow;
import viewer.convertor.ConvertorDialog;
import viewer.legends.LegendFrame;
import viewer.timelines.TimelineFrame;

public class LogFileOperations {
    private LogFileChooser file_chooser;
    private InputLog slog_ins;
    private PreferenceFrame pptys_frame;
    private LegendFrame legend_frame;
    private TimelineFrame timeline_frame;

    public LogFileOperations(boolean isApplet) {
        this.file_chooser = new LogFileChooser(isApplet);
        this.slog_ins = null;
        this.legend_frame = null;
        this.timeline_frame = null;
    }

    public void init() {
        Parameters.initSetupFile();
        Parameters.readFromSetupFile(TopWindow.First.getWindow());
        Parameters.initStaticClasses();
        this.pptys_frame = new PreferenceFrame();
        this.pptys_frame.setVisible(false);
    }

    private static InputLog createInputLog(Window window, String pathname) {
        String logname = pathname.trim();
        if (logname != null && logname.length() > 0) {
            File logfile = new File(logname);
            if (!logfile.exists()) {
                Dialogs.error(window, "File Not Found when initializing " + logname + ".");
                return null;
            }
            if (logfile.isDirectory()) {
                Dialogs.error(window, logname + " is a directory.");
                return null;
            }
            if (!logfile.canRead()) {
                Dialogs.error(window, "File " + logname + " cannot be read.");
                return null;
            }
            InputLog slog = null;
            try {
                slog = new InputLog(logname);
            }
            catch (NullPointerException nperr) {
                Dialogs.error(window, "NullPointerException when initializing " + logname + "!");
                return null;
            }
            catch (Exception err) {
                Dialogs.error(window, "EOFException when initializing " + logname + "!");
                return null;
            }
            return slog;
        }
        if (logname == null) {
            Dialogs.error(window, "Null pathname!");
        } else {
            Dialogs.error(window, "pathname is empty!");
        }
        return null;
    }

    public void disposeLogFileAndResources() {
        if (this.slog_ins != null) {
            TopWindow.Legend.disposeAll();
            this.slog_ins.close();
            this.slog_ins = null;
            this.legend_frame = null;
            this.timeline_frame = null;
        }
    }

    public String selectLogFile() {
        int istat = this.file_chooser.showOpenDialog(TopWindow.First.getWindow());
        if (istat == 0) {
            File selected_file = this.file_chooser.getSelectedFile();
            if (selected_file != null) {
                File selected_dir = selected_file.getParentFile();
                if (selected_dir != null) {
                    this.file_chooser.setCurrentDirectory(selected_dir);
                }
                return selected_file.getPath();
            }
        } else {
            Dialogs.info(TopWindow.First.getWindow(), "No file chosen", null);
        }
        return null;
    }

    public String convertLogFile(String filename) {
        return ConvertorDialog.convertLogFile(TopWindow.First.getWindow(), this.file_chooser, filename);
    }

    public List openLogFile(JTextField logname_txtfld) {
        String filename = logname_txtfld.getText();
        this.slog_ins = LogFileOperations.createInputLog(TopWindow.First.getWindow(), filename);
        if (this.slog_ins == null) {
            Dialogs.error(TopWindow.First.getWindow(), "Null InputLog!");
            return null;
        }
        if (!this.slog_ins.isSLOG2()) {
            this.slog_ins = null;
            if (Dialogs.confirm(TopWindow.First.getWindow(), filename + " is NOT a SLOG-2 file!\n" + "Do you want to convert it to SLOG-2 format " + "readable by this viewer?")) {
                String new_filename = ConvertorDialog.convertLogFile(TopWindow.First.getWindow(), this.file_chooser, filename);
                if (new_filename != null) {
                    logname_txtfld.setText(new_filename);
                    return this.openLogFile(logname_txtfld);
                }
                return null;
            }
            return null;
        }
        String err_msg = null;
        err_msg = this.slog_ins.getCompatibleHeader();
        if (err_msg != null && !Dialogs.confirm(TopWindow.First.getWindow(), err_msg + "Check the following version history " + "for compatibility.\n\n" + "- Version SLOG 2.0.0's node employs\n  decreasing endtime ordering.\n- Version SLOG 2.0.1's node employs\n  increasing starttime ordering.\n- Version SLOG 2.0.2 added preview data\n  in legend order to shadow states.\n- Version SLOG 2.0.3 changed preview data\n  from legend to inclusive ratio order.\n- Version SLOG 2.0.4 removed unused\n  category objects.\n- Version SLOG 2.0.5 expanded preview data\n  to include inclusive & exclusive ratios.\n- Version SLOG 2.0.6 expanded preview data\n  to include the count of real drawables.\n  \n- 2.0.1 viewer draws 2.0.0 logfile's\n  state nesting stack incorrectly!\n- 2.0.2 viewer cannot read 2.0.1 logfile.\n- 2.0.3 viewer draws 2.0.2 logfile's\n  preview weight incorrectly.\n- 2.0.4 viewer supports JOIN method and\n  can display 2.0.3 logfile correctly.\n- 2.0.5 viewer cannot read 2.0.4 logfile.\n- 2.0.6 viewer cannot read 2.0.5 logfile.\n" + "\n" + "Do you still want to continue reading " + "the logfile ?")) {
            this.slog_ins = null;
            return null;
        }
        this.slog_ins.initialize();
        this.legend_frame = new LegendFrame(this.slog_ins);
        this.legend_frame.pack();
        TopWindow.layoutIdealLocations();
        this.legend_frame.setVisible(true);
        return this.slog_ins.getLineIDMapList();
    }

    public void createTimelineWindow(final int view_ID) {
        if (this.slog_ins != null && view_ID >= 0) {
            SwingWorker create_timeline_worker = new SwingWorker(){

                public Object construct() {
                    LogFileOperations.this.timeline_frame = new TimelineFrame(LogFileOperations.this.slog_ins, view_ID);
                    return null;
                }

                public void finished() {
                    LogFileOperations.this.timeline_frame.pack();
                    TopWindow.layoutIdealLocations();
                    LogFileOperations.this.timeline_frame.setVisible(true);
                    LogFileOperations.this.timeline_frame.init();
                }
            };
            create_timeline_worker.start();
        }
    }

    public void showLegendWindow() {
        if (this.slog_ins != null && this.legend_frame != null) {
            this.legend_frame.pack();
            TopWindow.layoutIdealLocations();
            this.legend_frame.setVisible(true);
        }
    }

    public void showPreferenceWindow() {
        if (this.pptys_frame != null) {
            this.pptys_frame.pack();
            TopWindow.layoutIdealLocations();
            this.pptys_frame.setVisible(true);
            this.pptys_frame.toFront();
        }
    }
}

