/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ToolBarStatus;
import viewer.zoomable.YaxisTree;

public class ActionTimelineDelete
implements ActionListener {
    private Window root_window;
    private ToolBarStatus toolbar;
    private YaxisTree tree;
    private DefaultTreeModel tree_model;

    public ActionTimelineDelete(Window parent_window, ToolBarStatus in_toolbar, YaxisTree in_tree) {
        this.root_window = parent_window;
        this.toolbar = in_toolbar;
        this.tree = in_tree;
        this.tree_model = (DefaultTreeModel)this.tree.getModel();
    }

    public void actionPerformed(ActionEvent event) {
        int idx;
        if (Debug.isActive()) {
            Debug.println("Action for Delete Timeline button");
        }
        if (!Dialogs.confirm(this.root_window, "Are you sure to PERMANENTLY delete the marked items?")) {
            return;
        }
        TreePath[] child_paths = this.tree.getFromCutAndPasteBuffer();
        if (child_paths.length < 1) {
            Dialogs.warn(this.root_window, "Nothing has been marked for removal!");
            return;
        }
        for (idx = 0; idx < child_paths.length; ++idx) {
            if (!this.tree.isExpanded(child_paths[idx])) continue;
            if (Debug.isActive()) {
                Debug.println("\tCollapse " + child_paths[idx]);
            }
            this.tree.collapsePath(child_paths[idx]);
        }
        for (idx = 0; idx < child_paths.length; ++idx) {
            MutableTreeNode child = (MutableTreeNode)child_paths[idx].getLastPathComponent();
            this.tree_model.removeNodeFromParent(child);
            if (!Debug.isActive()) continue;
            Debug.println("\tCut " + child);
        }
        this.tree.clearCutAndPasteBuffer();
        this.tree.update_leveled_paths();
        this.toolbar.getTimelineMarkButton().setEnabled(true);
        this.toolbar.getTimelineMoveButton().setEnabled(false);
        this.toolbar.getTimelineDeleteButton().setEnabled(false);
        this.toolbar.resetYaxisTreeButtons();
    }
}

