/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.CategorySummary;
import base.drawable.ColorAlpha;
import base.drawable.InfoType;
import base.drawable.Method;
import base.drawable.Topology;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Category
implements MixedDataIO {
    private int index;
    private String name;
    private Topology topo;
    private ColorAlpha color;
    private int width;
    private String[] infokeys;
    private InfoType[] infotypes;
    private Method[] methods;
    private CategorySummary summary;
    private boolean hasBeenUsed;
    private boolean isVisible;
    private boolean isSearchable;
    private static final int PREVIEW_EVENT_INDEX = -1;
    private static final int PREVIEW_ARROW_INDEX = -2;
    private static final int PREVIEW_STATE_INDEX = -3;

    public Category() {
        this.infokeys = null;
        this.infotypes = null;
        this.methods = null;
        this.summary = new CategorySummary();
        this.hasBeenUsed = false;
        this.isVisible = true;
        this.isSearchable = true;
    }

    public Category(int in_idx, String in_name, Topology in_topo, ColorAlpha in_color, int in_width) {
        this.index = in_idx;
        this.name = in_name;
        this.topo = in_topo;
        this.color = in_color;
        this.width = in_width;
        this.infokeys = null;
        this.infotypes = null;
        this.methods = null;
        this.summary = new CategorySummary();
        this.hasBeenUsed = false;
        this.isVisible = true;
        this.isSearchable = true;
    }

    public Category(int obj_idx, String obj_name, int obj_width) {
        this.index = obj_idx;
        this.name = obj_name;
        this.width = obj_width;
        this.infokeys = null;
        this.infotypes = null;
        this.methods = null;
        this.summary = new CategorySummary();
        this.hasBeenUsed = false;
        this.isVisible = true;
        this.isSearchable = true;
    }

    public int getIndex() {
        return this.index;
    }

    public void setUsed(boolean new_value) {
        this.hasBeenUsed = new_value;
    }

    public boolean isUsed() {
        return this.hasBeenUsed;
    }

    public void setVisible(boolean new_value) {
        this.isVisible = new_value;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setSearchable(boolean new_value) {
        this.isSearchable = new_value;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public boolean isVisiblySearchable() {
        return this.isVisible && this.isSearchable;
    }

    public void setName(String in_name) {
        this.name = in_name;
    }

    public String getName() {
        return this.name;
    }

    public void setTopology(Topology in_topo) {
        this.topo = in_topo;
    }

    public Topology getTopology() {
        return this.topo;
    }

    public void setColor(ColorAlpha in_color) {
        this.color = in_color;
    }

    public ColorAlpha getColor() {
        return this.color;
    }

    public void setWidth(int in_width) {
        this.width = in_width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setInfoKeys(String labels) {
        if (labels != null) {
            StringTokenizer str_tokens = new StringTokenizer(labels, "%", true);
            int Ntokens = str_tokens.countTokens();
            if (Ntokens > 0) {
                int idx;
                ArrayList<String> keylist = new ArrayList<String>();
                ArrayList<InfoType> typelist = new ArrayList<InfoType>();
                while (str_tokens.hasMoreTokens()) {
                    String str1 = str_tokens.nextToken();
                    if (str1.length() == 1 && str1.equals("%")) {
                        String str2 = str_tokens.nextToken();
                        typelist.add(new InfoType(str2.charAt(0)));
                        str1 = str2.substring(1);
                    }
                    keylist.add(str1);
                }
                if (keylist.size() > 0) {
                    this.infokeys = new String[keylist.size()];
                    Iterator keys = keylist.iterator();
                    idx = 0;
                    while (keys.hasNext()) {
                        this.infokeys[idx] = (String)keys.next();
                        ++idx;
                    }
                } else {
                    this.infokeys = null;
                }
                if (typelist.size() > 0) {
                    this.infotypes = new InfoType[typelist.size()];
                    Iterator types = typelist.iterator();
                    idx = 0;
                    while (types.hasNext()) {
                        this.infotypes[idx] = (InfoType)types.next();
                        ++idx;
                    }
                } else {
                    this.infotypes = null;
                }
            }
        } else {
            this.infokeys = null;
            this.infotypes = null;
        }
    }

    public void setInfoKeys(String[] in_infokeys) {
        this.infokeys = in_infokeys;
    }

    public String[] getInfoKeys() {
        return this.infokeys;
    }

    public void setInfoTypes(InfoType[] in_infotypes) {
        this.infotypes = in_infotypes;
    }

    public InfoType[] getInfoTypes() {
        return this.infotypes;
    }

    public void setMethodIDs(int[] methodIDs) {
        if (methodIDs != null && methodIDs.length > 0) {
            this.methods = new Method[methodIDs.length];
            for (int idx = 0; idx < methodIDs.length; ++idx) {
                this.methods[idx] = new Method(methodIDs[idx]);
            }
        } else {
            this.methods = null;
        }
    }

    public void setMethods(Method[] in_methods) {
        this.methods = in_methods;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public CategorySummary getSummary() {
        return this.summary;
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        int idx;
        outs.writeInt(this.index);
        outs.writeString(this.name);
        this.topo.writeObject(outs);
        this.color.writeObject(outs);
        outs.writeByte(this.width);
        if (this.infokeys != null && this.infokeys.length > 0) {
            outs.writeShort((short)this.infokeys.length);
            for (idx = 0; idx < this.infokeys.length; ++idx) {
                outs.writeString(this.infokeys[idx]);
            }
        } else {
            outs.writeShort(0);
        }
        if (this.infotypes != null && this.infotypes.length > 0) {
            outs.writeShort((short)this.infotypes.length);
            for (idx = 0; idx < this.infotypes.length; ++idx) {
                this.infotypes[idx].writeObject(outs);
            }
        } else {
            outs.writeShort(0);
        }
        if (this.methods != null && this.methods.length > 0) {
            outs.writeShort((short)this.methods.length);
            for (idx = 0; idx < this.methods.length; ++idx) {
                this.methods[idx].writeObject(outs);
            }
        } else {
            outs.writeShort(0);
        }
        this.summary.writeObject(outs);
    }

    public Category(MixedDataInput ins) throws IOException {
        this();
        this.readObject(ins);
    }

    public void readObject(MixedDataInput ins) throws IOException {
        int idx;
        this.index = ins.readInt();
        this.name = ins.readString();
        this.topo = new Topology(ins);
        this.color = new ColorAlpha(ins);
        this.width = ins.readByte();
        int Nelem = ins.readShort();
        if (Nelem > 0) {
            this.infokeys = new String[Nelem];
            for (idx = 0; idx < Nelem; ++idx) {
                this.infokeys[idx] = ins.readString();
            }
        } else {
            this.infokeys = null;
        }
        if ((Nelem = ins.readShort()) > 0) {
            this.infotypes = new InfoType[Nelem];
            for (idx = 0; idx < Nelem; ++idx) {
                this.infotypes[idx] = new InfoType(ins);
            }
        } else {
            this.infotypes = null;
        }
        if ((Nelem = ins.readShort()) > 0) {
            this.methods = new Method[Nelem];
            for (idx = 0; idx < Nelem; ++idx) {
                this.methods[idx] = new Method(ins);
            }
        } else {
            this.methods = null;
        }
        this.summary.readObject(ins);
    }

    public String toString() {
        int idx;
        StringBuffer rep = new StringBuffer("Category[ ");
        rep.append("index=" + this.index + ", name=" + this.name + ", topo=" + this.topo + ", color=" + this.color + ", isUsed=" + this.hasBeenUsed + ", width=" + this.width);
        if (this.infokeys != null && this.infokeys.length > 0 || this.infotypes != null && this.infotypes.length > 0) {
            rep.append(", info_fmt=< ");
            int infokeys_length = this.infokeys != null ? this.infokeys.length : 0;
            int infotypes_length = this.infotypes != null ? this.infotypes.length : 0;
            int max_length = Math.max(infokeys_length, infotypes_length);
            for (idx = 0; idx < max_length; ++idx) {
                if (idx < infokeys_length) {
                    rep.append(this.infokeys[idx]);
                }
                if (idx >= infotypes_length) continue;
                rep.append(this.infotypes[idx]);
            }
            rep.append(" >");
        }
        if (this.methods != null && this.methods.length > 0) {
            rep.append(", methods=< ");
            for (idx = 0; idx < this.methods.length; ++idx) {
                rep.append(this.methods[idx] + " ");
            }
            rep.append(">");
        }
        rep.append(", vis=" + this.isVisible);
        rep.append(", search=" + this.isSearchable);
        rep.append(", " + this.summary);
        rep.append(" ]");
        return rep.toString();
    }

    public boolean isShadowCategory() {
        return this.index < 0;
    }

    public static Category getShadowCategory(Topology aTopo) {
        if (aTopo.isEvent()) {
            Category type = new Category(-1, "Preview_" + aTopo.toString(), aTopo, ColorAlpha.WHITE_NEAR_OPAQUE, 5);
            return type;
        }
        if (aTopo.isArrow()) {
            Category type = new Category(-2, "Preview_" + aTopo.toString(), aTopo, ColorAlpha.YELLOW_OPAQUE, 5);
            return type;
        }
        if (aTopo.isState()) {
            Category type = new Category(-3, "Preview_" + aTopo.toString(), aTopo, ColorAlpha.WHITE_NEAR_OPAQUE, 5);
            return type;
        }
        return null;
    }
}

