/*
 * Decompiled with CFR 0.152.
 */
package logformat.clogTOdrawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Composite;
import base.drawable.InputAPI;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.clog.MixedDataInputStream;
import logformat.clog.RecColl;
import logformat.clog.RecComm;
import logformat.clog.RecDefMsg;
import logformat.clog.RecDefState;
import logformat.clog.RecEvent;
import logformat.clog.RecHeader;
import logformat.clog.RecMsg;
import logformat.clog.RecRaw;
import logformat.clog.RecSrc;
import logformat.clog.RecTshift;
import logformat.clogTOdrawable.ColorNameMap;
import logformat.clogTOdrawable.ObjDef;
import logformat.clogTOdrawable.ObjMethod;
import logformat.clogTOdrawable.Topo_Arrow;
import logformat.clogTOdrawable.Topo_State;
import logformat.clogTOdrawable.TwoEventsMatching;

public class InputLog
extends logformat.clog.InputLog
implements InputAPI {
    private MixedDataInputStream blk_ins;
    private long total_bytesize;
    private int rectype;
    private Map evtdefs = new HashMap();
    private List topos = new ArrayList();
    private ObjDef statedef;
    private ObjDef arrowdef;
    private Primitive drawobj;
    private RecHeader header;
    private RecDefState def;
    private RecRaw raw;
    private RecColl coll;
    private RecComm comm;
    private RecEvent event;
    private RecMsg msg;
    private RecSrc src;
    private RecTshift tshift;
    private Topo_Arrow arrowform;
    private Topo_State stateform;
    private Object[] arglist;
    private boolean isFirstPeekForCategory;
    private int num_topology_returned;

    public InputLog(String pathname) {
        super(pathname);
        ColorNameMap.initMapFromRGBtxt("jumpshot.colors");
        ObjDef.setFirstNextCategoryIndex(0);
        this.arrowform = new Topo_Arrow();
        int def_idx = ObjDef.getNextCategoryIndex();
        this.arrowdef = new ObjDef(def_idx, new RecDefMsg(), this.arrowform, 3);
        this.arrowdef.setInfoKeys("msg_tag=%d, msg_size=%d");
        this.arrowdef.setColor(new ColorAlpha(this.arrowdef.getColor(), 255));
        this.arrowform.setCategory(this.arrowdef);
        this.evtdefs.put(this.arrowdef.start_evt, this.arrowform.getStartEventObjMethod());
        this.evtdefs.put(this.arrowdef.final_evt, this.arrowform.getFinalEventObjMethod());
        List defs = RecDefState.getMPIinitUndefinedStateDefs();
        defs.addAll(RecDefState.getUSERinitUndefinedStateDefs());
        Iterator itr = defs.iterator();
        while (itr.hasNext()) {
            this.def = (RecDefState)itr.next();
            this.stateform = new Topo_State();
            def_idx = ObjDef.getNextCategoryIndex();
            this.statedef = new ObjDef(def_idx, this.def, this.stateform, 1);
            this.stateform.setCategory(this.statedef);
            this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
            this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
        }
        this.header = new RecHeader();
        this.def = new RecDefState();
        this.raw = new RecRaw();
        this.coll = new RecColl();
        this.comm = new RecComm();
        this.event = new RecEvent();
        this.msg = new RecMsg();
        this.src = new RecSrc();
        this.tshift = new RecTshift();
        this.arglist = new Object[2];
        this.total_bytesize = 0L;
        this.num_topology_returned = 0;
        this.isFirstPeekForCategory = true;
        this.blk_ins = super.getBlockStream();
    }

    public Kind peekNextKind() {
        if (this.num_topology_returned < 3) {
            return Kind.TOPOLOGY;
        }
        if (this.isFirstPeekForCategory) {
            return Kind.CATEGORY;
        }
        while (this.blk_ins != null) {
            this.rectype = 0;
            block17: while (this.rectype != -1 && this.rectype != -2) {
                int bytes_read = this.header.readFromDataStream(this.blk_ins);
                this.total_bytesize += (long)bytes_read;
                this.rectype = this.header.getRecType();
                switch (this.rectype) {
                    case 6: {
                        bytes_read = this.def.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        ObjMethod obj_meth1 = (ObjMethod)this.evtdefs.get(this.def.startetype);
                        ObjMethod obj_meth2 = (ObjMethod)this.evtdefs.get(this.def.endetype);
                        if (obj_meth1 == null || obj_meth2 == null) {
                            this.stateform = new Topo_State();
                            int idx = ObjDef.getNextCategoryIndex();
                            this.statedef = new ObjDef(idx, this.def, this.stateform, 1);
                            this.stateform.setCategory(this.statedef);
                            this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
                            this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
                        } else if (obj_meth1.obj == obj_meth2.obj) {
                            this.stateform = (Topo_State)obj_meth1.obj;
                            this.statedef = (ObjDef)this.stateform.getCategory();
                            this.statedef.setName(this.def.description);
                            this.statedef.setColor(ColorNameMap.getColorAlpha(this.def.color));
                        } else {
                            System.err.println("**** Error! " + obj_meth1.obj + "!=" + obj_meth2.obj);
                        }
                        return Kind.CATEGORY;
                    }
                    case 1: {
                        bytes_read = this.raw.readFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        int raw_etype = this.raw.etype;
                        if (raw_etype == -201 || raw_etype == 0) continue block17;
                        ObjMethod evt_pairing = (ObjMethod)this.evtdefs.get(this.raw.etype);
                        this.arglist[0] = this.header;
                        this.arglist[1] = this.raw;
                        this.drawobj = null;
                        try {
                            this.drawobj = (Primitive)evt_pairing.method.invoke(evt_pairing.obj, this.arglist);
                        }
                        catch (IllegalAccessException err) {
                            err.printStackTrace();
                            System.err.println("Offending RecRaw = " + this.raw);
                        }
                        catch (InvocationTargetException err) {
                            err.printStackTrace();
                        }
                        catch (NullPointerException nullerr) {
                            nullerr.printStackTrace();
                            System.err.println("Offending RecHeader = " + this.header);
                            System.err.println("Offending RecRaw = " + this.raw);
                            System.exit(1);
                        }
                        if (this.drawobj == null) continue block17;
                        return Kind.PRIMITIVE;
                    }
                    case 3: {
                        bytes_read = this.coll.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        continue block17;
                    }
                    case 4: {
                        bytes_read = this.comm.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        continue block17;
                    }
                    case 5: {
                        bytes_read = this.event.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        continue block17;
                    }
                    case 2: {
                        bytes_read = this.msg.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        continue block17;
                    }
                    case 7: {
                        bytes_read = this.src.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        continue block17;
                    }
                    case 8: {
                        bytes_read = this.tshift.skipBytesFromDataStream(this.blk_ins);
                        this.total_bytesize += (long)bytes_read;
                        continue block17;
                    }
                    case -1: {
                        this.blk_ins = super.getBlockStream();
                        continue block17;
                    }
                    case -2: {
                        this.blk_ins = null;
                        continue block17;
                    }
                }
                System.err.println("Unknown Record type = " + this.rectype);
            }
        }
        return Kind.EOF;
    }

    public Topology getNextTopology() {
        switch (this.num_topology_returned) {
            case 0: {
                this.num_topology_returned = 1;
                return Topology.EVENT;
            }
            case 1: {
                this.num_topology_returned = 2;
                return Topology.STATE;
            }
            case 2: {
                this.num_topology_returned = 3;
                return Topology.ARROW;
            }
        }
        System.err.println("All Topology Names have been returned");
        return null;
    }

    public Category getNextCategory() {
        if (this.isFirstPeekForCategory) {
            this.isFirstPeekForCategory = false;
            this.topos.add(this.arrowdef.getTopology());
            return this.arrowdef;
        }
        this.topos.add(this.statedef.getTopology());
        return this.statedef;
    }

    public Primitive getNextPrimitive() {
        return this.drawobj;
    }

    public Composite getNextComposite() {
        return null;
    }

    public YCoordMap getNextYCoordMap() {
        return null;
    }

    public long getTotalBytesRead() {
        return this.total_bytesize;
    }

    public List getAllUsedTopos() {
        return this.topos;
    }

    public long getNumberOfUnMatchedEvents() {
        int Nunmatched = 0;
        Iterator topos_itr = this.topos.iterator();
        while (topos_itr.hasNext()) {
            Nunmatched += ((TwoEventsMatching)topos_itr.next()).getPartialObjects().size();
        }
        return Nunmatched;
    }
}

