/*
 * Decompiled with CFR 0.152.
 */
package viewer.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import viewer.common.Dialogs;
import viewer.common.RuntimeExecCommand;

public class Launcher {
    private static String setupfile_path = null;
    private static String FileSeparator = "/";
    private static String PathSeparator = ":";
    private static String JavaHome = null;
    private static String ClassPath = null;
    private static String UserHome = null;
    private static final String VERSION_INFO = "1.0.0.1";
    private static String JVM = "java";
    private static String JVM_OPTIONS = "-Xms64m -Xmx256m";
    private static String VIEWER_JAR = "jumpshot.jar";
    private static boolean VERBOSE = true;
    private static final String CONFIGURATION_HEADER = "# Jumpshot-4 Launcher setup file.\n#VERSION_INFO: version-ID of the jumpshot-launcher.\n#JVM: Java Virtual Machine name, can be absolute path.\n#JVM_OPTIONS: JVM launch parameters.\n#VIEWER_JAR: executable jar file to be launched.\n#VERBOSE: be informative about this setup file change, true(yes) or false(no).\n";

    private static void initializeSystemProperties() {
        Properties sys_pptys = System.getProperties();
        FileSeparator = sys_pptys.getProperty("file.separator");
        PathSeparator = sys_pptys.getProperty("path.separator");
        JavaHome = sys_pptys.getProperty("java.home");
        ClassPath = sys_pptys.getProperty("java.class.path");
        UserHome = sys_pptys.getProperty("user.home");
    }

    private static void initializeLauncherConstants() {
        JVM = FileSeparator.equals("/") ? "java" : "javaw.exe";
        setupfile_path = UserHome + FileSeparator + ".jumpshot_launcher.conf";
    }

    private static String readLauncherConstants() {
        Properties setup_pptys = new Properties();
        try {
            FileInputStream fins = new FileInputStream(setupfile_path);
            setup_pptys.load(fins);
            fins.close();
        }
        catch (FileNotFoundException fioerr) {
            return "This is your first time using the launcher.\nA launcher setup file, " + setupfile_path + ",\n" + "will be created in your home directory.";
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
        StringBuffer msgbuf = null;
        String ppty_val = setup_pptys.getProperty("VERSION_INFO");
        if (!VERSION_INFO.equals(ppty_val)) {
            msgbuf = new StringBuffer();
            if (ppty_val != null) {
                msgbuf.append("Your setup file verion is " + ppty_val + ".\n");
            } else {
                msgbuf.append("Your setup file verion is older.\n");
            }
            msgbuf.append("This launcher version is 1.0.0.1.\n");
        }
        if ((ppty_val = setup_pptys.getProperty("JVM")) != null && !JVM.equals(ppty_val)) {
            if (msgbuf == null) {
                msgbuf = new StringBuffer();
            } else {
                msgbuf.append("\n");
            }
            msgbuf.append("The default JVM, " + JVM + ",\n" + "is overriden by value, " + ppty_val + ",\n" + "specified in your setup file.\n");
            JVM = ppty_val;
        }
        if ((ppty_val = setup_pptys.getProperty("JVM_OPTIONS")) != null && !JVM_OPTIONS.equals(ppty_val)) {
            if (msgbuf == null) {
                msgbuf = new StringBuffer();
            } else {
                msgbuf.append("\n");
            }
            msgbuf.append("The default JVM_OPTIONS, " + JVM_OPTIONS + ",\n" + "is overriden by value, " + ppty_val + ",\n" + "specified in your setup file.\n");
            JVM_OPTIONS = ppty_val;
        }
        if ((ppty_val = setup_pptys.getProperty("VIEWER_JAR")) != null && !VIEWER_JAR.equals(ppty_val)) {
            if (msgbuf == null) {
                msgbuf = new StringBuffer();
            } else {
                msgbuf.append("\n");
            }
            msgbuf.append("The default VIEWER_JAR, " + VIEWER_JAR + ",\n" + "is overriden by value, " + ppty_val + ",\n" + "specified in your setup file.\n");
            VIEWER_JAR = ppty_val;
        }
        if ((ppty_val = setup_pptys.getProperty("VERBOSE")) != null) {
            boolean bl = VERBOSE = ppty_val.equalsIgnoreCase("true") || ppty_val.equalsIgnoreCase("yes");
        }
        if (msgbuf != null) {
            return msgbuf.toString();
        }
        return null;
    }

    private static void writeLauncherConstants() {
        Properties setup_pptys = new Properties();
        try {
            FileOutputStream fouts = new FileOutputStream(setupfile_path);
            setup_pptys.setProperty("VERSION_INFO", VERSION_INFO);
            setup_pptys.setProperty("JVM", JVM);
            setup_pptys.setProperty("JVM_OPTIONS", JVM_OPTIONS);
            setup_pptys.setProperty("VIEWER_JAR", VIEWER_JAR);
            setup_pptys.setProperty("VERBOSE", String.valueOf(VERBOSE));
            setup_pptys.store(fouts, CONFIGURATION_HEADER);
            fouts.close();
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            System.exit(1);
        }
    }

    private static String getDefaultPathToJVM() {
        String path2jvm = null;
        File jvm_file = new File(JVM);
        path2jvm = jvm_file.isAbsolute() ? JVM : JavaHome + FileSeparator + "bin" + FileSeparator + JVM;
        return path2jvm;
    }

    private static String getDefaultPathToJarDir() {
        String path2jardir = null;
        StringTokenizer paths = new StringTokenizer(ClassPath, PathSeparator);
        while (paths.hasMoreTokens() && path2jardir == null) {
            String path = paths.nextToken();
            int char_idx = path.lastIndexOf(FileSeparator);
            if (char_idx < 0) continue;
            path2jardir = path.substring(0, char_idx);
        }
        return path2jardir;
    }

    private static String getDefaultJarPath(String prefix) {
        if (prefix != null && prefix.length() > 0) {
            return prefix + FileSeparator + VIEWER_JAR;
        }
        return VIEWER_JAR;
    }

    private String exec(String[] exec_cmd_ary) {
        StringBuffer proc_err_buf = new StringBuffer();
        StringBuffer proc_out_buf = null;
        int proc_istatus = 0;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proc = runtime.exec(exec_cmd_ary);
            InputStreamThread proc_err_task = new InputStreamThread(proc.getErrorStream(), "Error", proc_err_buf);
            InputStreamThread proc_out_task = new InputStreamThread(proc.getInputStream(), "Output", proc_out_buf);
            proc_err_task.start();
            proc_out_task.start();
            proc_istatus = proc.waitFor();
            proc_err_task.stopRunning();
            proc_err_task = null;
            proc_out_task.stopRunning();
            proc_out_task = null;
            if (proc_istatus != 0) {
                return proc_err_buf.toString();
            }
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        return null;
    }

    public static final void main(String[] argv) {
        String path2jvm;
        File jvm_file;
        String path2jardir;
        String jar_path;
        File jar_file;
        Launcher.initializeSystemProperties();
        Launcher.initializeLauncherConstants();
        String setupfile_msg = Launcher.readLauncherConstants();
        if (setupfile_msg != null) {
            if (VERBOSE) {
                Dialogs.info(null, setupfile_msg, null);
            }
            Launcher.writeLauncherConstants();
        }
        if (!(jar_file = new File(jar_path = Launcher.getDefaultJarPath(path2jardir = Launcher.getDefaultPathToJarDir()))).exists()) {
            Dialogs.error(null, jar_path + " does not exist!\n" + "Make sure that " + VIEWER_JAR + " is in " + "the same directory as this launcher.\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!jar_file.canRead()) {
            Dialogs.error(null, jar_path + " is NOT readable!\n" + "Reset the read privilege of the file, " + VIEWER_JAR + ".\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!(jvm_file = new File(path2jvm = Launcher.getDefaultPathToJVM())).exists()) {
            Dialogs.error(null, path2jvm + " does not exist!\n" + "Make sure that " + path2jvm + " exists.\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!jvm_file.canRead()) {
            Dialogs.error(null, path2jvm + " is NOT readable!\n" + "Reset the read privilege of the file, " + path2jvm + ".\n" + "Then restart this program again.");
            System.exit(1);
        }
        String opt4jvm = JVM_OPTIONS;
        RuntimeExecCommand exec_cmd = new RuntimeExecCommand();
        exec_cmd.addWholeString(path2jvm);
        exec_cmd.addTokenizedString(opt4jvm);
        exec_cmd.addWholeString("-jar");
        exec_cmd.addWholeString(jar_path);
        Launcher launcher = new Launcher();
        String exec_err_msg = launcher.exec(exec_cmd.toStringArray());
        if (exec_err_msg != null) {
            Dialogs.error(null, "The following process exits with error:\n" + exec_cmd.toString() + "\n" + exec_err_msg);
            System.exit(1);
        }
        System.exit(0);
    }

    private class InputStreamThread
    extends Thread {
        private InputStream ins;
        private String prefix;
        private StringBuffer outbuffer;
        private boolean isRunning;

        public InputStreamThread(InputStream the_ins, String the_prefix, StringBuffer the_outbuffer) {
            this.ins = the_ins;
            this.prefix = the_prefix;
            this.outbuffer = the_outbuffer;
            this.isRunning = true;
        }

        public void stopRunning() {
            this.isRunning = false;
        }

        public void run() {
            try {
                String line = null;
                InputStreamReader ins_rdr = new InputStreamReader(this.ins);
                BufferedReader buf_rdr = new BufferedReader(ins_rdr);
                while (this.isRunning && (line = buf_rdr.readLine()) != null) {
                    System.out.println(this.prefix + " > " + line);
                    if (this.outbuffer == null) continue;
                    this.outbuffer.append(line + "\n");
                }
            }
            catch (IOException ioerr) {
                ioerr.printStackTrace();
            }
        }
    }
}

