/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Coord;
import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class TimeBoundingBox
implements DataIO {
    public static final TimeBoundingBox ALL_TIMES = new TimeBoundingBox(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Order INCRE_STARTTIME_ORDER = new IncreasingStarttimeOrder();
    public static final Order DECRE_STARTTIME_ORDER = new DecreasingStarttimeOrder();
    public static final Order INCRE_FINALTIME_ORDER = new IncreasingFinaltimeOrder();
    public static final Order DECRE_FINALTIME_ORDER = new DecreasingFinaltimeOrder();
    public static final int BYTESIZE = 16;
    private double earliest_time;
    private double latest_time;

    public TimeBoundingBox() {
        this.earliest_time = Double.POSITIVE_INFINITY;
        this.latest_time = Double.NEGATIVE_INFINITY;
    }

    public TimeBoundingBox(TimeBoundingBox timebox) {
        this.earliest_time = timebox.earliest_time;
        this.latest_time = timebox.latest_time;
    }

    public TimeBoundingBox(Coord[] vtxs) {
        if (vtxs != null) {
            this.earliest_time = this.latest_time = vtxs[0].time;
            for (int idx = 1; idx < vtxs.length; ++idx) {
                this.affectEarliestTime(vtxs[idx].time);
                this.affectLatestTime(vtxs[idx].time);
            }
        } else {
            this.earliest_time = Double.POSITIVE_INFINITY;
            this.latest_time = Double.NEGATIVE_INFINITY;
        }
    }

    public TimeBoundingBox(double starttime, double finaltime) {
        this.earliest_time = starttime;
        this.latest_time = finaltime;
    }

    public void reinitialize() {
        this.earliest_time = Double.POSITIVE_INFINITY;
        this.latest_time = Double.NEGATIVE_INFINITY;
    }

    public void affectTimeBounds(TimeBoundingBox endtimes) {
        this.affectEarliestTime(endtimes.getEarliestTime());
        this.affectLatestTime(endtimes.getLatestTime());
    }

    public void affectTimeBounds(Coord vtx) {
        this.affectEarliestTime(vtx.time);
        this.affectLatestTime(vtx.time);
    }

    public void affectTimeBounds(Coord[] vtxs) {
        for (int idx = 0; idx < vtxs.length; ++idx) {
            this.affectEarliestTime(vtxs[idx].time);
            this.affectLatestTime(vtxs[idx].time);
        }
    }

    public void affectEarliestTime(double in_time) {
        if (in_time < this.earliest_time) {
            this.earliest_time = in_time;
        }
    }

    public void setEarliestTime(double in_time) {
        this.earliest_time = in_time;
    }

    public double getEarliestTime() {
        return this.earliest_time;
    }

    public void affectLatestTime(double in_time) {
        if (in_time > this.latest_time) {
            this.latest_time = in_time;
        }
    }

    public void setLatestTime(double in_time) {
        this.latest_time = in_time;
    }

    public double getLatestTime() {
        return this.latest_time;
    }

    public double getBorderTime(boolean isStartTime) {
        if (isStartTime) {
            return this.earliest_time;
        }
        return this.latest_time;
    }

    public void setLatestFromEarliest(double time_extent) {
        this.latest_time = this.earliest_time + time_extent;
    }

    public void setEarliestFromLatest(double time_extent) {
        this.earliest_time = this.latest_time - time_extent;
    }

    public boolean isTimeOrdered() {
        return this.earliest_time <= this.latest_time;
    }

    public boolean remove(TimeBoundingBox endtimes) {
        if (this.earliest_time == endtimes.earliest_time) {
            this.earliest_time = endtimes.latest_time;
            return true;
        }
        if (this.latest_time == endtimes.latest_time) {
            this.latest_time = endtimes.earliest_time;
            return true;
        }
        return false;
    }

    public boolean covers(TimeBoundingBox endtimes) {
        return this.earliest_time <= endtimes.earliest_time && endtimes.latest_time <= this.latest_time;
    }

    public boolean overlaps(TimeBoundingBox endtimes) {
        return this.earliest_time <= endtimes.latest_time && endtimes.earliest_time <= this.latest_time;
    }

    public boolean disjoints(TimeBoundingBox endtimes) {
        return this.latest_time < endtimes.earliest_time || endtimes.latest_time < this.earliest_time;
    }

    public boolean contains(double timestamp) {
        return this.earliest_time <= timestamp && timestamp <= this.latest_time;
    }

    public boolean equals(TimeBoundingBox endtimes) {
        return this.earliest_time == endtimes.earliest_time && this.latest_time == endtimes.latest_time;
    }

    public boolean containsWithinLeft(double timestamp) {
        return this.earliest_time <= timestamp && timestamp < this.latest_time;
    }

    public boolean containsWithinRight(double timestamp) {
        return this.earliest_time < timestamp && timestamp <= this.latest_time;
    }

    public TimeBoundingBox getIntersection(TimeBoundingBox endtimes) {
        if (this.overlaps(endtimes)) {
            double intersect_earliest_time = this.earliest_time < endtimes.earliest_time ? endtimes.earliest_time : this.earliest_time;
            double intersect_latest_time = this.latest_time < endtimes.latest_time ? this.latest_time : endtimes.latest_time;
            TimeBoundingBox intersect_endtimes = new TimeBoundingBox();
            intersect_endtimes.earliest_time = intersect_earliest_time;
            intersect_endtimes.latest_time = intersect_latest_time;
            return intersect_endtimes;
        }
        return null;
    }

    public double getIntersectionDuration(TimeBoundingBox endtimes) {
        if (this.overlaps(endtimes)) {
            double intersect_earliest_time;
            double intersect_latest_time = this.latest_time < endtimes.latest_time ? this.latest_time : endtimes.latest_time;
            double intersect_duration = intersect_latest_time - (intersect_earliest_time = this.earliest_time < endtimes.earliest_time ? endtimes.earliest_time : this.earliest_time);
            if (intersect_duration > 0.0) {
                return intersect_duration;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getDuration() {
        return this.latest_time - this.earliest_time;
    }

    public void setZeroDuration(double time) {
        this.earliest_time = time;
        this.latest_time = time;
    }

    public static void writeObject(TimeBoundingBox timebox, DataOutput outs) throws IOException {
        outs.writeDouble(timebox.earliest_time);
        outs.writeDouble(timebox.latest_time);
    }

    public static void readObject(TimeBoundingBox timebox, DataInput ins) throws IOException {
        timebox.earliest_time = ins.readDouble();
        timebox.latest_time = ins.readDouble();
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeDouble(this.earliest_time);
        outs.writeDouble(this.latest_time);
    }

    public TimeBoundingBox(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.earliest_time = ins.readDouble();
        this.latest_time = ins.readDouble();
    }

    public String toString() {
        return "TimeBBox(" + this.earliest_time + "," + this.latest_time + ")";
    }

    public String toShortString() {
        return "TimeBBox(" + (float)this.earliest_time + "," + (float)this.latest_time + ")";
    }

    public static final void main(String[] args) {
        TimeBoundingBox timebox = new TimeBoundingBox();
        System.out.println(timebox);
        if (INCRE_STARTTIME_ORDER.equals(DECRE_STARTTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=DECRE_STARTTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!DECRE_STARTTIME_ORDER");
        }
        if (INCRE_STARTTIME_ORDER.equals(INCRE_FINALTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=INCRE_FINALTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!INCRE_FINALTIME_ORDER");
        }
        if (INCRE_STARTTIME_ORDER.equals(DECRE_FINALTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=DECRE_FINALTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!DECRE_FINALTIME_ORDER");
        }
        if (INCRE_STARTTIME_ORDER.equals(INCRE_STARTTIME_ORDER)) {
            System.out.println("INCRE_STARTTIME_ORDER=INCRE_STARTTIME_ORDER");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!INCRE_STARTTIME_ORDER");
        }
        IncreasingStarttimeOrder tmp_order = new IncreasingStarttimeOrder();
        if (INCRE_STARTTIME_ORDER.equals(tmp_order)) {
            System.out.println("INCRE_STARTTIME_ORDER=tmp_order");
        } else {
            System.out.println("INCRE_STARTTIME_ORDER!tmp_order");
        }
    }

    private static class DecreasingFinaltimeOrder
    implements Order {
        private DecreasingFinaltimeOrder() {
        }

        public int compare(Object o1, Object o2) {
            TimeBoundingBox timebox1 = (TimeBoundingBox)o1;
            TimeBoundingBox timebox2 = (TimeBoundingBox)o2;
            if (timebox1.latest_time != timebox2.latest_time) {
                return timebox1.latest_time > timebox2.latest_time ? -1 : 1;
            }
            if (timebox1.earliest_time != timebox2.earliest_time) {
                return timebox1.earliest_time < timebox2.earliest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return false;
        }

        public boolean isStartTimeOrdered() {
            return false;
        }

        public String toString() {
            return "DECRE_FINALTIME_ORDER";
        }
    }

    private static class IncreasingFinaltimeOrder
    implements Order {
        private IncreasingFinaltimeOrder() {
        }

        public int compare(Object o1, Object o2) {
            TimeBoundingBox timebox1 = (TimeBoundingBox)o1;
            TimeBoundingBox timebox2 = (TimeBoundingBox)o2;
            if (timebox1.latest_time != timebox2.latest_time) {
                return timebox1.latest_time < timebox2.latest_time ? -1 : 1;
            }
            if (timebox1.earliest_time != timebox2.earliest_time) {
                return timebox1.earliest_time > timebox2.earliest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return true;
        }

        public boolean isStartTimeOrdered() {
            return false;
        }

        public String toString() {
            return "INCRE_FINALTIME_ORDER";
        }
    }

    private static class DecreasingStarttimeOrder
    implements Order {
        private DecreasingStarttimeOrder() {
        }

        public int compare(Object o1, Object o2) {
            TimeBoundingBox timebox1 = (TimeBoundingBox)o1;
            TimeBoundingBox timebox2 = (TimeBoundingBox)o2;
            if (timebox1.earliest_time != timebox2.earliest_time) {
                return timebox1.earliest_time > timebox2.earliest_time ? -1 : 1;
            }
            if (timebox1.latest_time != timebox2.latest_time) {
                return timebox1.latest_time < timebox2.latest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return false;
        }

        public boolean isStartTimeOrdered() {
            return true;
        }

        public String toString() {
            return "DECRE_STARTTIME_ORDER";
        }
    }

    private static class IncreasingStarttimeOrder
    implements Order {
        private IncreasingStarttimeOrder() {
        }

        public int compare(Object o1, Object o2) {
            TimeBoundingBox timebox1 = (TimeBoundingBox)o1;
            TimeBoundingBox timebox2 = (TimeBoundingBox)o2;
            if (timebox1.earliest_time != timebox2.earliest_time) {
                return timebox1.earliest_time < timebox2.earliest_time ? -1 : 1;
            }
            if (timebox1.latest_time != timebox2.latest_time) {
                return timebox1.latest_time > timebox2.latest_time ? -1 : 1;
            }
            return 0;
        }

        public boolean isIncreasingTimeOrdered() {
            return true;
        }

        public boolean isStartTimeOrdered() {
            return true;
        }

        public String toString() {
            return "INCRE_STARTTIME_ORDER";
        }
    }

    public static interface Order
    extends Comparator {
        public boolean isIncreasingTimeOrdered();

        public boolean isStartTimeOrdered();

        public String toString();
    }
}

