/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Topology
implements DataIO {
    public static final int EVENT_ID = 0;
    public static final int STATE_ID = 1;
    public static final int ARROW_ID = 2;
    public static final Topology EVENT = new Topology(0);
    public static final Topology STATE = new Topology(1);
    public static final Topology ARROW = new Topology(2);
    private int index;

    public Topology(int in_index) {
        this.index = in_index;
    }

    public boolean equals(Topology aTopo) {
        return this.index == aTopo.index;
    }

    public boolean equals(Object obj) {
        return this.equals((Topology)obj);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean isEvent() {
        return this.index == 0;
    }

    public boolean isState() {
        return this.index == 1;
    }

    public boolean isArrow() {
        return this.index == 2;
    }

    public boolean isPrimitive() {
        return this.index == 1 || this.index == 2 || this.index == 0;
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeInt(this.index);
    }

    public Topology(DataInput ins) throws IOException {
        this.index = ins.readInt();
    }

    public void readObject(DataInput ins) throws IOException {
        this.index = ins.readInt();
    }

    public String toString() {
        switch (this.index) {
            case 0: {
                return "Event";
            }
            case 1: {
                return "State";
            }
            case 2: {
                return "Arrow";
            }
        }
        return "Unknown";
    }
}

