/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.io.MixedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.slog2.BufForDrawables;
import logformat.slog2.BufForShadows;
import logformat.slog2.LineIDMap;
import logformat.slog2.TreeNodeID;

public class TreeNode
extends BufForDrawables {
    private List shadowbufs = new ArrayList();
    private boolean haveShadowBufsBeenSaved = false;
    private BufForShadows shadowbuf = null;
    private Map shadowdefs_map = null;
    private TreeNode childnode = null;

    public TreeNode() {
        super(true);
    }

    public TreeNode(TreeNode previous_node) {
        this();
        this.childnode = previous_node;
    }

    private void ensureNonNullShadowBuf() {
        if (this.shadowbuf == null) {
            this.shadowbuf = new BufForShadows(true);
            this.shadowbuf.setMapOfTopologyToShadowDef(this.shadowdefs_map);
        }
    }

    public void setTreeNodeID(TreeNodeID new_ID) {
        super.setTreeNodeID(new_ID);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.setTreeNodeID(new_ID);
    }

    public void setMapOfTopologyToShadowDef(Map in_shadefs) {
        this.shadowdefs_map = in_shadefs;
    }

    public void add(Drawable dobj) {
        if (dobj instanceof Composite) {
            Composite cmplx = (Composite)dobj;
            Primitive[] primes = null;
            if (cmplx.getCategory() != null) {
                super.add(cmplx);
                this.ensureNonNullShadowBuf();
                primes = cmplx.getPrimitives();
                for (int idx = 0; idx < primes.length; ++idx) {
                    this.shadowbuf.add(primes[idx]);
                }
            } else {
                this.ensureNonNullShadowBuf();
                primes = cmplx.getPrimitives();
                for (int idx = 0; idx < primes.length; ++idx) {
                    super.add(primes[idx]);
                    this.shadowbuf.add(primes[idx]);
                }
            }
        } else {
            Primitive prime = (Primitive)dobj;
            super.add(prime);
            this.ensureNonNullShadowBuf();
            this.shadowbuf.add(prime);
        }
    }

    public void empty() {
        if (this.childnode != null && this.childnode.haveShadowBufsBeenSaved) {
            Iterator belowbufs = this.childnode.shadowbufs.iterator();
            while (belowbufs.hasNext()) {
                ((BufForShadows)belowbufs.next()).empty();
            }
            this.childnode.shadowbufs.clear();
            this.childnode.haveShadowBufsBeenSaved = false;
        }
        super.empty();
    }

    public void finalizeLatestTime(Drawable last_drawable_added) {
        if (this.childnode == null) {
            super.setLatestTime(last_drawable_added.getLatestTime());
        } else {
            super.setLatestTime(this.childnode.getLatestTime());
        }
        if (this.shadowbuf != null) {
            this.shadowbuf.setLatestTime(super.getLatestTime());
            this.shadowbuf.initializeMapOfCategoryWeights();
        }
    }

    public void mergeVerticalShadowBufs() {
        if (this.childnode != null) {
            Iterator belowbufs = this.childnode.shadowbufs.iterator();
            while (belowbufs.hasNext()) {
                BufForShadows buf = (BufForShadows)belowbufs.next();
                this.shadowbuf.mergeWith(buf);
                this.shadowbuf.affectTimeBounds(buf);
            }
        }
    }

    public void shiftHorizontalShadowBuf() {
        if (this.shadowbuf != null) {
            this.shadowbuf.finalizeMapOfCategoryWeights();
            this.shadowbufs.add(this.shadowbuf);
            this.shadowbuf = null;
        }
    }

    public void affectEarliestTime(double in_time) {
        super.affectEarliestTime(in_time);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.affectEarliestTime(in_time);
    }

    public void setEarliestTime(double in_time) {
        super.setEarliestTime(in_time);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.setEarliestTime(in_time);
    }

    public void setFileBlockPtr(long in_fptr, int in_size) {
        super.setFileBlockPtr(in_fptr, in_size);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.setFileBlockPtr(in_fptr, in_size);
    }

    public int getNodeByteSize() {
        int total_bytesize = super.getByteSize() + 4;
        if (this.childnode != null) {
            Iterator belowbufs = this.childnode.shadowbufs.iterator();
            while (belowbufs.hasNext()) {
                BufForShadows buf = (BufForShadows)belowbufs.next();
                total_bytesize += buf.getByteSize();
            }
        }
        return total_bytesize;
    }

    public LineIDMap getIdentityLineIDMap() {
        LineIDMap lineIDmap = super.getIdentityLineIDMap();
        if (this.childnode != null) {
            Iterator belowbufs = this.childnode.shadowbufs.iterator();
            while (belowbufs.hasNext()) {
                BufForShadows belowbuf = (BufForShadows)belowbufs.next();
                lineIDmap.putAll(belowbuf.getIdentityLineIDMap());
            }
        }
        lineIDmap.setTitle("Identity Map");
        lineIDmap.setColumnLabels(new String[]{"LineID"});
        return lineIDmap;
    }

    public void summarizeCategories() {
        if (this.shadowbuf != null) {
            throw new RuntimeException("UnexpectedError: shadowbuf is NOT NULL! Aborting...");
        }
        if (this.shadowbufs.size() != 1) {
            throw new RuntimeException("UnexpectedError: shadowbufs[]'s size is " + this.shadowbufs.size() + "! Aborting...");
        }
        this.shadowbuf = (BufForShadows)this.shadowbufs.get(0);
        this.shadowbuf.summarizeCategories();
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        super.writeObject(outs);
        if (this.childnode != null) {
            outs.writeInt(this.childnode.shadowbufs.size());
            Iterator belowbufs = this.childnode.shadowbufs.iterator();
            while (belowbufs.hasNext()) {
                ((BufForShadows)belowbufs.next()).writeObject(outs);
            }
            this.childnode.haveShadowBufsBeenSaved = true;
        } else {
            outs.writeInt(0);
        }
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("\t*** Start of TreeNode ***\n");
        rep.append(super.toString() + "\n");
        if (this.childnode != null) {
            Iterator belowbufs = this.childnode.shadowbufs.iterator();
            int buf_idx = 1;
            while (belowbufs.hasNext()) {
                BufForShadows belowbuf = (BufForShadows)belowbufs.next();
                rep.append("\t BufForShadows No. " + buf_idx + "\n");
                rep.append(belowbuf + "\n");
                ++buf_idx;
            }
        }
        rep.append("\t*** End of TreeNode ***\n");
        return rep.toString();
    }

    public String toStringForInput() {
        StringBuffer rep = new StringBuffer("\t*** Start of TreeNode ***\n");
        rep.append(super.toString() + "\n");
        Iterator sobj_bufs = this.shadowbufs.iterator();
        int buf_idx = 1;
        while (sobj_bufs.hasNext()) {
            BufForShadows sobj_buf = (BufForShadows)sobj_bufs.next();
            rep.append("\t BufForShadows No. " + buf_idx + "\n");
            rep.append(sobj_buf + "\n");
            ++buf_idx;
        }
        rep.append("\t*** End of TreeNode ***\n");
        return rep.toString();
    }
}

