/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import logformat.slog2.input.InputLog;
import viewer.common.TopWindow;
import viewer.legends.LegendTable;

public class LegendPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 2900L;
    private LegendTable legend_table;
    private JButton all_btn;
    private JButton clear_btn;
    private JButton close_btn;

    public LegendPanel(InputLog slog_ins) {
        super.setLayout(new BoxLayout(this, 1));
        Border lowered_border = BorderFactory.createLoweredBevelBorder();
        Border empty_border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        Border etched_border = BorderFactory.createEtchedBorder();
        this.legend_table = new LegendTable(slog_ins.getCategoryMap());
        JScrollPane scroller = new JScrollPane(this.legend_table, 22, 32);
        scroller.setBorder(BorderFactory.createCompoundBorder(lowered_border, BorderFactory.createCompoundBorder(empty_border, etched_border)));
        super.add(scroller);
        JPanel select_panel = new JPanel();
        select_panel.setLayout(new BoxLayout(select_panel, 0));
        select_panel.add(Box.createHorizontalGlue());
        this.all_btn = new JButton("Select");
        this.all_btn.setToolTipText("Select all Legends");
        this.all_btn.addActionListener(this);
        select_panel.add(this.all_btn);
        select_panel.add(Box.createHorizontalGlue());
        this.clear_btn = new JButton("Deselect");
        this.clear_btn.setToolTipText("Deselect all Legends");
        this.clear_btn.addActionListener(this);
        select_panel.add(this.clear_btn);
        select_panel.add(Box.createHorizontalGlue());
        TitledBorder titled_border = BorderFactory.createTitledBorder(etched_border, " All ");
        select_panel.setBorder(titled_border);
        super.add(select_panel);
        JPanel end_panel = new JPanel();
        end_panel.setLayout(new BoxLayout(end_panel, 0));
        end_panel.add(Box.createHorizontalGlue());
        this.close_btn = new JButton("close");
        this.close_btn.setToolTipText("Hide this panel");
        this.close_btn.addActionListener(this);
        end_panel.add(this.close_btn);
        end_panel.add(Box.createHorizontalGlue());
        super.add(end_panel);
    }

    public void actionPerformed(ActionEvent evt) {
        Object evt_src = evt.getSource();
        if (evt_src == this.close_btn) {
            TopWindow.Legend.setVisible(false);
        } else if (evt_src == this.all_btn) {
            this.legend_table.selectAll();
        } else if (evt_src == this.clear_btn) {
            this.legend_table.clearSelection();
        }
    }
}

