/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CFORMCHANGESENSORPOSITIONS_H
#define CFORMCHANGESENSORPOSITIONS_H

//(*Headers(CFormChangeSensorPositions)
#include <wx/spinctrl.h>
#include <wx/combobox.h>
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/notebook.h>
#include <wx/button.h>
#include <wx/radiobut.h>
#include <wx/panel.h>
#include <wx/statline.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/radiobox.h>
//*)

#include <wx/combobox.h>

#include <mrpt/slam/CActionCollection.h>
#include <mrpt/slam/CSensoryFrame.h>



class CFormChangeSensorPositions: public wxDialog
{
	public:

		/** Used in executeOperationOnRawlogFiles
		  */
		typedef void (*TRawlogFilter)( mrpt::slam::CActionCollection *acts, mrpt::slam::CSensoryFrame *SF, int &changesCount  );

		/** This is the common function for all operations over a rawlog file ("filter" a rawlog file into a new one) or over the loaded rawlog (depending on the user selection in the GUI).
		  */
		void executeOperationOnRawlog( TRawlogFilter operation, const char *endMsg);

		CFormChangeSensorPositions(wxWindow* parent,wxWindowID id=wxID_ANY);
		virtual ~CFormChangeSensorPositions();


		//(*Declarations(CFormChangeSensorPositions)
		wxTextCtrl* edCX;
		wxStaticText* StaticText24;
		wxStaticText* StaticText22;
		wxTextCtrl* edP2;
		wxPanel* Panel1;
		wxStaticText* StaticText21;
		wxTextCtrl* edX;
		wxStaticText* StaticText13;
		wxRadioBox* rbApply;
		wxStaticText* StaticText14;
		wxTextCtrl* edY;
		wxStaticText* StaticText15;
		wxButton* btnPickInput;
		wxComboBox* edLabel;
		wxStaticText* StaticText17;
		wxStaticText* StaticText28;
		wxTextCtrl* edZ;
		wxTextCtrl* txtOutputFile;
		wxTextCtrl* edRoll;
		wxStaticText* StaticText20;
		wxStaticText* StaticText18;
		wxTextCtrl* edPitch;
		wxStaticText* StaticText1;
		wxStaticText* StaticText10;
		wxButton* btnPickOut;
		wxRadioButton* rbFile;
		wxStaticText* StaticText16;
		wxFlexGridSizer* FlexGridSizer14;
		wxTextCtrl* edP1;
		wxPanel* Panel2;
		wxStaticText* StaticText3;
		wxTextCtrl* edFocalLen;
		wxStaticText* StaticText23;
		wxStaticLine* StaticLine1;
		wxTextCtrl* edK1;
		wxStaticText* StaticText8;
		wxStaticText* StaticText12;
		wxTextCtrl* edYaw;
		wxStaticText* StaticText7;
		wxRadioButton* rbLoaded;
		wxStaticText* StaticText4;
		wxTextCtrl* edK2;
		wxTextCtrl* edFY;
		wxStaticText* StaticText5;
		wxStaticText* StaticText2;
		wxStaticText* StaticText30;
		wxStaticText* StaticText27;
		wxNotebook* Notebook1;
		wxStaticText* StaticText26;
		wxStaticText* StaticText6;
		wxButton* btnOK;
		wxButton* btnCancel;
		wxSpinCtrl* scIndex;
		wxButton* btnGetCurPose;
		wxButton* btnGetCurCamModel;
		wxTextCtrl* edFX;
		wxTextCtrl* txtInputFile;
		wxStaticText* StaticText19;
		wxButton* btnApplyCameraParams;
		wxStaticText* StaticText9;
		wxTextCtrl* edCY;
		wxStaticText* StaticText11;
		wxStaticText* StaticText25;
		wxCheckBox* cbOnlyXYZ;
		//*)

	protected:

		//(*Identifiers(CFormChangeSensorPositions)
		static const long ID_RADIOBUTTON1;
		static const long ID_RADIOBUTTON2;
		static const long ID_STATICTEXT27;
		static const long ID_TEXTCTRL16;
		static const long ID_BUTTON9;
		static const long ID_STATICTEXT28;
		static const long ID_TEXTCTRL17;
		static const long ID_BUTTON11;
		static const long ID_STATICLINE1;
		static const long ID_RADIOBOX1;
		static const long ID_STATICTEXT15;
		static const long ID_SPINCTRL1;
		static const long ID_STATICTEXT30;
		static const long ID_COMBOBOX1;
		static const long ID_STATICTEXT16;
		static const long ID_STATICTEXT1;
		static const long ID_STATICTEXT2;
		static const long ID_STATICTEXT3;
		static const long ID_TEXTCTRL1;
		static const long ID_STATICTEXT4;
		static const long ID_STATICTEXT5;
		static const long ID_TEXTCTRL2;
		static const long ID_STATICTEXT6;
		static const long ID_STATICTEXT7;
		static const long ID_TEXTCTRL3;
		static const long ID_STATICTEXT8;
		static const long ID_STATICTEXT9;
		static const long ID_TEXTCTRL4;
		static const long ID_STATICTEXT10;
		static const long ID_STATICTEXT11;
		static const long ID_TEXTCTRL5;
		static const long ID_STATICTEXT12;
		static const long ID_STATICTEXT13;
		static const long ID_TEXTCTRL6;
		static const long ID_STATICTEXT14;
		static const long ID_CHECKBOX1;
		static const long ID_BUTTON3;
		static const long ID_BUTTON1;
		static const long ID_PANEL1;
		static const long ID_STATICTEXT17;
		static const long ID_STATICTEXT18;
		static const long ID_TEXTCTRL7;
		static const long ID_STATICTEXT19;
		static const long ID_TEXTCTRL8;
		static const long ID_STATICTEXT20;
		static const long ID_TEXTCTRL9;
		static const long ID_STATICTEXT21;
		static const long ID_TEXTCTRL10;
		static const long ID_STATICTEXT23;
		static const long ID_TEXTCTRL12;
		static const long ID_STATICTEXT24;
		static const long ID_TEXTCTRL13;
		static const long ID_STATICTEXT25;
		static const long ID_TEXTCTRL14;
		static const long ID_STATICTEXT26;
		static const long ID_TEXTCTRL15;
		static const long ID_STATICTEXT22;
		static const long ID_TEXTCTRL11;
		static const long ID_BUTTON4;
		static const long ID_BUTTON5;
		static const long ID_PANEL2;
		static const long ID_NOTEBOOK1;
		static const long ID_BUTTON2;
		//*)

	private:

		//(*Handlers(CFormChangeSensorPositions)
		void OnbtnCancelClick(wxCommandEvent& event);
		void OnbtnOKClick(wxCommandEvent& event);
		void OnbtnGetCurPoseClick(wxCommandEvent& event);
		void OnbtnGetCurCamModelClick(wxCommandEvent& event);
		void OnbtnGetCurPoseClick1(wxCommandEvent& event);
		void OnbtnApplyCameraParamsClick(wxCommandEvent& event);
		void OnrbLoadedSelect(wxCommandEvent& event);
		void OnrbFileSelect(wxCommandEvent& event);
		void OnbtnPickInputClick(wxCommandEvent& event);
		void OnbtnPickOutClick(wxCommandEvent& event);
		void OnInit(wxInitDialogEvent& event);
		void OnrbApplySelect(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()
};

#endif
