/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  CLevenbergMarquardt_H
#define  CLevenbergMarquardt_H

#include <mrpt/utils/CDebugOutputCapable.h>
#include <mrpt/math/CMatrixD.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace mrpt
{
namespace math
{
	/** An implementation of the Levenberg-Marquardt algorithm for least-square minimization.
	 *
	 *  Refer to the <a href="http://babel.isa.uma.es/mrpt/index.php/Levenberg%E2%80%93Marquardt_algorithm">wiki page</a> for more details on the algorithm and usage.
	 *
	 */
	class MRPTDLLIMPEXP CLevenbergMarquardt : public mrpt::utils::CDebugOutputCapable
	{
	public:

		struct TResultInfo
		{
			double		final_sqr_err;
			size_t		iterations_executed;
			CMatrixD	path;	//!< Each row is the optimized value at each iteration.
		};

		/** Executes the LM-method, with derivatives estimated from 
		  *  "functor" Is a user-provided function which takes as input two vectors, in this order:
		  *		- x: The parameters to be optimized.
		  *		- userParam: The vector passed to the LM algorithm, unmodified.
		  *	  and must return the "error vector", or the error (not squared) in each measured dimension, so the sum of the square of that output is the overall square error.
		  */
		static void	execute(
			vector_double				&out_optimal_x,
			const vector_double			&x0,
			utils::TFunctor_retVecDbl_inp2VecDbl	functor,
			const vector_double			&increments,
			const vector_double			&userParam,
			TResultInfo					&out_info,
			bool						verbose = false,
			const size_t				&maxIter = 200,
			const double				tau = 1e-3,
			const double				e1 = 1e-8,
			const double				e2 = 1e-8 
			);


	}; // End of class def.

	} // End of namespace
} // End of namespace
#endif
