/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef opengl_CDisk_H
#define opengl_CDisk_H

#include <mrpt/opengl/CRenderizable.h>

namespace mrpt
{
	namespace opengl
	{
		class MRPTDLLIMPEXP CDisk;

		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE_PRE_CUSTOM_BASE( CDisk, CRenderizable )

		/** A planar disk in the XY plane.
		  *  \sa opengl::COpenGLScene
		  */
		class MRPTDLLIMPEXP CDisk : public CRenderizable
		{
			DEFINE_SERIALIZABLE( CDisk )
		public:
			float	m_radiusIn,m_radiusOut;
			int		m_nSlices, m_nLoops;

			/** Class factory  */
			static CDiskPtr Create()
			{
				return CDiskPtr( new CDisk() );
			}

			/** Render
			  */
			void  render();

		private:
			/** Constructor
			  */
			CDisk( ) :
				m_radiusIn(0),
				m_radiusOut(1),
				m_nSlices(50),
				m_nLoops(4)
			{
			}
			/** Private, virtual destructor: only can be deleted from smart pointers */
			virtual ~CDisk() { }
		};

	} // end namespace

} // End of namespace


#endif
