/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CPTG7_H
#define CPTG7_H

#include "CParameterizedTrajectoryGenerator.h"

namespace mrpt
{
  namespace reactivenav
  {
	/** A PTG for circular paths.
	 */
	class RNAVDLLIMPEXP  CPTG7 : public CParameterizedTrajectoryGenerator
	{
	 public:
			/** Constructor 
			  */
			CPTG7(	float	refDistance, 
					float	xResolution, 
					float	yResolution, 
					float	V_MAX, 
					float	W_MAX,
					float	system_TAU,
					float	system_DELAY,
					vector_float	securityDistances,

					float	cte_a0v, 
					float	cte_a0w );

			/** The lambda function.
			  */
			void lambdaFunction( float x, float y, int &out_k, float &out_d );
			
			/** Gets a short textual description of the PTG and its parameters.
			*/
			std::string getDescription();

			bool PTG_IsIntoDomain( float x, float y );

			void PTG_Generator( float alfa, float t,float x, float y, float phi, float &v, float &w );
	 protected:
			float	cte_a0v;
			float	cte_a0w;

	
	};
  }
}


#endif

